# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: activity/v4/natday.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class BooksResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["BooksData"] = betterproto.message_field(3)


@dataclass
class BooksData(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 子标题 时间
    sub1: str = betterproto.string_field(4)
    # 子标题 爆更
    sub2: str = betterproto.string_field(5)


@dataclass
class FavAllReq(betterproto.Message):
    # 漫画ID
    cids: List[int] = betterproto.int32_field(1)


@dataclass
class ExchangeReq(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class BetReq(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class ReadChallengeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ReadChallengeData" = betterproto.message_field(3)


@dataclass
class ReadChallengeData(betterproto.Message):
    # 当前时间
    now: str = betterproto.string_field(1)
    # 总人数
    total: int = betterproto.int32_field(2)
    # 当日阅读数
    read: int = betterproto.int32_field(3)
    # 一阶段阅读任务 -1：已完成 0：未完成 >0：对应完成积分
    task1: List[int] = betterproto.int32_field(4)
    # 二阶段阅读任务 -1：已完成 0：未完成
    task2: List[int] = betterproto.int32_field(5)
    # 已投注
    bet_done: int = betterproto.int32_field(6)
    # 已完成任务
    task_done: int = betterproto.int32_field(7)
    # 获得积分
    reward: int = betterproto.int32_field(8)
    # 剩余兑换积分
    remain: int = betterproto.int32_field(9)
    # 已兑换奖励
    exchange: int = betterproto.int32_field(10)
    # 超过用户
    percent: int = betterproto.int32_field(11)
    # 一阶段连续天数
    continuity: int = betterproto.int32_field(12)
    # 二阶段完成天数
    complete: int = betterproto.int32_field(13)
    # 总阅读天数
    days: int = betterproto.int32_field(14)
    # 用户总积分
    point: int = betterproto.int32_field(15)


@dataclass
class HomeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "HomeData" = betterproto.message_field(3)


@dataclass
class HomeData(betterproto.Message):
    now: str = betterproto.string_field(1)
    # 首充用户 1-是 0-否
    first: int = betterproto.int32_field(2)
    # 1-实验组 2-对照组
    test: int = betterproto.int32_field(3)
    # 开通过连续包年 1-是 0-否
    year: int = betterproto.int32_field(4)
    # 弹窗 1-已弹
    window: int = betterproto.int32_field(5)


@dataclass
class EmptyRequest1(betterproto.Message):
    pass


@dataclass
class DefaultResponse1(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData1" = betterproto.message_field(3)


@dataclass
class EmptyData1(betterproto.Message):
    pass


class NatdayStub(betterproto.ServiceStub):
    """2020国庆活动"""

    @allure.step("""首页""")
    def home(self, request: EmptyRequest1) -> HomeResp:
        """首页"""
        logging.getLogger(__name__).info(
            "start call " + "[home]" + " api" + "=>" + """首页"""
        )
        response = HomeResp()
        self._do_twirp_rpc("/activity.v4.Natday/Home", request, response)
        logging.getLogger(__name__).info("call " + "[home]" + " api success!")
        return response

    @allure.step("""爆更书单""")
    def update_books(self, request: EmptyRequest1) -> BooksResp:
        """爆更书单"""
        logging.getLogger(__name__).info(
            "start call " + "[update_books]" + " api" + "=>" + """爆更书单"""
        )
        response = BooksResp()
        self._do_twirp_rpc("/activity.v4.Natday/UpdateBooks", request, response)
        logging.getLogger(__name__).info("call " + "[update_books]" + " api success!")
        return response

    @allure.step("""打折书单""")
    def discount_books(self, request: EmptyRequest1) -> BooksResp:
        """打折书单"""
        logging.getLogger(__name__).info(
            "start call " + "[discount_books]" + " api" + "=>" + """打折书单"""
        )
        response = BooksResp()
        self._do_twirp_rpc("/activity.v4.Natday/DiscountBooks", request, response)
        logging.getLogger(__name__).info("call " + "[discount_books]" + " api success!")
        return response

    @allure.step("""佳作书单""")
    def hot_books(self, request: EmptyRequest1) -> BooksResp:
        """佳作书单"""
        logging.getLogger(__name__).info(
            "start call " + "[hot_books]" + " api" + "=>" + """佳作书单"""
        )
        response = BooksResp()
        self._do_twirp_rpc("/activity.v4.Natday/HotBooks", request, response)
        logging.getLogger(__name__).info("call " + "[hot_books]" + " api success!")
        return response

    @allure.step("""一键追漫""")
    def fav_all(self, request: FavAllReq) -> DefaultResponse1:
        """一键追漫"""
        logging.getLogger(__name__).info(
            "start call " + "[fav_all]" + " api" + "=>" + """一键追漫"""
        )
        response = DefaultResponse1()
        self._do_twirp_rpc("/activity.v4.Natday/FavAll", request, response)
        logging.getLogger(__name__).info("call " + "[fav_all]" + " api success!")
        return response

    @allure.step("""阅读挑战-首页""")
    def read_challenge(self, request: EmptyRequest1) -> ReadChallengeResp:
        """阅读挑战-首页"""
        logging.getLogger(__name__).info(
            "start call " + "[read_challenge]" + " api" + "=>" + """阅读挑战-首页"""
        )
        response = ReadChallengeResp()
        self._do_twirp_rpc("/activity.v4.Natday/ReadChallenge", request, response)
        logging.getLogger(__name__).info("call " + "[read_challenge]" + " api success!")
        return response

    @allure.step("""阅读挑战-下注""")
    def bet(self, request: BetReq) -> DefaultResponse1:
        """阅读挑战-下注"""
        logging.getLogger(__name__).info(
            "start call " + "[bet]" + " api" + "=>" + """阅读挑战-下注"""
        )
        response = DefaultResponse1()
        self._do_twirp_rpc("/activity.v4.Natday/Bet", request, response)
        logging.getLogger(__name__).info("call " + "[bet]" + " api success!")
        return response

    @allure.step("""阅读挑战-兑换""")
    def exchange(self, request: ExchangeReq) -> DefaultResponse1:
        """阅读挑战-兑换"""
        logging.getLogger(__name__).info(
            "start call " + "[exchange]" + " api" + "=>" + """阅读挑战-兑换"""
        )
        response = DefaultResponse1()
        self._do_twirp_rpc("/activity.v4.Natday/Exchange", request, response)
        logging.getLogger(__name__).info("call " + "[exchange]" + " api success!")
        return response

    @allure.step("""购买弹窗""")
    def window(self, request: EmptyRequest1) -> DefaultResponse1:
        """购买弹窗"""
        logging.getLogger(__name__).info(
            "start call " + "[window]" + " api" + "=>" + """购买弹窗"""
        )
        response = DefaultResponse1()
        self._do_twirp_rpc("/activity.v4.Natday/Window", request, response)
        logging.getLogger(__name__).info("call " + "[window]" + " api success!")
        return response
