# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: activity/v2/activity.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class GiftStatusReq(betterproto.Message):
    type: int = betterproto.int32_field(1)
    id: int = betterproto.int32_field(2)


@dataclass
class GiftStatusResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GiftStatusData" = betterproto.message_field(3)


@dataclass
class GiftStatusData(betterproto.Message):
    # 领取状态
    receive: int = betterproto.int32_field(1)
    # 领取时间
    time: str = betterproto.string_field(2)


@dataclass
class TimeMachineResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "TimeMachineData" = betterproto.message_field(3)


@dataclass
class TimeMachineData(betterproto.Message):
    # 用户信息
    user_info: "TimeMachineData1" = betterproto.message_field(1)
    # 首次登录
    first_time: str = betterproto.string_field(2)
    # 距今X天
    day: str = betterproto.string_field(3)
    # 阅读数量
    read_cnt: int = betterproto.int32_field(4)
    # 追漫数量
    fav_cnt: int = betterproto.int32_field(5)
    # 偏爱类型
    fav_tags: List[str] = betterproto.string_field(6)
    # 习惯阅读时间
    read_time: str = betterproto.string_field(7)
    # 有X%人和你一样
    read_same: int = betterproto.int32_field(8)
    # 最晚阅读信息
    last_read: "TimeMachineData2" = betterproto.message_field(9)
    # 评论数
    comment_cnt: int = betterproto.int32_field(10)
    # 评论点赞最多漫画
    comment_comic: str = betterproto.string_field(11)
    # 解锁漫画数
    comic_cnt: int = betterproto.int32_field(12)
    # 解锁漫画章节数
    ep_cnt: int = betterproto.int32_field(13)
    # 解锁超过X%
    ep_cnt_percent: int = betterproto.int32_field(14)
    # 解锁最多作品
    ep_comic: str = betterproto.string_field(15)
    # 解锁最多作品封面
    ep_comic_cover: str = betterproto.string_field(16)
    # 应援最多作品
    support_comic: str = betterproto.string_field(17)
    # 应援最多作品封面
    support_comic_cover: str = betterproto.string_field(18)
    # 推荐漫画
    recommend_comic: List["TimeMachineData3"] = betterproto.message_field(19)
    # 关键字
    key_words: List[int] = betterproto.int32_field(20)
    # 首次进入（隐私弹窗）
    first_entry: int = betterproto.int32_field(21)
    # 解锁最多作品ID
    ep_comic_id: int = betterproto.int32_field(22)
    # 应援最多作品ID
    support_comic_id: int = betterproto.int32_field(23)


@dataclass
class TimeMachineData1(betterproto.Message):
    # 用户ID
    uid: int = betterproto.int64_field(1)
    # 用户头像
    face: str = betterproto.string_field(2)
    # 昵称
    name: str = betterproto.string_field(3)


@dataclass
class TimeMachineData2(betterproto.Message):
    # 最晚阅读时间
    time: str = betterproto.string_field(1)
    # 最晚阅读漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 最晚阅读漫画标题
    title: str = betterproto.string_field(3)
    # 最晚阅读漫画封面
    cover: str = betterproto.string_field(4)


@dataclass
class TimeMachineData3(betterproto.Message):
    # 推荐漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 推荐漫画封面
    cover: str = betterproto.string_field(2)
    # 推荐漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class DoubleEggResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DoubleEggData" = betterproto.message_field(3)


@dataclass
class DoubleEggData(betterproto.Message):
    # 当前时间 RFC3339
    now: str = betterproto.string_field(1)
    # 累计签到次数
    total: int = betterproto.int32_field(2)
    # 今日已签
    done: int = betterproto.int32_field(3)


@dataclass
class DoubleEggSignResp(betterproto.Message):
    # 503-未登录 507-已签到
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DoubleEggSignData" = betterproto.message_field(3)


@dataclass
class DoubleEggSignData(betterproto.Message):
    # 累计签到次数
    total: int = betterproto.int32_field(1)


@dataclass
class TianguanResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "TianguanData" = betterproto.message_field(3)


@dataclass
class TianguanData(betterproto.Message):
    # 追漫人数
    fav: int = betterproto.int32_field(1)
    # 最新中奖用户
    user1: List["TianguanUser"] = betterproto.message_field(2)
    # 全部中奖用户
    user2: List["TianguanUser"] = betterproto.message_field(3)
    # 最新中奖用户
    user3: List["TianguanUser"] = betterproto.message_field(4)
    # 全部中奖用户
    user4: List["TianguanUser"] = betterproto.message_field(5)


@dataclass
class TianguanUser(betterproto.Message):
    uid: int = betterproto.int64_field(1)
    face: str = betterproto.string_field(2)
    name: str = betterproto.string_field(3)


@dataclass
class DecBattleRecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecBattleRecommendData" = betterproto.message_field(3)


@dataclass
class DecBattleRecommendData(betterproto.Message):
    # 推荐列表
    recommend_list: List["DecRecommendComic"] = betterproto.message_field(1)
    # 我的月票数
    tickets: int = betterproto.int32_field(2)


@dataclass
class DecBattleInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecBattleInitData" = betterproto.message_field(3)


@dataclass
class DecBattleInitData(betterproto.Message):
    step: int = betterproto.int32_field(1)
    now: str = betterproto.string_field(2)
    show: int = betterproto.int32_field(3)


@dataclass
class DecBattleReq(betterproto.Message):
    step: int = betterproto.int32_field(1)


@dataclass
class DecBattleResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecBattleData" = betterproto.message_field(3)


@dataclass
class DecBattleData(betterproto.Message):
    # 榜单
    rank_list: List["DecBattleComic"] = betterproto.message_field(1)
    # 结束时间
    end_time: str = betterproto.string_field(2)


@dataclass
class DecRecommendComic(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 月票数
    score: int = betterproto.int32_field(2)
    # 漫画名
    name: str = betterproto.string_field(3)
    # 封面
    cover: str = betterproto.string_field(4)
    # 排名 0表示排名外
    rank: int = betterproto.int32_field(5)
    # 还差多少月票
    next: int = betterproto.int32_field(6)
    # 原因
    reason: int = betterproto.int32_field(7)


@dataclass
class DecBattleComic(betterproto.Message):
    # 排名
    rank: int = betterproto.int32_field(1)
    # 漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 漫画名
    name: str = betterproto.string_field(3)
    # 封面
    cover: str = betterproto.string_field(4)
    # 月票数
    score: int = betterproto.int32_field(5)
    # 用户
    user: List["DecBattleUser"] = betterproto.message_field(6)
    # 奖励分
    extra: int = betterproto.int32_field(7)
    # 封面
    cover2: str = betterproto.string_field(8)


@dataclass
class DecBattleUser(betterproto.Message):
    # 排名
    rank: int = betterproto.int32_field(1)
    # 用户ID
    uid: int = betterproto.int64_field(2)
    # 用户头像
    face: str = betterproto.string_field(3)
    # 用户名
    name: str = betterproto.string_field(4)


@dataclass
class CelePicsReq(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class CelePicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["CelePicsData"] = betterproto.message_field(3)


@dataclass
class CelePicsData(betterproto.Message):
    # 图片
    url: str = betterproto.string_field(1)
    # 漫画名
    name: str = betterproto.string_field(2)
    # 作者
    author: str = betterproto.string_field(3)
    # 漫画ID
    cid: int = betterproto.int32_field(4)


@dataclass
class NovGiftReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class NovScoreResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "NovScoreData" = betterproto.message_field(3)


@dataclass
class NovScoreData(betterproto.Message):
    num: int = betterproto.int32_field(1)
    done: List[int] = betterproto.int32_field(2)


@dataclass
class CeleInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CeleInitData" = betterproto.message_field(3)


@dataclass
class CeleInitData(betterproto.Message):
    # 送券数
    coupon: int = betterproto.int32_field(1)
    # 已消费(总数)
    cost: int = betterproto.int32_field(2)
    # 再消费
    next: int = betterproto.int32_field(3)
    # 当前时间
    now: str = betterproto.string_field(4)
    # 关注状态
    status: int = betterproto.int32_field(5)
    # 领取状态
    done: int = betterproto.int32_field(6)


@dataclass
class WaitRankResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "WaitRankData" = betterproto.message_field(3)


@dataclass
class WaitRankData(betterproto.Message):
    myself: "WaitRankList" = betterproto.message_field(1)
    list: List["WaitRankList"] = betterproto.message_field(2)
    # 当前时间 RFC3339
    now: str = betterproto.string_field(3)


@dataclass
class WaitRankList(betterproto.Message):
    # 用户ID
    uid: int = betterproto.int64_field(1)
    # 用户昵称
    name: str = betterproto.string_field(2)
    # 用户头像
    face: str = betterproto.string_field(3)
    # 奖品ID
    prize: int = betterproto.int32_field(4)
    # 分数
    score: int = betterproto.int64_field(5)
    # 排名
    rank: int = betterproto.int32_field(6)


@dataclass
class BwInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BwInitData" = betterproto.message_field(3)


@dataclass
class BwInitData(betterproto.Message):
    hata: int = betterproto.int32_field(1)
    yuki: int = betterproto.int32_field(2)
    xiada: int = betterproto.int32_field(3)


@dataclass
class BwDrawReq(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class BwDrawResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["BwPrize"] = betterproto.message_field(3)


@dataclass
class BwListResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["BwPrize"] = betterproto.message_field(3)


@dataclass
class BwPrize(betterproto.Message):
    # 唯一标识
    id: int = betterproto.int32_field(1)
    # 奖品类型
    type: int = betterproto.int32_field(2)
    # 姓名
    name: str = betterproto.string_field(3)
    # 地址
    address: str = betterproto.string_field(4)
    # 手机号
    phone: str = betterproto.string_field(5)
    # QQ
    qq: str = betterproto.string_field(6)
    # 中奖时间
    date: str = betterproto.string_field(7)


@dataclass
class ConanListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ConanPrize"] = betterproto.message_field(3)


@dataclass
class ConanInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ConanInitData" = betterproto.message_field(3)


@dataclass
class ConanInitData(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class ConanReq(betterproto.Message):
    num: int = betterproto.int32_field(1)


@dataclass
class ConanResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ConanPrize"] = betterproto.message_field(3)


@dataclass
class ConanPrize(betterproto.Message):
    # 唯一标识
    id: int = betterproto.int32_field(1)
    # 奖品类型
    type: int = betterproto.int32_field(2)
    # 姓名
    name: str = betterproto.string_field(3)
    # 地址
    address: str = betterproto.string_field(4)
    # 手机号
    phone: str = betterproto.string_field(5)
    # QQ
    qq: str = betterproto.string_field(6)
    # 中奖时间
    date: str = betterproto.string_field(7)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class ZhongqiuInitReq(betterproto.Message):
    pass


@dataclass
class ZhongqiuInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ZhongqiuInitData" = betterproto.message_field(3)


@dataclass
class ZhongqiuInitData(betterproto.Message):
    # 抽奖次数
    num: int = betterproto.int32_field(1)
    # 奖品编号
    prizes: List[int] = betterproto.int32_field(2)
    # 当前时间 RFC3339
    now: str = betterproto.string_field(3)


@dataclass
class ZhongqiuDrawReq(betterproto.Message):
    # 仅支持输入 1-普通抽 10-高级抽
    pool: int = betterproto.int32_field(1)


@dataclass
class ZhongqiuDrawResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ZhongqiuPrize"] = betterproto.message_field(3)


@dataclass
class ZhongqiuPrize(betterproto.Message):
    # 唯一标识
    id: int = betterproto.int32_field(1)
    # 奖品类型
    type: int = betterproto.int32_field(2)
    # 姓名
    name: str = betterproto.string_field(3)
    # 地址
    address: str = betterproto.string_field(4)
    # 手机号
    phone: str = betterproto.string_field(5)
    # QQ
    qq: str = betterproto.string_field(6)
    # 中奖时间
    date: str = betterproto.string_field(7)


@dataclass
class ZhongqiuListReq(betterproto.Message):
    pass


@dataclass
class ZhongqiuListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ZhongqiuPrize"] = betterproto.message_field(3)


@dataclass
class NewUserResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "NewUserData" = betterproto.message_field(3)


@dataclass
class NewUserData(betterproto.Message):
    sven_day_new: bool = betterproto.bool_field(1)


@dataclass
class ActivityTempleteReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class ActivityTempleteResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class GetFissionInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FissionInfo" = betterproto.message_field(3)


@dataclass
class FissionInfo(betterproto.Message):
    # 已邀请人数
    invited_count: int = betterproto.int32_field(1)
    # 已获得卡券
    coupons: List["CouponInfo"] = betterproto.message_field(2)
    # 是否是新用户
    is_new_user: bool = betterproto.bool_field(3)


@dataclass
class CouponInfo(betterproto.Message):
    # 100 - 全场福利券 101 - 9 折卡 102 - 8 折卡
    type: int = betterproto.int32_field(1)
    amount: int = betterproto.int32_field(2)


@dataclass
class GetFissionRewardReq(betterproto.Message):
    # 通过 token 来获取老用户信息
    token: str = betterproto.string_field(1)
    # 分享人的 UID (用来手动领取)
    refid: int = betterproto.int64_field(2)


@dataclass
class GetFissionRewardResp(betterproto.Message):
    # 1 活动已下线 2 老用户不能获取该奖励 3 该用户或该设备已经获得该奖励 4 不能邀请自己 5 邀请人不存在 6 邀请人未绑定手机号 7
    # 用户未绑定手机号 8 不满足新人条件 9 用户手机号是虚拟号段(不支持虚拟号段)
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "InviteeReward" = betterproto.message_field(3)


@dataclass
class InviteeReward(betterproto.Message):
    # 漫读券数量
    coupons: int = betterproto.int32_field(1)


@dataclass
class DecQuestionInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecQuestionInitData" = betterproto.message_field(3)


@dataclass
class DecQuestionInitData(betterproto.Message):
    # 当前时间 RFC3339
    now: str = betterproto.string_field(1)
    # 昨天书单
    yesterday: List["DecQuestionComic"] = betterproto.message_field(2)
    # 今日书单
    today: List["DecQuestionComic"] = betterproto.message_field(3)
    # 明天书单
    tomorrow: List["DecQuestionComic"] = betterproto.message_field(4)
    # 题号(日期 1201~1208)
    qid: int = betterproto.int32_field(5)
    # 今日答题 1-已答 0-未答
    done: int = betterproto.int32_field(6)


@dataclass
class DecQuestionComic(betterproto.Message):
    # 漫画ID
    cid: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)


@dataclass
class DecQuestionSubmitReq(betterproto.Message):
    # 题号
    qid: int = betterproto.int32_field(1)
    # 用户答案
    answer: List[int] = betterproto.int32_field(2)


@dataclass
class DecQuestionSubmitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecQuestionSubmitData" = betterproto.message_field(3)


@dataclass
class DecQuestionSubmitData(betterproto.Message):
    # 答题奖品 详细列表企业微信私聊
    prizes: List[int] = betterproto.int32_field(1)
    # 累计答题
    total: int = betterproto.int32_field(2)
    # 累计奖励
    bonus: int = betterproto.int32_field(3)
    # 下一次奖励需要累计答题天数
    next: int = betterproto.int32_field(4)
    # 下一次奖励内容
    next_bonus: int = betterproto.int32_field(5)
    # 答题正确数
    correct: int = betterproto.int32_field(6)


@dataclass
class DecQuestionRewardResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DecQuestionRewardData" = betterproto.message_field(3)


@dataclass
class DecQuestionRewardData(betterproto.Message):
    list: List["QuestionReward"] = betterproto.message_field(1)


@dataclass
class QuestionReward(betterproto.Message):
    date: str = betterproto.string_field(1)
    pid: int = betterproto.int32_field(2)


@dataclass
class GetFissionShareDetailReq(betterproto.Message):
    # 邀请人 ID
    uid: int = betterproto.int64_field(1)


@dataclass
class GetFissionShareDetailResp(betterproto.Message):
    # 1 活动已下线
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FissionShareDetail" = betterproto.message_field(3)


@dataclass
class FissionShareDetail(betterproto.Message):
    # 推荐的漫画
    recommend_comics: List["Comic"] = betterproto.message_field(1)
    # 用户头像
    face: str = betterproto.string_field(2)
    # 用户名
    name: str = betterproto.string_field(3)
    # 送券数量
    coupon_count: int = betterproto.int32_field(4)
    # 子标题
    subtitle: str = betterproto.string_field(5)


@dataclass
class Comic(betterproto.Message):
    # 漫画 ID
    id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)
    cover: str = betterproto.string_field(3)


@dataclass
class GetFissionInviteesReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 条目数
    page_size: int = betterproto.int32_field(2)


@dataclass
class GetFissionInviteesResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["FissionInviteeInfo"] = betterproto.message_field(3)


@dataclass
class FissionInviteeInfo(betterproto.Message):
    # 用户昵称
    name: str = betterproto.string_field(1)
    # uid
    uid: int = betterproto.int64_field(2)
    # 用户被邀请时间 2016-01-02 15:04
    time: str = betterproto.string_field(3)
    # 头像
    face: str = betterproto.string_field(4)


class ActivityStub(betterproto.ServiceStub):
    """活动服务"""

    @allure.step("""新用户判断""")
    def new_user(self, request: EmptyRequest) -> NewUserResp:
        """新用户判断"""
        logging.getLogger(__name__).info(
            "start call " + "[new_user]" + " api" + "=>" + """新用户判断"""
        )
        response = NewUserResp()
        self._do_twirp_rpc("/activity.v2.Activity/NewUser", request, response)
        logging.getLogger(__name__).info("call " + "[new_user]" + " api success!")
        return response

    @allure.step("""活动模板""")
    def activity_templete(self, request: ActivityTempleteReq) -> ActivityTempleteResp:
        """活动模板"""
        logging.getLogger(__name__).info(
            "start call " + "[activity_templete]" + " api" + "=>" + """活动模板"""
        )
        response = ActivityTempleteResp()
        self._do_twirp_rpc("/activity.v2.Activity/ActivityTemplete", request, response)
        logging.getLogger(__name__).info(
            "call " + "[activity_templete]" + " api success!"
        )
        return response

    @allure.step("""端午抽奖首页""")
    def zhongqiu_init(self, request: ZhongqiuInitReq) -> ZhongqiuInitResp:
        """端午抽奖首页"""
        logging.getLogger(__name__).info(
            "start call " + "[zhongqiu_init]" + " api" + "=>" + """端午抽奖首页"""
        )
        response = ZhongqiuInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/ZhongqiuInit", request, response)
        logging.getLogger(__name__).info("call " + "[zhongqiu_init]" + " api success!")
        return response

    @allure.step("""端午抽奖""")
    def zhongqiu_draw(self, request: ZhongqiuDrawReq) -> ZhongqiuDrawResp:
        """端午抽奖"""
        logging.getLogger(__name__).info(
            "start call " + "[zhongqiu_draw]" + " api" + "=>" + """端午抽奖"""
        )
        response = ZhongqiuDrawResp()
        self._do_twirp_rpc("/activity.v2.Activity/ZhongqiuDraw", request, response)
        logging.getLogger(__name__).info("call " + "[zhongqiu_draw]" + " api success!")
        return response

    @allure.step("""端午抽奖实物地址""")
    def zhongqiu_address(self, request: ZhongqiuPrize) -> DefaultResponse:
        """端午抽奖实物地址"""
        logging.getLogger(__name__).info(
            "start call " + "[zhongqiu_address]" + " api" + "=>" + """端午抽奖实物地址"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/ZhongqiuAddress", request, response)
        logging.getLogger(__name__).info(
            "call " + "[zhongqiu_address]" + " api success!"
        )
        return response

    @allure.step("""端午获奖记录""")
    def zhongqiu_list(self, request: ZhongqiuListReq) -> ZhongqiuListResp:
        """端午获奖记录"""
        logging.getLogger(__name__).info(
            "start call " + "[zhongqiu_list]" + " api" + "=>" + """端午获奖记录"""
        )
        response = ZhongqiuListResp()
        self._do_twirp_rpc("/activity.v2.Activity/ZhongqiuList", request, response)
        logging.getLogger(__name__).info("call " + "[zhongqiu_list]" + " api success!")
        return response

    @allure.step("""柯南首页""")
    def conan_init(self, request: EmptyRequest) -> ConanInitResp:
        """柯南首页"""
        logging.getLogger(__name__).info(
            "start call " + "[conan_init]" + " api" + "=>" + """柯南首页"""
        )
        response = ConanInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/ConanInit", request, response)
        logging.getLogger(__name__).info("call " + "[conan_init]" + " api success!")
        return response

    @allure.step("""柯南抽奖""")
    def conan(self, request: ConanReq) -> ConanResp:
        """柯南抽奖"""
        logging.getLogger(__name__).info(
            "start call " + "[conan]" + " api" + "=>" + """柯南抽奖"""
        )
        response = ConanResp()
        self._do_twirp_rpc("/activity.v2.Activity/Conan", request, response)
        logging.getLogger(__name__).info("call " + "[conan]" + " api success!")
        return response

    @allure.step("""柯南实物地址""")
    def conan_address(self, request: ConanPrize) -> DefaultResponse:
        """柯南实物地址"""
        logging.getLogger(__name__).info(
            "start call " + "[conan_address]" + " api" + "=>" + """柯南实物地址"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/ConanAddress", request, response)
        logging.getLogger(__name__).info("call " + "[conan_address]" + " api success!")
        return response

    @allure.step("""柯南获奖记录""")
    def conan_list(self, request: EmptyRequest) -> ConanListResp:
        """柯南获奖记录"""
        logging.getLogger(__name__).info(
            "start call " + "[conan_list]" + " api" + "=>" + """柯南获奖记录"""
        )
        response = ConanListResp()
        self._do_twirp_rpc("/activity.v2.Activity/ConanList", request, response)
        logging.getLogger(__name__).info("call " + "[conan_list]" + " api success!")
        return response

    @allure.step("""BW抽奖次数（三合一）""")
    def bw_init(self, request: EmptyRequest) -> BwInitResp:
        """BW抽奖次数（三合一）"""
        logging.getLogger(__name__).info(
            "start call " + "[bw_init]" + " api" + "=>" + """BW抽奖次数（三合一）"""
        )
        response = BwInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/BwInit", request, response)
        logging.getLogger(__name__).info("call " + "[bw_init]" + " api success!")
        return response

    @allure.step("""畑抽奖""")
    def hata_draw(self, request: BwDrawReq) -> BwDrawResp:
        """畑抽奖"""
        logging.getLogger(__name__).info(
            "start call " + "[hata_draw]" + " api" + "=>" + """畑抽奖"""
        )
        response = BwDrawResp()
        self._do_twirp_rpc("/activity.v2.Activity/HataDraw", request, response)
        logging.getLogger(__name__).info("call " + "[hata_draw]" + " api success!")
        return response

    @allure.step("""由贵抽奖""")
    def yuki_draw(self, request: BwDrawReq) -> BwDrawResp:
        """由贵抽奖"""
        logging.getLogger(__name__).info(
            "start call " + "[yuki_draw]" + " api" + "=>" + """由贵抽奖"""
        )
        response = BwDrawResp()
        self._do_twirp_rpc("/activity.v2.Activity/YukiDraw", request, response)
        logging.getLogger(__name__).info("call " + "[yuki_draw]" + " api success!")
        return response

    @allure.step("""夏达抽奖""")
    def xiada_draw(self, request: BwDrawReq) -> BwDrawResp:
        """夏达抽奖"""
        logging.getLogger(__name__).info(
            "start call " + "[xiada_draw]" + " api" + "=>" + """夏达抽奖"""
        )
        response = BwDrawResp()
        self._do_twirp_rpc("/activity.v2.Activity/XiadaDraw", request, response)
        logging.getLogger(__name__).info("call " + "[xiada_draw]" + " api success!")
        return response

    @allure.step("""BW实物地址""")
    def bw_address(self, request: BwPrize) -> DefaultResponse:
        """BW实物地址"""
        logging.getLogger(__name__).info(
            "start call " + "[bw_address]" + " api" + "=>" + """BW实物地址"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/BwAddress", request, response)
        logging.getLogger(__name__).info("call " + "[bw_address]" + " api success!")
        return response

    @allure.step("""畑中奖纪录""")
    def hata_list(self, request: EmptyRequest) -> BwListResponse:
        """畑中奖纪录"""
        logging.getLogger(__name__).info(
            "start call " + "[hata_list]" + " api" + "=>" + """畑中奖纪录"""
        )
        response = BwListResponse()
        self._do_twirp_rpc("/activity.v2.Activity/HataList", request, response)
        logging.getLogger(__name__).info("call " + "[hata_list]" + " api success!")
        return response

    @allure.step("""由贵中奖记录""")
    def yuki_list(self, request: EmptyRequest) -> BwListResponse:
        """由贵中奖记录"""
        logging.getLogger(__name__).info(
            "start call " + "[yuki_list]" + " api" + "=>" + """由贵中奖记录"""
        )
        response = BwListResponse()
        self._do_twirp_rpc("/activity.v2.Activity/YukiList", request, response)
        logging.getLogger(__name__).info("call " + "[yuki_list]" + " api success!")
        return response

    @allure.step("""夏达中奖记录""")
    def xiada_list(self, request: EmptyRequest) -> BwListResponse:
        """夏达中奖记录"""
        logging.getLogger(__name__).info(
            "start call " + "[xiada_list]" + " api" + "=>" + """夏达中奖记录"""
        )
        response = BwListResponse()
        self._do_twirp_rpc("/activity.v2.Activity/XiadaList", request, response)
        logging.getLogger(__name__).info("call " + "[xiada_list]" + " api success!")
        return response

    @allure.step("""获取参与裂变活动的信息""")
    def get_fission_info(self, request: EmptyRequest) -> GetFissionInfoResp:
        """获取参与裂变活动的信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_fission_info]" + " api" + "=>" + """获取参与裂变活动的信息"""
        )
        response = GetFissionInfoResp()
        self._do_twirp_rpc("/activity.v2.Activity/GetFissionInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_fission_info]" + " api success!"
        )
        return response

    @allure.step("""裂变活动 新人登录领奖""")
    def get_fission_reward(self, request: GetFissionRewardReq) -> GetFissionRewardResp:
        """裂变活动 新人登录领奖"""
        logging.getLogger(__name__).info(
            "start call " + "[get_fission_reward]" + " api" + "=>" + """裂变活动 新人登录领奖"""
        )
        response = GetFissionRewardResp()
        self._do_twirp_rpc("/activity.v2.Activity/GetFissionReward", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_fission_reward]" + " api success!"
        )
        return response

    @allure.step("""获取裂变分享详情信息""")
    def get_fission_share_detail(
        self, request: GetFissionShareDetailReq
    ) -> GetFissionShareDetailResp:
        """获取裂变分享详情信息"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_fission_share_detail]"
            + " api"
            + "=>"
            + """获取裂变分享详情信息"""
        )
        response = GetFissionShareDetailResp()
        self._do_twirp_rpc(
            "/activity.v2.Activity/GetFissionShareDetail", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_fission_share_detail]" + " api success!"
        )
        return response

    @allure.step("""获取被邀请人列表""")
    def get_fission_invitees(
        self, request: GetFissionInviteesReq
    ) -> GetFissionInviteesResp:
        """获取被邀请人列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_fission_invitees]" + " api" + "=>" + """获取被邀请人列表"""
        )
        response = GetFissionInviteesResp()
        self._do_twirp_rpc(
            "/activity.v2.Activity/GetFissionInvitees", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_fission_invitees]" + " api success!"
        )
        return response

    @allure.step("""答题初始化""")
    def dec_question_init(self, request: EmptyRequest) -> DecQuestionInitResp:
        """答题初始化"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_question_init]" + " api" + "=>" + """答题初始化"""
        )
        response = DecQuestionInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/DecQuestionInit", request, response)
        logging.getLogger(__name__).info(
            "call " + "[dec_question_init]" + " api success!"
        )
        return response

    @allure.step("""答题提交""")
    def dec_question_submit(
        self, request: DecQuestionSubmitReq
    ) -> DecQuestionSubmitResp:
        """答题提交"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_question_submit]" + " api" + "=>" + """答题提交"""
        )
        response = DecQuestionSubmitResp()
        self._do_twirp_rpc("/activity.v2.Activity/DecQuestionSubmit", request, response)
        logging.getLogger(__name__).info(
            "call " + "[dec_question_submit]" + " api success!"
        )
        return response

    @allure.step("""我的奖励""")
    def dec_question_reward(self, request: EmptyRequest) -> DecQuestionRewardResp:
        """我的奖励"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_question_reward]" + " api" + "=>" + """我的奖励"""
        )
        response = DecQuestionRewardResp()
        self._do_twirp_rpc("/activity.v2.Activity/DecQuestionReward", request, response)
        logging.getLogger(__name__).info(
            "call " + "[dec_question_reward]" + " api success!"
        )
        return response

    @allure.step("""站庆首页""")
    def cele_init(self, request: EmptyRequest) -> CeleInitResp:
        """站庆首页"""
        logging.getLogger(__name__).info(
            "start call " + "[cele_init]" + " api" + "=>" + """站庆首页"""
        )
        response = CeleInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/CeleInit", request, response)
        logging.getLogger(__name__).info("call " + "[cele_init]" + " api success!")
        return response

    @allure.step("""等免排行榜""")
    def wait_rank(self, request: EmptyRequest) -> WaitRankResp:
        """等免排行榜"""
        logging.getLogger(__name__).info(
            "start call " + "[wait_rank]" + " api" + "=>" + """等免排行榜"""
        )
        response = WaitRankResp()
        self._do_twirp_rpc("/activity.v2.Activity/WaitRank", request, response)
        logging.getLogger(__name__).info("call " + "[wait_rank]" + " api success!")
        return response

    @allure.step("""17号领取礼包""")
    def nov17(self, request: EmptyRequest) -> DefaultResponse:
        """17号领取礼包"""
        logging.getLogger(__name__).info(
            "start call " + "[nov17]" + " api" + "=>" + """17号领取礼包"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/Nov17", request, response)
        logging.getLogger(__name__).info("call " + "[nov17]" + " api success!")
        return response

    @allure.step("""看漫画领礼包-礼包数""")
    def nov_score(self, request: EmptyRequest) -> NovScoreResp:
        """看漫画领礼包-礼包数"""
        logging.getLogger(__name__).info(
            "start call " + "[nov_score]" + " api" + "=>" + """看漫画领礼包-礼包数"""
        )
        response = NovScoreResp()
        self._do_twirp_rpc("/activity.v2.Activity/NovScore", request, response)
        logging.getLogger(__name__).info("call " + "[nov_score]" + " api success!")
        return response

    @allure.step("""看漫画领礼包-领礼包""")
    def nov_gift(self, request: NovGiftReq) -> DefaultResponse:
        """看漫画领礼包-领礼包"""
        logging.getLogger(__name__).info(
            "start call " + "[nov_gift]" + " api" + "=>" + """看漫画领礼包-领礼包"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/NovGift", request, response)
        logging.getLogger(__name__).info("call " + "[nov_gift]" + " api success!")
        return response

    @allure.step("""贺图""")
    def cele_pics(self, request: CelePicsReq) -> CelePicsResp:
        """贺图"""
        logging.getLogger(__name__).info(
            "start call " + "[cele_pics]" + " api" + "=>" + """贺图"""
        )
        response = CelePicsResp()
        self._do_twirp_rpc("/activity.v2.Activity/CelePics", request, response)
        logging.getLogger(__name__).info("call " + "[cele_pics]" + " api success!")
        return response

    @allure.step("""月票战初始化""")
    def dec_battle_init(self, request: EmptyRequest) -> DecBattleInitResp:
        """月票战初始化"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_battle_init]" + " api" + "=>" + """月票战初始化"""
        )
        response = DecBattleInitResp()
        self._do_twirp_rpc("/activity.v2.Activity/DecBattleInit", request, response)
        logging.getLogger(__name__).info(
            "call " + "[dec_battle_init]" + " api success!"
        )
        return response

    @allure.step("""月票战""")
    def dec_battle(self, request: DecBattleReq) -> DecBattleResp:
        """月票战"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_battle]" + " api" + "=>" + """月票战"""
        )
        response = DecBattleResp()
        self._do_twirp_rpc("/activity.v2.Activity/DecBattle", request, response)
        logging.getLogger(__name__).info("call " + "[dec_battle]" + " api success!")
        return response

    @allure.step("""月票战-推荐""")
    def dec_battle_recommend(self, request: EmptyRequest) -> DecBattleRecommendResp:
        """月票战-推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[dec_battle_recommend]" + " api" + "=>" + """月票战-推荐"""
        )
        response = DecBattleRecommendResp()
        self._do_twirp_rpc(
            "/activity.v2.Activity/DecBattleRecommend", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[dec_battle_recommend]" + " api success!"
        )
        return response

    @allure.step("""天官赐福""")
    def tianguan(self, request: EmptyRequest) -> TianguanResp:
        """天官赐福"""
        logging.getLogger(__name__).info(
            "start call " + "[tianguan]" + " api" + "=>" + """天官赐福"""
        )
        response = TianguanResp()
        self._do_twirp_rpc("/activity.v2.Activity/Tianguan", request, response)
        logging.getLogger(__name__).info("call " + "[tianguan]" + " api success!")
        return response

    @allure.step("""双旦签到信息""")
    def double_egg_info(self, request: EmptyRequest) -> DoubleEggResp:
        """双旦签到信息"""
        logging.getLogger(__name__).info(
            "start call " + "[double_egg_info]" + " api" + "=>" + """双旦签到信息"""
        )
        response = DoubleEggResp()
        self._do_twirp_rpc("/activity.v2.Activity/DoubleEggInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[double_egg_info]" + " api success!"
        )
        return response

    @allure.step("""双旦签到签到""")
    def double_egg_sign(self, request: EmptyRequest) -> DoubleEggSignResp:
        """双旦签到签到"""
        logging.getLogger(__name__).info(
            "start call " + "[double_egg_sign]" + " api" + "=>" + """双旦签到签到"""
        )
        response = DoubleEggSignResp()
        self._do_twirp_rpc("/activity.v2.Activity/DoubleEggSign", request, response)
        logging.getLogger(__name__).info(
            "call " + "[double_egg_sign]" + " api success!"
        )
        return response

    @allure.step("""时光机""")
    def time_machine(self, request: EmptyRequest) -> TimeMachineResp:
        """时光机"""
        logging.getLogger(__name__).info(
            "start call " + "[time_machine]" + " api" + "=>" + """时光机"""
        )
        response = TimeMachineResp()
        self._do_twirp_rpc("/activity.v2.Activity/TimeMachine", request, response)
        logging.getLogger(__name__).info("call " + "[time_machine]" + " api success!")
        return response

    @allure.step("""时光机-同意隐私""")
    def time_machine_agree(self, request: EmptyRequest) -> DefaultResponse:
        """时光机-同意隐私"""
        logging.getLogger(__name__).info(
            "start call " + "[time_machine_agree]" + " api" + "=>" + """时光机-同意隐私"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/activity.v2.Activity/TimeMachineAgree", request, response)
        logging.getLogger(__name__).info(
            "call " + "[time_machine_agree]" + " api success!"
        )
        return response

    @allure.step("""查询礼包领取状态""")
    def gift_status(self, request: GiftStatusReq) -> GiftStatusResp:
        """查询礼包领取状态"""
        logging.getLogger(__name__).info(
            "start call " + "[gift_status]" + " api" + "=>" + """查询礼包领取状态"""
        )
        response = GiftStatusResp()
        self._do_twirp_rpc("/activity.v2.Activity/GiftStatus", request, response)
        logging.getLogger(__name__).info("call " + "[gift_status]" + " api success!")
        return response
