"""data.py
"""

# Standard library imports

# Third party imports

# Local application imports

tlv = {
    '42' : 'Issuer Identification Number',
    '4F' : 'Application Identifier',
    '50' : 'Application Label',
    '57' : 'Track 2 Equivalent Data',
    '5A' : 'Application Primary Account Number',
    '5F20' : 'Cardholder name',
    '5F24' : 'Application Expiration Date',
    '5F25' : 'Application Effective Date',
    '5F28' : 'Issuer country code',
    '5F2A' : 'Transaction Currency Code',
    '5F2D' : 'Language Preference',
    '5F30' : 'Service code',
    '5F34' : 'Application PAN Sequence Number',
    '5F36' : 'Transaction Currency Exponent',
    '5F50' : 'Issuer URL',
    '5F53' : 'International Bank Account Number',
    '5F54' : 'Bank Identifier Code (BIC)',
    '5F55' : 'Issuer Country Code (alpha2 format)',
    '5F56' : 'Issuer Country Code (alpha3 format)',
    '61' : 'Application Template',
    '6F' : 'File Control Information Template',
    '70' : 'Application Template',
    '71' : 'Issuer Script Template 1',
    '72' : 'Issuer script template 2',
    '73' : 'Directory Discretionary Template',
    '77' : 'Response Message Template Format 2',
    '80' : 'Response Message Template Format 1',
    '81' : 'Amount, Authorised (Binary)',
    '82' : 'Application interchange profile',
    '83' : 'Command Template',
    '84' : 'Dedicated File (DF) Name',
    '86' : 'Issuer Script Command',
    '87' : 'Application Priority Indicator',
    '88' : 'Short File Identifier',
    '89' : 'Authorisation code',
    '8A' : 'Authorisation response code',
    '8C' : 'Card Risk Management Data Object List 1',
    '8D' : 'Card Risk Management Data Object List 2',
    '8E' : 'Cardholder Verification Method (CVM) List',
    '8F' : 'Certification authority public key index',
    '90' : 'Issuer Public Key Certificate',
    '91' : 'Issuer authentication data',
    '92' : 'Issuer Public Key Remainder',
    '93' : 'Signed Static Application Data',
    '94' : 'Application File Locator',
    '95' : 'Terminal verification results',
    '97' : 'Transaction Certificate Data Object List',
    '98' : 'Transaction Certificate (TC) Hash Value',
    '99' : 'Transaction PIN Data',
    '9A' : 'Transaction Date',
    '9B' : 'Transaction Status Information',
    '9C' : 'Transaction Type',
    '9D' : 'Directory Definition File (DDF) Name',
    '9F01' : 'Acquirer Identifier',
    '9F02' : 'Amount, Authorised (Numeric)',
    '9F03' : 'Amount, Other (Numeric)',
    '9F04' : 'Amount, Other (Binary)',
    '9F05' : 'Application Discretionary Data',
    '9F06' : 'Application Identifier (AID) - Terminal',
    '9F07' : 'Application Usage Control',
    '9F08' : 'Application Version Number',
    '9F09' : 'Terminal application version number',
    '9F0B' : 'Cardholder Name Extended',
    '9F0D' : 'Issuer Action Code - Default',
    '9F0E' : 'Issuer Action Code - Denial',
    '9F0F' : 'Issuer Action Code - Online',
    '9F10' : 'Issuer Application Data',
    '9F11' : 'Issuer Code Table Index',
    '9F12' : 'Application Preferred Name',
    '9F13' : 'Last Online Application Transaction Counter (ATC) Register',
    '9F14' : 'Lower Consecutive Offline Limit',
    '9F15' : 'Merchant Category Code',
    '9F16' : 'Merchant Identifier',
    '9F17' : 'PIN Try Counter',
    '9F18' : 'Issuer Script Identifier',
    '9F1A' : 'Terminal Country Code',
    '9F1B' : 'Terminal Floor Limit',
    '9F1C' : 'Terminal Identification',
    '9F1D' : 'Terminal Risk Management Data',
    '9F1E' : 'Interface Device (IFD) Serial Number',
    '9F1F' : 'Track 1 Discretionary Data',
    '9F20' : 'Track 2 Discretionary Data',
    '9F21' : 'Transaction Time',
    '9F22' : 'Certification Authority Public Key Index',
    '9F23' : 'Upper Consecutive Offline Limit',
    '9F26' : 'Application Cryptogram',
    '9F27' : 'Cryptogram Information Data',
    '9F2D' : 'ICC PIN Encipherment Public Key Certificate',
    '9F2E' : 'ICC PIN Encipherment Public Key Exponent',
    '9F2F' : 'ICC PIN Encipherment Public Key Remainder',
    '9F32' : 'Issuer Public Key Exponent',
    '9F33' : 'Terminal Capabilities',
    '9F34' : 'Cardholder Verification Method (CVM) Results',
    '9F35' : 'Terminal Type',
    '9F36' : 'Application Transaction Counter',
    '9F37' : 'Unpredictable Number',
    '9F38' : 'Processing Options Data Object List',
    '9F39' : 'Point-of-Service (POS) Entry Mode',
    '9F3A' : 'Amount, Reference Currency',
    '9F3B' : 'Application Reference Currency',
    '9F3C' : 'Transaction Reference Currency Code',
    '9F3D' : 'Transaction Reference Currency Exponent',
    '9F40' : 'Additional Terminal Capabilities',
    '9F41' : 'Transaction Sequence Counter',
    '9F42' : 'Application Currency Code',
    '9F43' : 'Application Reference Currency Exponent',
    '9F44' : 'Application Currency Exponent',
    '9F45' : 'Data Authentication Code',
    '9F46' : 'ICC Public Key Certificate',
    '9F47' : 'ICC Public Key Exponent',
    '9F48' : 'ICC Public Key Remainder',
    '9F49' : 'Dynamic Data Authentication Data Object List',
    '9F4A' : 'Static Data Authentication Tag List',
    '9F4B' : 'Signed Dynamic Application Data',
    '9F4C' : 'ICC Dynamic Number',
    '9F4D' : 'Log Entry',
    '9F4E' : 'Merchant Name and Location',
    '9F4F' : 'Log Format',
    '9F53' : 'Transaction category code',
    'A5' : 'File Control Information (FCI) Proprietary Template',
    'B1' : 'Transaction log information',
    'B2' : 'Transaction log records',
    'B3' : 'Log totals',
    'BE' : 'Connection data 2',
    'BF0C' : 'File Control Information (FCI) Issuer Discretionary Data',
    'Issuer Identification Number' : '42',
    'Application Identifier' : '4F',
    'Application Label' : '50',
    'Track 2 Equivalent Data' : '57',
    'Application Primary Account Number' : '5A',
    'Cardholder name' : '5F20',
    'Application Expiration Date' : '5F24',
    'Application Effective Date' : '5F25',
    'Issuer country code' : '5F28',
    'Transaction Currency Code' : '5F2A',
    'Language Preference' : '5F2D',
    'Service code' : '5F30',
    'Application PAN Sequence Number' : '5F34',
    'Transaction Currency Exponent' : '5F36',
    'Issuer URL' : '5F50',
    'International Bank Account Number' : '5F53',
    'Bank Identifier Code (BIC)' : '5F54',
    'Issuer Country Code (alpha2 format)' : '5F55',
    'Issuer Country Code (alpha3 format)' : '5F56',
    'Application Template' : '61',
    'File Control Information Template' : '6F',
    'Application Template' : '70',
    'Issuer Script Template 1' : '71',
    'Issuer script template 2' : '72',
    'Directory Discretionary Template' : '73',
    'Response Message Template Format 2' : '77',
    'Response Message Template Format 1' : '80',
    'Amount, Authorised (Binary)' : '81',
    'Application interchange profile' : '82',
    'Command Template' : '83',
    'Dedicated File (DF) Name' : '84',
    'Issuer Script Command' : '86',
    'Application Priority Indicator' : '87',
    'Short File Identifier' : '88',
    'Authorisation code' : '89',
    'Authorisation response code' : '8A',
    'Card Risk Management Data Object List 1' : '8C',
    'Card Risk Management Data Object List 2' : '8D',
    'Cardholder Verification Method (CVM) List' : '8E',
    'Certification authority public key index' : '8F',
    'Issuer Public Key Certificate' : '90',
    'Issuer authentication data' : '91',
    'Issuer Public Key Remainder' : '92',
    'Signed Static Application Data' : '93',
    'Application File Locator' : '94',
    'Terminal verification results' : '95',
    'Transaction Certificate Data Object List' : '97',
    'Transaction Certificate (TC) Hash Value' : '98',
    'Transaction PIN Data' : '99',
    'Transaction Date' : '9A',
    'Transaction Status Information' : '9B',
    'Transaction Type' : '9C',
    'Directory Definition File (DDF) Name' : '9D',
    'Acquirer Identifier' : '9F01',
    'Amount, Authorised (Numeric)' : '9F02',
    'Amount, Other (Numeric)' : '9F03',
    'Amount, Other (Binary)' : '9F04',
    'Application Discretionary Data' : '9F05',
    'Application Identifier (AID) - Terminal' : '9F06',
    'Application Usage Control' : '9F07',
    'Application Version Number' : '9F08',
    'Terminal application version number' : '9F09',
    'Cardholder Name Extended' : '9F0B',
    'Issuer Action Code - Default' : '9F0D',
    'Issuer Action Code - Denial' : '9F0E',
    'Issuer Action Code - Online' : '9F0F',
    'Issuer Application Data' : '9F10',
    'Issuer Code Table Index' : '9F11',
    'Application Preferred Name' : '9F12',
    'Last Online Application Transaction Counter (ATC) Register' : '9F13',
    'Lower Consecutive Offline Limit' : '9F14',
    'Merchant Category Code' : '9F15',
    'Merchant Identifier' : '9F16',
    'PIN Try Counter' : '9F17',
    'Issuer Script Identifier' : '9F18',
    'Terminal Country Code' : '9F1A',
    'Terminal Floor Limit' : '9F1B',
    'Terminal Identification' : '9F1C',
    'Terminal Risk Management Data' : '9F1D',
    'Interface Device (IFD) Serial Number' : '9F1E',
    'Track 1 Discretionary Data' : '9F1F',
    'Track 2 Discretionary Data' : '9F20',
    'Transaction Time' : '9F21',
    'Certification Authority Public Key Index' : '9F22',
    'Upper Consecutive Offline Limit' : '9F23',
    'Application Cryptogram' : '9F26',
    'Cryptogram Information Data' : '9F27',
    'ICC PIN Encipherment Public Key Certificate' : '9F2D',
    'ICC PIN Encipherment Public Key Exponent' : '9F2E',
    'ICC PIN Encipherment Public Key Remainder' : '9F2F',
    'Issuer Public Key Exponent' : '9F32',
    'Terminal Capabilities' : '9F33',
    'Cardholder Verification Method (CVM) Results' : '9F34',
    'Terminal Type' : '9F35',
    'Application Transaction Counter' : '9F36',
    'Unpredictable Number' : '9F37',
    'Processing Options Data Object List' : '9F38',
    'Point-of-Service (POS) Entry Mode' : '9F39',
    'Amount, Reference Currency' : '9F3A',
    'Application Reference Currency' : '9F3B',
    'Transaction Reference Currency Code' : '9F3C',
    'Transaction Reference Currency Exponent' : '9F3D',
    'Additional Terminal Capabilities' : '9F40',
    'Transaction Sequence Counter' : '9F41',
    'Application Currency Code' : '9F42',
    'Application Reference Currency Exponent' : '9F43',
    'Application Currency Exponent' : '9F44',
    'Data Authentication Code' : '9F45',
    'ICC Public Key Certificate' : '9F46',
    'ICC Public Key Exponent' : '9F47',
    'ICC Public Key Remainder' : '9F48',
    'Dynamic Data Authentication Data Object List' : '9F49',
    'Static Data Authentication Tag List' : '9F4A',
    'Signed Dynamic Application Data' : '9F4B',
    'ICC Dynamic Number' : '9F4C',
    'Log Entry' : '9F4D',
    'Merchant Name and Location' : '9F4E',
    'Log Format' : '9F4F',
    'Transaction category code' : '9F53',
    'File Control Information (FCI) Proprietary Template' : 'A5',
    'Transaction log information' : 'B1',
    'Transaction log records' : 'B2',
    'Log totals' : 'B3',
    'Connection data 2' : 'BE',
    'File Control Information (FCI) Issuer Discretionary Data' : 'BF0C',
    'AC' : '9F26',
    'AFL' : '94',
    'AID' : '4F',
    'AIP' : '82',
    'ATC' : '9F36',
    'AUC' : '9F07',
    'CDOL1' : '8C',
    'CDOL2' : '8D',
    'CID' : '9F27',
    'DDOL' : '9F49',
    'IBAN' : '5F53',
    'IIN' : '42',
    'LATC' : '9F13',
    'LCOL' : '9F14',
    'MCC' : '9F15',
    'PAN' : '5A',
    'PDOL' : '9F38',
    'PSN' : '5F34',
    'PTC' : '9F17',
    'SFI' : '88',
    'TDOL' : '97',
    'Track2' : '57',
    'UCOL' : '9F23',
    'UN' : '9F37'
}

def AFL(tlv_objects_list):
    """AFL():
    """
    return tlv_objects_list.get('94', None)

def ATC(tlv_objects_list):
    """ATC():
    """
    return tlv_objects_list.get('9F36', None)

def PDOL(tlv_objects_list):
    """PDOL():
    """
    return tlv_objects_list.get('9F38', None)

def PSN(tlv_objects_list):
    """PSN():
    """
    return tlv_objects_list.get('5F34', None)

def Track2(tlv_objects_list):
    """Track2():
    """
    return tlv_objects_list.get('57', None)

def get_object(object_name: str, tlv_objects_list):
    return tlv_objects_list.get(tlv[object_name], None)

#
# Helper functions (assume a clean 'hstr' as input)
#

