# Viper
A modern testing framework.

## How to use it
Viper was made for people of all types and expertise.
To make a simple test, you can use the following code:
```python
from viper import Viper

snake = Viper("Example Tests")

def addition(a, b):
    return a + b

snake.test("check if addition function can solve 5 + 5", addition(5, 5), 10)

snake.evaluate()
```
On running this, you should get:
```markdown
Running tests for "Example Tests"
Testing "check if addition function can solve 5 + 5"... Passed

Ran 1 test(s) in 0.0004 seconds
1/1 passed
```
And if we change the 10 to become something else like so:
```python
snake.test("check if addition function can solve 5 + 5", addition(5, 5), 7)
```
The output becomes:
```markdown
Running tests for "Example Tests"
Testing "check if addition function can solve 5 + 5"... Failed
   Desired Output: "7" | Test Ouput: "10"

Ran 1 test(s) in 0.0006 seconds
0/1 passed
```
As one can see, the testing outputs are made so that it is simple, yet it is also informative

Viper can also be used as an API test:
```python
from viper import Viper
import requests

snake = Viper("Example Tests")

def checkCompletion():
    return requests.get("https://jsonplaceholder.typicode.com/todos/1").json()["completed"]

snake.test("check if todo is completed or not", checkCompletion(), False)

snake.evaluate()
```
The output of that is:
```markdown
Running tests for "Example Tests"
Testing "check if todo is completed or not"... Passed

Ran 1 test(s) in 0.0009 seconds
1/1 passed
```

## Copyrighted
Copyright &copy; 2020-2021 Aarush Gupta\
All intellectual properties are exclusive properties registered in the United States by Aarush Gupta. They have been federally registered with the United States Copyright Office. All rights reserved.\
No adaptation or use of any kind of any of our registered trademarks or copyrights, or any other contents is allowed without the express written permission of Aarush Gupta.\
For more information regarding the authorized uses of these items please contact us.