# Generated by Django 4.1 on 2022-09-07 17:53

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="MetaTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    models.TextField(
                        help_text="Example: /about-us", verbose_name="URL Path"
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Title Tag",
                        max_length=400,
                        null=True,
                        verbose_name="Meta Title",
                    ),
                ),
                (
                    "meta_description",
                    models.TextField(
                        blank=True,
                        help_text="Meta Description",
                        null=True,
                        verbose_name="Meta Description",
                    ),
                ),
                (
                    "meta_keywords",
                    models.TextField(
                        blank=True,
                        help_text="Meta Keywords",
                        null=True,
                        verbose_name="Meta Keywords",
                    ),
                ),
                (
                    "meta_canonical",
                    models.URLField(blank=True, null=True, verbose_name="Canonical"),
                ),
                (
                    "meta_robots",
                    models.CharField(
                        blank=True,
                        max_length=400,
                        null=True,
                        verbose_name="meta_robots",
                    ),
                ),
                (
                    "og_description",
                    models.TextField(
                        blank=True, null=True, verbose_name="Og Description"
                    ),
                ),
                (
                    "og_image",
                    models.ImageField(
                        blank=True, null=True, upload_to="", verbose_name="Og Image"
                    ),
                ),
                (
                    "og_url",
                    models.URLField(blank=True, null=True, verbose_name="Og url"),
                ),
                (
                    "og_site_name",
                    models.CharField(
                        blank=True,
                        max_length=400,
                        null=True,
                        verbose_name="Og Site name",
                    ),
                ),
                (
                    "og_title",
                    models.CharField(
                        blank=True, max_length=400, null=True, verbose_name="Og Title"
                    ),
                ),
            ],
            options={
                "verbose_name": "Meta Tag",
                "verbose_name_plural": "Meta Tags",
            },
        ),
        migrations.CreateModel(
            name="Schema",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("schema", models.JSONField(null=True, verbose_name="Schema")),
                (
                    "url",
                    models.TextField(
                        help_text="Example: /about-us", verbose_name="URL Path"
                    ),
                ),
            ],
            options={
                "verbose_name": "Schema",
                "verbose_name_plural": "Schemas",
            },
        ),
        migrations.CreateModel(
            name="CustomMetaTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("name", "name"), ("property", "property")],
                        default=("name", "name"),
                        max_length=400,
                        verbose_name="status",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text='<meta name="" content="" />',
                        max_length=400,
                        verbose_name="Meta Property / Meta Name",
                    ),
                ),
                (
                    "content",
                    models.TextField(
                        help_text='<meta name="" content="" />',
                        max_length=400,
                        verbose_name="Meta Content",
                    ),
                ),
                (
                    "seo",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="custom_meta",
                        to="meta_pages.metatag",
                    ),
                ),
            ],
            options={
                "verbose_name": "Custom Meta Tag",
                "verbose_name_plural": "Custom Meta Tags",
            },
        ),
    ]
