"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleGitApi = void 0;
const task_callback_1 = require("./task-callback");
const push_1 = require("./tasks/push");
const task_1 = require("./tasks/task");
const utils_1 = require("./utils");
class SimpleGitApi {
    constructor(_executor) {
        this._executor = _executor;
    }
    _runTask(task, then) {
        const chain = this._executor.chain();
        const promise = chain.push(task);
        if (then) {
            task_callback_1.taskCallback(task, promise, then);
        }
        return Object.create(this, {
            then: { value: promise.then.bind(promise) },
            catch: { value: promise.catch.bind(promise) },
            _executor: { value: chain },
        });
    }
    add(files) {
        return this._runTask(task_1.straightThroughStringTask(['add', ...utils_1.asArray(files)]), utils_1.trailingFunctionArgument(arguments));
    }
    push() {
        const task = push_1.pushTask({
            remote: utils_1.filterType(arguments[0], utils_1.filterString),
            branch: utils_1.filterType(arguments[1], utils_1.filterString),
        }, utils_1.getTrailingOptions(arguments));
        return this._runTask(task, utils_1.trailingFunctionArgument(arguments));
    }
}
exports.SimpleGitApi = SimpleGitApi;
//# sourceMappingURL=simple-git-api.js.map