# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    def __init__(__self__, arn=None, container_recipe_arn=None, image_id=None, name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if container_recipe_arn and not isinstance(container_recipe_arn, str):
            raise TypeError("Expected argument 'container_recipe_arn' to be a str")
        pulumi.set(__self__, "container_recipe_arn", container_recipe_arn)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the image.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="containerRecipeArn")
    def container_recipe_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.
        """
        return pulumi.get(self, "container_recipe_arn")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        The AMI ID of the EC2 AMI in current region.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            arn=self.arn,
            container_recipe_arn=self.container_recipe_arn,
            image_id=self.image_id,
            name=self.name)


def get_image(arn: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Resource schema for AWS::ImageBuilder::Image


    :param str arn: The Amazon Resource Name (ARN) of the image.
    """
    __args__ = dict()
    __args__['arn'] = arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:imagebuilder:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        arn=__ret__.arn,
        container_recipe_arn=__ret__.container_recipe_arn,
        image_id=__ret__.image_id,
        name=__ret__.name)


@_utilities.lift_output_func(get_image)
def get_image_output(arn: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImageResult]:
    """
    Resource schema for AWS::ImageBuilder::Image


    :param str arn: The Amazon Resource Name (ARN) of the image.
    """
    ...
