# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VdcNetwork(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'subnets': 'Subnets',
        'backing_network_id': 'str',
        'backing_network_type': 'BackingNetworkType',
        'parent_network_id': 'EntityReference',
        'network_type': 'VdcNetworkFenceType',
        'org_vdc': 'EntityReference',
        'connection': 'RouterConnection',
        'is_default_network': 'bool',
        'shared': 'bool',
        'status': 'OrgVdcNetworkStatus',
        'last_task_failure_message': 'str',
        'guest_vlan_tagging_allowed': 'bool',
        'retain_nic_resources': 'bool',
        'cross_vdc_network_id': 'str',
        'cross_vdc_network_location_id': 'str',
        'total_ip_count': 'int',
        'used_ip_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'subnets': 'subnets',
        'backing_network_id': 'backingNetworkId',
        'backing_network_type': 'backingNetworkType',
        'parent_network_id': 'parentNetworkId',
        'network_type': 'networkType',
        'org_vdc': 'orgVdc',
        'connection': 'connection',
        'is_default_network': 'isDefaultNetwork',
        'shared': 'shared',
        'status': 'status',
        'last_task_failure_message': 'lastTaskFailureMessage',
        'guest_vlan_tagging_allowed': 'guestVlanTaggingAllowed',
        'retain_nic_resources': 'retainNicResources',
        'cross_vdc_network_id': 'crossVdcNetworkId',
        'cross_vdc_network_location_id': 'crossVdcNetworkLocationId',
        'total_ip_count': 'totalIpCount',
        'used_ip_count': 'usedIpCount'
    }

    def __init__(self, id=None, name=None, description=None, subnets=None, backing_network_id=None, backing_network_type=None, parent_network_id=None, network_type=None, org_vdc=None, connection=None, is_default_network=None, shared=None, status=None, last_task_failure_message=None, guest_vlan_tagging_allowed=None, retain_nic_resources=None, cross_vdc_network_id=None, cross_vdc_network_location_id=None, total_ip_count=None, used_ip_count=None):
        """
        VdcNetwork - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._subnets = None
        self._backing_network_id = None
        self._backing_network_type = None
        self._parent_network_id = None
        self._network_type = None
        self._org_vdc = None
        self._connection = None
        self._is_default_network = None
        self._shared = None
        self._status = None
        self._last_task_failure_message = None
        self._guest_vlan_tagging_allowed = None
        self._retain_nic_resources = None
        self._cross_vdc_network_id = None
        self._cross_vdc_network_location_id = None
        self._total_ip_count = None
        self._used_ip_count = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if subnets is not None:
          self.subnets = subnets
        if backing_network_id is not None:
          self.backing_network_id = backing_network_id
        if backing_network_type is not None:
          self.backing_network_type = backing_network_type
        if parent_network_id is not None:
          self.parent_network_id = parent_network_id
        if network_type is not None:
          self.network_type = network_type
        if org_vdc is not None:
          self.org_vdc = org_vdc
        if connection is not None:
          self.connection = connection
        if is_default_network is not None:
          self.is_default_network = is_default_network
        if shared is not None:
          self.shared = shared
        if status is not None:
          self.status = status
        if last_task_failure_message is not None:
          self.last_task_failure_message = last_task_failure_message
        if guest_vlan_tagging_allowed is not None:
          self.guest_vlan_tagging_allowed = guest_vlan_tagging_allowed
        if retain_nic_resources is not None:
          self.retain_nic_resources = retain_nic_resources
        if cross_vdc_network_id is not None:
          self.cross_vdc_network_id = cross_vdc_network_id
        if cross_vdc_network_location_id is not None:
          self.cross_vdc_network_location_id = cross_vdc_network_location_id
        if total_ip_count is not None:
          self.total_ip_count = total_ip_count
        if used_ip_count is not None:
          self.used_ip_count = used_ip_count

    @property
    def id(self):
        """
        Gets the id of this VdcNetwork.
        The unique ID for the network. This field is read-only.

        :return: The id of this VdcNetwork.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VdcNetwork.
        The unique ID for the network. This field is read-only.

        :param id: The id of this VdcNetwork.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VdcNetwork.
        The name of the network.

        :return: The name of this VdcNetwork.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VdcNetwork.
        The name of the network.

        :param name: The name of this VdcNetwork.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this VdcNetwork.
        The description of the network.

        :return: The description of this VdcNetwork.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VdcNetwork.
        The description of the network.

        :param description: The description of this VdcNetwork.
        :type: str
        """

        self._description = description

    @property
    def subnets(self):
        """
        Gets the subnets of this VdcNetwork.
        List of subnets configured for the network.

        :return: The subnets of this VdcNetwork.
        :rtype: Subnets
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this VdcNetwork.
        List of subnets configured for the network.

        :param subnets: The subnets of this VdcNetwork.
        :type: Subnets
        """

        self._subnets = subnets

    @property
    def backing_network_id(self):
        """
        Gets the backing_network_id of this VdcNetwork.
        The NSX id of the backing network.

        :return: The backing_network_id of this VdcNetwork.
        :rtype: str
        """
        return self._backing_network_id

    @backing_network_id.setter
    def backing_network_id(self, backing_network_id):
        """
        Sets the backing_network_id of this VdcNetwork.
        The NSX id of the backing network.

        :param backing_network_id: The backing_network_id of this VdcNetwork.
        :type: str
        """

        self._backing_network_id = backing_network_id

    @property
    def backing_network_type(self):
        """
        Gets the backing_network_type of this VdcNetwork.
        The object type of the backing network.

        :return: The backing_network_type of this VdcNetwork.
        :rtype: BackingNetworkType
        """
        return self._backing_network_type

    @backing_network_type.setter
    def backing_network_type(self, backing_network_type):
        """
        Sets the backing_network_type of this VdcNetwork.
        The object type of the backing network.

        :param backing_network_type: The backing_network_type of this VdcNetwork.
        :type: BackingNetworkType
        """

        self._backing_network_type = backing_network_type

    @property
    def parent_network_id(self):
        """
        Gets the parent_network_id of this VdcNetwork.
        The parent network if the network is a direct network, otherwise it will be null.

        :return: The parent_network_id of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._parent_network_id

    @parent_network_id.setter
    def parent_network_id(self, parent_network_id):
        """
        Sets the parent_network_id of this VdcNetwork.
        The parent network if the network is a direct network, otherwise it will be null.

        :param parent_network_id: The parent_network_id of this VdcNetwork.
        :type: EntityReference
        """

        self._parent_network_id = parent_network_id

    @property
    def network_type(self):
        """
        Gets the network_type of this VdcNetwork.
        The type of network. Changing the network type allows converting between an isolated and routed network. Note that the \"connection\" field must also be set if converting from isolated to routed network. 

        :return: The network_type of this VdcNetwork.
        :rtype: VdcNetworkFenceType
        """
        return self._network_type

    @network_type.setter
    def network_type(self, network_type):
        """
        Sets the network_type of this VdcNetwork.
        The type of network. Changing the network type allows converting between an isolated and routed network. Note that the \"connection\" field must also be set if converting from isolated to routed network. 

        :param network_type: The network_type of this VdcNetwork.
        :type: VdcNetworkFenceType
        """

        self._network_type = network_type

    @property
    def org_vdc(self):
        """
        Gets the org_vdc of this VdcNetwork.
        The organization vDC the network belongs to.

        :return: The org_vdc of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._org_vdc

    @org_vdc.setter
    def org_vdc(self, org_vdc):
        """
        Sets the org_vdc of this VdcNetwork.
        The organization vDC the network belongs to.

        :param org_vdc: The org_vdc of this VdcNetwork.
        :type: EntityReference
        """

        self._org_vdc = org_vdc

    @property
    def connection(self):
        """
        Gets the connection of this VdcNetwork.
        The edge gateway that the network is attached to. 

        :return: The connection of this VdcNetwork.
        :rtype: RouterConnection
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this VdcNetwork.
        The edge gateway that the network is attached to. 

        :param connection: The connection of this VdcNetwork.
        :type: RouterConnection
        """

        self._connection = connection

    @property
    def is_default_network(self):
        """
        Gets the is_default_network of this VdcNetwork.
        Deprecated unused field, this property will be removed in future release. 

        :return: The is_default_network of this VdcNetwork.
        :rtype: bool
        """
        return self._is_default_network

    @is_default_network.setter
    def is_default_network(self, is_default_network):
        """
        Sets the is_default_network of this VdcNetwork.
        Deprecated unused field, this property will be removed in future release. 

        :param is_default_network: The is_default_network of this VdcNetwork.
        :type: bool
        """

        self._is_default_network = is_default_network

    @property
    def shared(self):
        """
        Gets the shared of this VdcNetwork.
        Whether this network is shared with other organization vDCs.

        :return: The shared of this VdcNetwork.
        :rtype: bool
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this VdcNetwork.
        Whether this network is shared with other organization vDCs.

        :param shared: The shared of this VdcNetwork.
        :type: bool
        """

        self._shared = shared

    @property
    def status(self):
        """
        Gets the status of this VdcNetwork.
        Description of the network's status. 

        :return: The status of this VdcNetwork.
        :rtype: OrgVdcNetworkStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this VdcNetwork.
        Description of the network's status. 

        :param status: The status of this VdcNetwork.
        :type: OrgVdcNetworkStatus
        """

        self._status = status

    @property
    def last_task_failure_message(self):
        """
        Gets the last_task_failure_message of this VdcNetwork.
        Brief failure message if the last configuration task failed. Deprecated in Api 33.0, this property will be removed in next release. 

        :return: The last_task_failure_message of this VdcNetwork.
        :rtype: str
        """
        return self._last_task_failure_message

    @last_task_failure_message.setter
    def last_task_failure_message(self, last_task_failure_message):
        """
        Sets the last_task_failure_message of this VdcNetwork.
        Brief failure message if the last configuration task failed. Deprecated in Api 33.0, this property will be removed in next release. 

        :param last_task_failure_message: The last_task_failure_message of this VdcNetwork.
        :type: str
        """

        self._last_task_failure_message = last_task_failure_message

    @property
    def guest_vlan_tagging_allowed(self):
        """
        Gets the guest_vlan_tagging_allowed of this VdcNetwork.
        Whether guest VLAN tagging is allowed.

        :return: The guest_vlan_tagging_allowed of this VdcNetwork.
        :rtype: bool
        """
        return self._guest_vlan_tagging_allowed

    @guest_vlan_tagging_allowed.setter
    def guest_vlan_tagging_allowed(self, guest_vlan_tagging_allowed):
        """
        Sets the guest_vlan_tagging_allowed of this VdcNetwork.
        Whether guest VLAN tagging is allowed.

        :param guest_vlan_tagging_allowed: The guest_vlan_tagging_allowed of this VdcNetwork.
        :type: bool
        """

        self._guest_vlan_tagging_allowed = guest_vlan_tagging_allowed

    @property
    def retain_nic_resources(self):
        """
        Gets the retain_nic_resources of this VdcNetwork.
        Whether network resources such as IP/MAC Addresses are to be retained.

        :return: The retain_nic_resources of this VdcNetwork.
        :rtype: bool
        """
        return self._retain_nic_resources

    @retain_nic_resources.setter
    def retain_nic_resources(self, retain_nic_resources):
        """
        Sets the retain_nic_resources of this VdcNetwork.
        Whether network resources such as IP/MAC Addresses are to be retained.

        :param retain_nic_resources: The retain_nic_resources of this VdcNetwork.
        :type: bool
        """

        self._retain_nic_resources = retain_nic_resources

    @property
    def cross_vdc_network_id(self):
        """
        Gets the cross_vdc_network_id of this VdcNetwork.
        The id of the cross vdc network if this is a stretched network, otherwise it will be null.

        :return: The cross_vdc_network_id of this VdcNetwork.
        :rtype: str
        """
        return self._cross_vdc_network_id

    @cross_vdc_network_id.setter
    def cross_vdc_network_id(self, cross_vdc_network_id):
        """
        Sets the cross_vdc_network_id of this VdcNetwork.
        The id of the cross vdc network if this is a stretched network, otherwise it will be null.

        :param cross_vdc_network_id: The cross_vdc_network_id of this VdcNetwork.
        :type: str
        """

        self._cross_vdc_network_id = cross_vdc_network_id

    @property
    def cross_vdc_network_location_id(self):
        """
        Gets the cross_vdc_network_location_id of this VdcNetwork.
        The id of the org from which this network can be managed if this is a stretched network, otherwise it will be null.

        :return: The cross_vdc_network_location_id of this VdcNetwork.
        :rtype: str
        """
        return self._cross_vdc_network_location_id

    @cross_vdc_network_location_id.setter
    def cross_vdc_network_location_id(self, cross_vdc_network_location_id):
        """
        Sets the cross_vdc_network_location_id of this VdcNetwork.
        The id of the org from which this network can be managed if this is a stretched network, otherwise it will be null.

        :param cross_vdc_network_location_id: The cross_vdc_network_location_id of this VdcNetwork.
        :type: str
        """

        self._cross_vdc_network_location_id = cross_vdc_network_location_id

    @property
    def total_ip_count(self):
        """
        Gets the total_ip_count of this VdcNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :return: The total_ip_count of this VdcNetwork.
        :rtype: int
        """
        return self._total_ip_count

    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        """
        Sets the total_ip_count of this VdcNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :param total_ip_count: The total_ip_count of this VdcNetwork.
        :type: int
        """

        self._total_ip_count = total_ip_count

    @property
    def used_ip_count(self):
        """
        Gets the used_ip_count of this VdcNetwork.
        The number of IP address used from the static ip pools.

        :return: The used_ip_count of this VdcNetwork.
        :rtype: int
        """
        return self._used_ip_count

    @used_ip_count.setter
    def used_ip_count(self, used_ip_count):
        """
        Sets the used_ip_count of this VdcNetwork.
        The number of IP address used from the static ip pools.

        :param used_ip_count: The used_ip_count of this VdcNetwork.
        :type: int
        """

        self._used_ip_count = used_ip_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VdcNetwork):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
