# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VdcComputePolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'description': 'str',
        'name': 'str',
        'cpu_speed': 'int',
        'memory': 'int',
        'cpu_count': 'int',
        'cores_per_socket': 'int',
        'memory_reservation_guarantee': 'float',
        'cpu_reservation_guarantee': 'float',
        'cpu_limit': 'int',
        'memory_limit': 'int',
        'cpu_shares': 'int',
        'memory_shares': 'int',
        'extra_configs': 'dict(str, str)',
        'pvdc_compute_policy_ref': 'EntityReference',
        'pvdc_compute_policy': 'EntityReference',
        'compatible_vdc_types': 'list[str]',
        'is_sizing_only': 'bool',
        'pvdc_id': 'str',
        'named_vm_groups': 'list[list[EntityReference]]',
        'logical_vm_group_references': 'list[EntityReference]',
        'is_auto_generated': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'description': 'description',
        'name': 'name',
        'cpu_speed': 'cpuSpeed',
        'memory': 'memory',
        'cpu_count': 'cpuCount',
        'cores_per_socket': 'coresPerSocket',
        'memory_reservation_guarantee': 'memoryReservationGuarantee',
        'cpu_reservation_guarantee': 'cpuReservationGuarantee',
        'cpu_limit': 'cpuLimit',
        'memory_limit': 'memoryLimit',
        'cpu_shares': 'cpuShares',
        'memory_shares': 'memoryShares',
        'extra_configs': 'extraConfigs',
        'pvdc_compute_policy_ref': 'pvdcComputePolicyRef',
        'pvdc_compute_policy': 'pvdcComputePolicy',
        'compatible_vdc_types': 'compatibleVdcTypes',
        'is_sizing_only': 'isSizingOnly',
        'pvdc_id': 'pvdcId',
        'named_vm_groups': 'namedVmGroups',
        'logical_vm_group_references': 'logicalVmGroupReferences',
        'is_auto_generated': 'isAutoGenerated'
    }

    def __init__(self, id=None, description='A vDC compute policy.', name=None, cpu_speed=None, memory=None, cpu_count=None, cores_per_socket=None, memory_reservation_guarantee=None, cpu_reservation_guarantee=None, cpu_limit=None, memory_limit=None, cpu_shares=None, memory_shares=None, extra_configs=None, pvdc_compute_policy_ref=None, pvdc_compute_policy=None, compatible_vdc_types=None, is_sizing_only=None, pvdc_id=None, named_vm_groups=None, logical_vm_group_references=None, is_auto_generated=None):
        """
        VdcComputePolicy - a model defined in Swagger
        """

        self._id = None
        self._description = None
        self._name = None
        self._cpu_speed = None
        self._memory = None
        self._cpu_count = None
        self._cores_per_socket = None
        self._memory_reservation_guarantee = None
        self._cpu_reservation_guarantee = None
        self._cpu_limit = None
        self._memory_limit = None
        self._cpu_shares = None
        self._memory_shares = None
        self._extra_configs = None
        self._pvdc_compute_policy_ref = None
        self._pvdc_compute_policy = None
        self._compatible_vdc_types = None
        self._is_sizing_only = None
        self._pvdc_id = None
        self._named_vm_groups = None
        self._logical_vm_group_references = None
        self._is_auto_generated = None

        if id is not None:
          self.id = id
        if description is not None:
          self.description = description
        self.name = name
        if cpu_speed is not None:
          self.cpu_speed = cpu_speed
        if memory is not None:
          self.memory = memory
        if cpu_count is not None:
          self.cpu_count = cpu_count
        if cores_per_socket is not None:
          self.cores_per_socket = cores_per_socket
        if memory_reservation_guarantee is not None:
          self.memory_reservation_guarantee = memory_reservation_guarantee
        if cpu_reservation_guarantee is not None:
          self.cpu_reservation_guarantee = cpu_reservation_guarantee
        if cpu_limit is not None:
          self.cpu_limit = cpu_limit
        if memory_limit is not None:
          self.memory_limit = memory_limit
        if cpu_shares is not None:
          self.cpu_shares = cpu_shares
        if memory_shares is not None:
          self.memory_shares = memory_shares
        if extra_configs is not None:
          self.extra_configs = extra_configs
        if pvdc_compute_policy_ref is not None:
          self.pvdc_compute_policy_ref = pvdc_compute_policy_ref
        if pvdc_compute_policy is not None:
          self.pvdc_compute_policy = pvdc_compute_policy
        if compatible_vdc_types is not None:
          self.compatible_vdc_types = compatible_vdc_types
        if is_sizing_only is not None:
          self.is_sizing_only = is_sizing_only
        if pvdc_id is not None:
          self.pvdc_id = pvdc_id
        if named_vm_groups is not None:
          self.named_vm_groups = named_vm_groups
        if logical_vm_group_references is not None:
          self.logical_vm_group_references = logical_vm_group_references
        if is_auto_generated is not None:
          self.is_auto_generated = is_auto_generated

    @property
    def id(self):
        """
        Gets the id of this VdcComputePolicy.
        UUID for vDC compute policy. This is immutable. 

        :return: The id of this VdcComputePolicy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VdcComputePolicy.
        UUID for vDC compute policy. This is immutable. 

        :param id: The id of this VdcComputePolicy.
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """
        Gets the description of this VdcComputePolicy.

        :return: The description of this VdcComputePolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VdcComputePolicy.

        :param description: The description of this VdcComputePolicy.
        :type: str
        """
        if description is not None and len(description) > 256:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `256`")
        if description is not None and len(description) < 1:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")

        self._description = description

    @property
    def name(self):
        """
        Gets the name of this VdcComputePolicy.
        Display name. 

        :return: The name of this VdcComputePolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VdcComputePolicy.
        Display name. 

        :param name: The name of this VdcComputePolicy.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")

        self._name = name

    @property
    def cpu_speed(self):
        """
        Gets the cpu_speed of this VdcComputePolicy.
        The CPU speed in MHz of this VM. This is optional. When provided, VMs with this policy cannot have more than CPU speed defined by this field. 

        :return: The cpu_speed of this VdcComputePolicy.
        :rtype: int
        """
        return self._cpu_speed

    @cpu_speed.setter
    def cpu_speed(self, cpu_speed):
        """
        Sets the cpu_speed of this VdcComputePolicy.
        The CPU speed in MHz of this VM. This is optional. When provided, VMs with this policy cannot have more than CPU speed defined by this field. 

        :param cpu_speed: The cpu_speed of this VdcComputePolicy.
        :type: int
        """

        self._cpu_speed = cpu_speed

    @property
    def memory(self):
        """
        Gets the memory of this VdcComputePolicy.
        The maximum memory in MB allowed for a VM. This is optional. When provided, VMs with this policy cannot have configured memory more than defined by this field. 

        :return: The memory of this VdcComputePolicy.
        :rtype: int
        """
        return self._memory

    @memory.setter
    def memory(self, memory):
        """
        Sets the memory of this VdcComputePolicy.
        The maximum memory in MB allowed for a VM. This is optional. When provided, VMs with this policy cannot have configured memory more than defined by this field. 

        :param memory: The memory of this VdcComputePolicy.
        :type: int
        """

        self._memory = memory

    @property
    def cpu_count(self):
        """
        Gets the cpu_count of this VdcComputePolicy.
        The maximum number of CPUs allowed for a VM. This is optional. When provided, VMs with this policy cannot have more than number of CPUs defined by this field. 

        :return: The cpu_count of this VdcComputePolicy.
        :rtype: int
        """
        return self._cpu_count

    @cpu_count.setter
    def cpu_count(self, cpu_count):
        """
        Sets the cpu_count of this VdcComputePolicy.
        The maximum number of CPUs allowed for a VM. This is optional. When provided, VMs with this policy cannot have more than number of CPUs defined by this field. 

        :param cpu_count: The cpu_count of this VdcComputePolicy.
        :type: int
        """

        self._cpu_count = cpu_count

    @property
    def cores_per_socket(self):
        """
        Gets the cores_per_socket of this VdcComputePolicy.
        The cores per socket to be configured for the VM where this policy is applied. 

        :return: The cores_per_socket of this VdcComputePolicy.
        :rtype: int
        """
        return self._cores_per_socket

    @cores_per_socket.setter
    def cores_per_socket(self, cores_per_socket):
        """
        Sets the cores_per_socket of this VdcComputePolicy.
        The cores per socket to be configured for the VM where this policy is applied. 

        :param cores_per_socket: The cores_per_socket of this VdcComputePolicy.
        :type: int
        """

        self._cores_per_socket = cores_per_socket

    @property
    def memory_reservation_guarantee(self):
        """
        Gets the memory_reservation_guarantee of this VdcComputePolicy.
        The factor of the configured memory reserved for the VM on which this policy is applied. 

        :return: The memory_reservation_guarantee of this VdcComputePolicy.
        :rtype: float
        """
        return self._memory_reservation_guarantee

    @memory_reservation_guarantee.setter
    def memory_reservation_guarantee(self, memory_reservation_guarantee):
        """
        Sets the memory_reservation_guarantee of this VdcComputePolicy.
        The factor of the configured memory reserved for the VM on which this policy is applied. 

        :param memory_reservation_guarantee: The memory_reservation_guarantee of this VdcComputePolicy.
        :type: float
        """
        if memory_reservation_guarantee is not None and memory_reservation_guarantee > 1:
            raise ValueError("Invalid value for `memory_reservation_guarantee`, must be a value less than or equal to `1`")
        if memory_reservation_guarantee is not None and memory_reservation_guarantee < 0:
            raise ValueError("Invalid value for `memory_reservation_guarantee`, must be a value greater than or equal to `0`")

        self._memory_reservation_guarantee = memory_reservation_guarantee

    @property
    def cpu_reservation_guarantee(self):
        """
        Gets the cpu_reservation_guarantee of this VdcComputePolicy.
        The factor of the configured CPU reserved for the VM on which this policy is applied. 

        :return: The cpu_reservation_guarantee of this VdcComputePolicy.
        :rtype: float
        """
        return self._cpu_reservation_guarantee

    @cpu_reservation_guarantee.setter
    def cpu_reservation_guarantee(self, cpu_reservation_guarantee):
        """
        Sets the cpu_reservation_guarantee of this VdcComputePolicy.
        The factor of the configured CPU reserved for the VM on which this policy is applied. 

        :param cpu_reservation_guarantee: The cpu_reservation_guarantee of this VdcComputePolicy.
        :type: float
        """
        if cpu_reservation_guarantee is not None and cpu_reservation_guarantee > 1:
            raise ValueError("Invalid value for `cpu_reservation_guarantee`, must be a value less than or equal to `1`")
        if cpu_reservation_guarantee is not None and cpu_reservation_guarantee < 0:
            raise ValueError("Invalid value for `cpu_reservation_guarantee`, must be a value greater than or equal to `0`")

        self._cpu_reservation_guarantee = cpu_reservation_guarantee

    @property
    def cpu_limit(self):
        """
        Gets the cpu_limit of this VdcComputePolicy.
        The limit of CPU in MHz for the VM on which this policy is applied. -1 means unlimited. This is optional. If not provided, limit would be equal to the vCPUSpeed multiplied by numCPU. 

        :return: The cpu_limit of this VdcComputePolicy.
        :rtype: int
        """
        return self._cpu_limit

    @cpu_limit.setter
    def cpu_limit(self, cpu_limit):
        """
        Sets the cpu_limit of this VdcComputePolicy.
        The limit of CPU in MHz for the VM on which this policy is applied. -1 means unlimited. This is optional. If not provided, limit would be equal to the vCPUSpeed multiplied by numCPU. 

        :param cpu_limit: The cpu_limit of this VdcComputePolicy.
        :type: int
        """

        self._cpu_limit = cpu_limit

    @property
    def memory_limit(self):
        """
        Gets the memory_limit of this VdcComputePolicy.
        The limit of memory in MB for the VM on which this policy is applied. -1 means unlimited. This is optional. If not provided, limit would be equal to the configured memory of the VM. 

        :return: The memory_limit of this VdcComputePolicy.
        :rtype: int
        """
        return self._memory_limit

    @memory_limit.setter
    def memory_limit(self, memory_limit):
        """
        Sets the memory_limit of this VdcComputePolicy.
        The limit of memory in MB for the VM on which this policy is applied. -1 means unlimited. This is optional. If not provided, limit would be equal to the configured memory of the VM. 

        :param memory_limit: The memory_limit of this VdcComputePolicy.
        :type: int
        """

        self._memory_limit = memory_limit

    @property
    def cpu_shares(self):
        """
        Gets the cpu_shares of this VdcComputePolicy.
        The number of CPU shares for the VM on which this policy is applied. This is optional. If not provided, Normal shares would be applied to the VM. 

        :return: The cpu_shares of this VdcComputePolicy.
        :rtype: int
        """
        return self._cpu_shares

    @cpu_shares.setter
    def cpu_shares(self, cpu_shares):
        """
        Sets the cpu_shares of this VdcComputePolicy.
        The number of CPU shares for the VM on which this policy is applied. This is optional. If not provided, Normal shares would be applied to the VM. 

        :param cpu_shares: The cpu_shares of this VdcComputePolicy.
        :type: int
        """

        self._cpu_shares = cpu_shares

    @property
    def memory_shares(self):
        """
        Gets the memory_shares of this VdcComputePolicy.
        The number of memory shares for the VM on which this policy is applied. This is optional. If not provided, Normal shares would be applied to the VM. 

        :return: The memory_shares of this VdcComputePolicy.
        :rtype: int
        """
        return self._memory_shares

    @memory_shares.setter
    def memory_shares(self, memory_shares):
        """
        Sets the memory_shares of this VdcComputePolicy.
        The number of memory shares for the VM on which this policy is applied. This is optional. If not provided, Normal shares would be applied to the VM. 

        :param memory_shares: The memory_shares of this VdcComputePolicy.
        :type: int
        """

        self._memory_shares = memory_shares

    @property
    def extra_configs(self):
        """
        Gets the extra_configs of this VdcComputePolicy.
        Map of extra configs to be set on the VM with this policy. 

        :return: The extra_configs of this VdcComputePolicy.
        :rtype: dict(str, str)
        """
        return self._extra_configs

    @extra_configs.setter
    def extra_configs(self, extra_configs):
        """
        Sets the extra_configs of this VdcComputePolicy.
        Map of extra configs to be set on the VM with this policy. 

        :param extra_configs: The extra_configs of this VdcComputePolicy.
        :type: dict(str, str)
        """

        self._extra_configs = extra_configs

    @property
    def pvdc_compute_policy_ref(self):
        """
        Gets the pvdc_compute_policy_ref of this VdcComputePolicy.
        Deprecated in Api 32.0, this property will be removed in future release. 

        :return: The pvdc_compute_policy_ref of this VdcComputePolicy.
        :rtype: EntityReference
        """
        return self._pvdc_compute_policy_ref

    @pvdc_compute_policy_ref.setter
    def pvdc_compute_policy_ref(self, pvdc_compute_policy_ref):
        """
        Sets the pvdc_compute_policy_ref of this VdcComputePolicy.
        Deprecated in Api 32.0, this property will be removed in future release. 

        :param pvdc_compute_policy_ref: The pvdc_compute_policy_ref of this VdcComputePolicy.
        :type: EntityReference
        """

        self._pvdc_compute_policy_ref = pvdc_compute_policy_ref

    @property
    def pvdc_compute_policy(self):
        """
        Gets the pvdc_compute_policy of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. 

        :return: The pvdc_compute_policy of this VdcComputePolicy.
        :rtype: EntityReference
        """
        return self._pvdc_compute_policy

    @pvdc_compute_policy.setter
    def pvdc_compute_policy(self, pvdc_compute_policy):
        """
        Sets the pvdc_compute_policy of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. 

        :param pvdc_compute_policy: The pvdc_compute_policy of this VdcComputePolicy.
        :type: EntityReference
        """

        self._pvdc_compute_policy = pvdc_compute_policy

    @property
    def compatible_vdc_types(self):
        """
        Gets the compatible_vdc_types of this VdcComputePolicy.
        A list of read-only compatible vDC types for this policy.

        :return: The compatible_vdc_types of this VdcComputePolicy.
        :rtype: list[str]
        """
        return self._compatible_vdc_types

    @compatible_vdc_types.setter
    def compatible_vdc_types(self, compatible_vdc_types):
        """
        Sets the compatible_vdc_types of this VdcComputePolicy.
        A list of read-only compatible vDC types for this policy.

        :param compatible_vdc_types: The compatible_vdc_types of this VdcComputePolicy.
        :type: list[str]
        """

        self._compatible_vdc_types = compatible_vdc_types

    @property
    def is_sizing_only(self):
        """
        Gets the is_sizing_only of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. It defines whether the policy is SIZING_ONLY or if it also contains affinity information. 

        :return: The is_sizing_only of this VdcComputePolicy.
        :rtype: bool
        """
        return self._is_sizing_only

    @is_sizing_only.setter
    def is_sizing_only(self, is_sizing_only):
        """
        Sets the is_sizing_only of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client after creation. It defines whether the policy is SIZING_ONLY or if it also contains affinity information. 

        :param is_sizing_only: The is_sizing_only of this VdcComputePolicy.
        :type: bool
        """

        self._is_sizing_only = is_sizing_only

    @property
    def pvdc_id(self):
        """
        Gets the pvdc_id of this VdcComputePolicy.
        URN for Provider VDC. 

        :return: The pvdc_id of this VdcComputePolicy.
        :rtype: str
        """
        return self._pvdc_id

    @pvdc_id.setter
    def pvdc_id(self, pvdc_id):
        """
        Sets the pvdc_id of this VdcComputePolicy.
        URN for Provider VDC. 

        :param pvdc_id: The pvdc_id of this VdcComputePolicy.
        :type: str
        """

        self._pvdc_id = pvdc_id

    @property
    def named_vm_groups(self):
        """
        Gets the named_vm_groups of this VdcComputePolicy.
        List of list of vmGroups grouped together in a meaningful manner. A group of vmGroups would consist of one functionally equal vmGroup picked from each cluster of the pvdc. 

        :return: The named_vm_groups of this VdcComputePolicy.
        :rtype: list[list[EntityReference]]
        """
        return self._named_vm_groups

    @named_vm_groups.setter
    def named_vm_groups(self, named_vm_groups):
        """
        Sets the named_vm_groups of this VdcComputePolicy.
        List of list of vmGroups grouped together in a meaningful manner. A group of vmGroups would consist of one functionally equal vmGroup picked from each cluster of the pvdc. 

        :param named_vm_groups: The named_vm_groups of this VdcComputePolicy.
        :type: list[list[EntityReference]]
        """

        self._named_vm_groups = named_vm_groups

    @property
    def logical_vm_group_references(self):
        """
        Gets the logical_vm_group_references of this VdcComputePolicy.
        List of logical vm group references. This value is set at creation time and cannot be edited later. 

        :return: The logical_vm_group_references of this VdcComputePolicy.
        :rtype: list[EntityReference]
        """
        return self._logical_vm_group_references

    @logical_vm_group_references.setter
    def logical_vm_group_references(self, logical_vm_group_references):
        """
        Sets the logical_vm_group_references of this VdcComputePolicy.
        List of logical vm group references. This value is set at creation time and cannot be edited later. 

        :param logical_vm_group_references: The logical_vm_group_references of this VdcComputePolicy.
        :type: list[EntityReference]
        """

        self._logical_vm_group_references = logical_vm_group_references

    @property
    def is_auto_generated(self):
        """
        Gets the is_auto_generated of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client. It defines if the policy is auto-generated. 

        :return: The is_auto_generated of this VdcComputePolicy.
        :rtype: bool
        """
        return self._is_auto_generated

    @is_auto_generated.setter
    def is_auto_generated(self, is_auto_generated):
        """
        Sets the is_auto_generated of this VdcComputePolicy.
        This field cannot be updated and is a read-only field in the client. It defines if the policy is auto-generated. 

        :param is_auto_generated: The is_auto_generated of this VdcComputePolicy.
        :type: bool
        """

        self._is_auto_generated = is_auto_generated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VdcComputePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
