# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'org_entity_ref': 'EntityReference',
        'source_entity_ref': 'EntityReference',
        'role_entity_ref': 'EntityReference',
        'name_in_source': 'str',
        'provider_type': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'org_entity_ref': 'orgEntityRef',
        'source_entity_ref': 'sourceEntityRef',
        'role_entity_ref': 'roleEntityRef',
        'name_in_source': 'nameInSource',
        'provider_type': 'providerType'
    }

    def __init__(self, name=None, description=None, org_entity_ref=None, source_entity_ref=None, role_entity_ref=None, name_in_source=None, provider_type=None):
        """
        UserGroup - a model defined in Swagger
        """

        self._name = None
        self._description = None
        self._org_entity_ref = None
        self._source_entity_ref = None
        self._role_entity_ref = None
        self._name_in_source = None
        self._provider_type = None

        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if org_entity_ref is not None:
          self.org_entity_ref = org_entity_ref
        if source_entity_ref is not None:
          self.source_entity_ref = source_entity_ref
        if role_entity_ref is not None:
          self.role_entity_ref = role_entity_ref
        if name_in_source is not None:
          self.name_in_source = name_in_source
        if provider_type is not None:
          self.provider_type = provider_type

    @property
    def name(self):
        """
        Gets the name of this UserGroup.

        :return: The name of this UserGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UserGroup.

        :param name: The name of this UserGroup.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this UserGroup.

        :return: The description of this UserGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UserGroup.

        :param description: The description of this UserGroup.
        :type: str
        """

        self._description = description

    @property
    def org_entity_ref(self):
        """
        Gets the org_entity_ref of this UserGroup.

        :return: The org_entity_ref of this UserGroup.
        :rtype: EntityReference
        """
        return self._org_entity_ref

    @org_entity_ref.setter
    def org_entity_ref(self, org_entity_ref):
        """
        Sets the org_entity_ref of this UserGroup.

        :param org_entity_ref: The org_entity_ref of this UserGroup.
        :type: EntityReference
        """

        self._org_entity_ref = org_entity_ref

    @property
    def source_entity_ref(self):
        """
        Gets the source_entity_ref of this UserGroup.

        :return: The source_entity_ref of this UserGroup.
        :rtype: EntityReference
        """
        return self._source_entity_ref

    @source_entity_ref.setter
    def source_entity_ref(self, source_entity_ref):
        """
        Sets the source_entity_ref of this UserGroup.

        :param source_entity_ref: The source_entity_ref of this UserGroup.
        :type: EntityReference
        """

        self._source_entity_ref = source_entity_ref

    @property
    def role_entity_ref(self):
        """
        Gets the role_entity_ref of this UserGroup.

        :return: The role_entity_ref of this UserGroup.
        :rtype: EntityReference
        """
        return self._role_entity_ref

    @role_entity_ref.setter
    def role_entity_ref(self, role_entity_ref):
        """
        Sets the role_entity_ref of this UserGroup.

        :param role_entity_ref: The role_entity_ref of this UserGroup.
        :type: EntityReference
        """

        self._role_entity_ref = role_entity_ref

    @property
    def name_in_source(self):
        """
        Gets the name_in_source of this UserGroup.

        :return: The name_in_source of this UserGroup.
        :rtype: str
        """
        return self._name_in_source

    @name_in_source.setter
    def name_in_source(self, name_in_source):
        """
        Sets the name_in_source of this UserGroup.

        :param name_in_source: The name_in_source of this UserGroup.
        :type: str
        """

        self._name_in_source = name_in_source

    @property
    def provider_type(self):
        """
        Gets the provider_type of this UserGroup.

        :return: The provider_type of this UserGroup.
        :rtype: str
        """
        return self._provider_type

    @provider_type.setter
    def provider_type(self, provider_type):
        """
        Sets the provider_type of this UserGroup.

        :param provider_type: The provider_type of this UserGroup.
        :type: str
        """
        allowed_values = ["UNKNOWN", "INTEGRATED", "SAML", "OAUTH"]
        if provider_type not in allowed_values:
            raise ValueError(
                "Invalid value for `provider_type` ({0}), must be one of {1}"
                .format(provider_type, allowed_values)
            )

        self._provider_type = provider_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UserGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
