# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UniversalRoute(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_egress': 'EgressPointReference',
        'standby_egress': 'EgressPointReference',
        'network_provider_scope': 'str',
        'status': 'UniversalRoutingStatus',
        'error_message': 'str'
    }

    attribute_map = {
        'default_egress': 'defaultEgress',
        'standby_egress': 'standbyEgress',
        'network_provider_scope': 'networkProviderScope',
        'status': 'status',
        'error_message': 'errorMessage'
    }

    def __init__(self, default_egress=None, standby_egress=None, network_provider_scope=None, status=None, error_message=None):
        """
        UniversalRoute - a model defined in Swagger
        """

        self._default_egress = None
        self._standby_egress = None
        self._network_provider_scope = None
        self._status = None
        self._error_message = None

        if default_egress is not None:
          self.default_egress = default_egress
        if standby_egress is not None:
          self.standby_egress = standby_egress
        self.network_provider_scope = network_provider_scope
        if status is not None:
          self.status = status
        if error_message is not None:
          self.error_message = error_message

    @property
    def default_egress(self):
        """
        Gets the default_egress of this UniversalRoute.
        For a given route, routing by default will go through the default egress point. Every valid/configured route will have a default egress point.

        :return: The default_egress of this UniversalRoute.
        :rtype: EgressPointReference
        """
        return self._default_egress

    @default_egress.setter
    def default_egress(self, default_egress):
        """
        Sets the default_egress of this UniversalRoute.
        For a given route, routing by default will go through the default egress point. Every valid/configured route will have a default egress point.

        :param default_egress: The default_egress of this UniversalRoute.
        :type: EgressPointReference
        """

        self._default_egress = default_egress

    @property
    def standby_egress(self):
        """
        Gets the standby_egress of this UniversalRoute.
        A standby egress point can be configured for failover of routes in case there is an issue routign to the default egress point.

        :return: The standby_egress of this UniversalRoute.
        :rtype: EgressPointReference
        """
        return self._standby_egress

    @standby_egress.setter
    def standby_egress(self, standby_egress):
        """
        Sets the standby_egress of this UniversalRoute.
        A standby egress point can be configured for failover of routes in case there is an issue routign to the default egress point.

        :param standby_egress: The standby_egress of this UniversalRoute.
        :type: EgressPointReference
        """

        self._standby_egress = standby_egress

    @property
    def network_provider_scope(self):
        """
        Gets the network_provider_scope of this UniversalRoute.
        The network provider scope for the given route. There can only be one route per fault domain for a Universal Route.

        :return: The network_provider_scope of this UniversalRoute.
        :rtype: str
        """
        return self._network_provider_scope

    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        """
        Sets the network_provider_scope of this UniversalRoute.
        The network provider scope for the given route. There can only be one route per fault domain for a Universal Route.

        :param network_provider_scope: The network_provider_scope of this UniversalRoute.
        :type: str
        """
        if network_provider_scope is None:
            raise ValueError("Invalid value for `network_provider_scope`, must not be `None`")

        self._network_provider_scope = network_provider_scope

    @property
    def status(self):
        """
        Gets the status of this UniversalRoute.
        The status of the route (whether it's realized, failed, etc.).

        :return: The status of this UniversalRoute.
        :rtype: UniversalRoutingStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UniversalRoute.
        The status of the route (whether it's realized, failed, etc.).

        :param status: The status of this UniversalRoute.
        :type: UniversalRoutingStatus
        """

        self._status = status

    @property
    def error_message(self):
        """
        Gets the error_message of this UniversalRoute.

        :return: The error_message of this UniversalRoute.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this UniversalRoute.

        :param error_message: The error_message of this UniversalRoute.
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UniversalRoute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
