# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ServiceItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'service_item_type': 'str',
        'description': 'str',
        'can_execute': 'bool',
        'service_name': 'str',
        'service_id': 'str',
        'icon_mime_type': 'str',
        'icon_data': 'str',
        'tenant_scoped': 'bool',
        'provider_scoped': 'bool',
        'publish_all': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'service_item_type': 'serviceItemType',
        'description': 'description',
        'can_execute': 'canExecute',
        'service_name': 'serviceName',
        'service_id': 'serviceId',
        'icon_mime_type': 'iconMimeType',
        'icon_data': 'iconData',
        'tenant_scoped': 'tenantScoped',
        'provider_scoped': 'providerScoped',
        'publish_all': 'publishAll'
    }

    def __init__(self, id=None, name=None, service_item_type=None, description=None, can_execute=None, service_name=None, service_id=None, icon_mime_type=None, icon_data=None, tenant_scoped=True, provider_scoped=True, publish_all=False):
        """
        ServiceItem - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._service_item_type = None
        self._description = None
        self._can_execute = None
        self._service_name = None
        self._service_id = None
        self._icon_mime_type = None
        self._icon_data = None
        self._tenant_scoped = None
        self._provider_scoped = None
        self._publish_all = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        self.service_item_type = service_item_type
        if description is not None:
          self.description = description
        if can_execute is not None:
          self.can_execute = can_execute
        if service_name is not None:
          self.service_name = service_name
        if service_id is not None:
          self.service_id = service_id
        if icon_mime_type is not None:
          self.icon_mime_type = icon_mime_type
        if icon_data is not None:
          self.icon_data = icon_data
        if tenant_scoped is not None:
          self.tenant_scoped = tenant_scoped
        if provider_scoped is not None:
          self.provider_scoped = provider_scoped
        if publish_all is not None:
          self.publish_all = publish_all

    @property
    def id(self):
        """
        Gets the id of this ServiceItem.

        :return: The id of this ServiceItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ServiceItem.

        :param id: The id of this ServiceItem.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ServiceItem.

        :return: The name of this ServiceItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ServiceItem.

        :param name: The name of this ServiceItem.
        :type: str
        """

        self._name = name

    @property
    def service_item_type(self):
        """
        Gets the service_item_type of this ServiceItem.

        :return: The service_item_type of this ServiceItem.
        :rtype: str
        """
        return self._service_item_type

    @service_item_type.setter
    def service_item_type(self, service_item_type):
        """
        Sets the service_item_type of this ServiceItem.

        :param service_item_type: The service_item_type of this ServiceItem.
        :type: str
        """
        if service_item_type is None:
            raise ValueError("Invalid value for `service_item_type`, must not be `None`")

        self._service_item_type = service_item_type

    @property
    def description(self):
        """
        Gets the description of this ServiceItem.

        :return: The description of this ServiceItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ServiceItem.

        :param description: The description of this ServiceItem.
        :type: str
        """

        self._description = description

    @property
    def can_execute(self):
        """
        Gets the can_execute of this ServiceItem.

        :return: The can_execute of this ServiceItem.
        :rtype: bool
        """
        return self._can_execute

    @can_execute.setter
    def can_execute(self, can_execute):
        """
        Sets the can_execute of this ServiceItem.

        :param can_execute: The can_execute of this ServiceItem.
        :type: bool
        """

        self._can_execute = can_execute

    @property
    def service_name(self):
        """
        Gets the service_name of this ServiceItem.

        :return: The service_name of this ServiceItem.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this ServiceItem.

        :param service_name: The service_name of this ServiceItem.
        :type: str
        """

        self._service_name = service_name

    @property
    def service_id(self):
        """
        Gets the service_id of this ServiceItem.

        :return: The service_id of this ServiceItem.
        :rtype: str
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """
        Sets the service_id of this ServiceItem.

        :param service_id: The service_id of this ServiceItem.
        :type: str
        """

        self._service_id = service_id

    @property
    def icon_mime_type(self):
        """
        Gets the icon_mime_type of this ServiceItem.

        :return: The icon_mime_type of this ServiceItem.
        :rtype: str
        """
        return self._icon_mime_type

    @icon_mime_type.setter
    def icon_mime_type(self, icon_mime_type):
        """
        Sets the icon_mime_type of this ServiceItem.

        :param icon_mime_type: The icon_mime_type of this ServiceItem.
        :type: str
        """

        self._icon_mime_type = icon_mime_type

    @property
    def icon_data(self):
        """
        Gets the icon_data of this ServiceItem.

        :return: The icon_data of this ServiceItem.
        :rtype: str
        """
        return self._icon_data

    @icon_data.setter
    def icon_data(self, icon_data):
        """
        Sets the icon_data of this ServiceItem.

        :param icon_data: The icon_data of this ServiceItem.
        :type: str
        """

        self._icon_data = icon_data

    @property
    def tenant_scoped(self):
        """
        Gets the tenant_scoped of this ServiceItem.

        :return: The tenant_scoped of this ServiceItem.
        :rtype: bool
        """
        return self._tenant_scoped

    @tenant_scoped.setter
    def tenant_scoped(self, tenant_scoped):
        """
        Sets the tenant_scoped of this ServiceItem.

        :param tenant_scoped: The tenant_scoped of this ServiceItem.
        :type: bool
        """

        self._tenant_scoped = tenant_scoped

    @property
    def provider_scoped(self):
        """
        Gets the provider_scoped of this ServiceItem.

        :return: The provider_scoped of this ServiceItem.
        :rtype: bool
        """
        return self._provider_scoped

    @provider_scoped.setter
    def provider_scoped(self, provider_scoped):
        """
        Sets the provider_scoped of this ServiceItem.

        :param provider_scoped: The provider_scoped of this ServiceItem.
        :type: bool
        """

        self._provider_scoped = provider_scoped

    @property
    def publish_all(self):
        """
        Gets the publish_all of this ServiceItem.
        Read-only value indicating publishAll state 

        :return: The publish_all of this ServiceItem.
        :rtype: bool
        """
        return self._publish_all

    @publish_all.setter
    def publish_all(self, publish_all):
        """
        Sets the publish_all of this ServiceItem.
        Read-only value indicating publishAll state 

        :param publish_all: The publish_all of this ServiceItem.
        :type: bool
        """

        self._publish_all = publish_all

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ServiceItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
