# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SddcProxy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'id': 'str',
        'sddc_id': 'str',
        'enabled': 'bool',
        'tenant_visible': 'bool',
        'target_host': 'str',
        'active': 'bool',
        'token': 'str',
        'default_proxy': 'bool',
        'parent_proxy_id': 'str',
        'ui_url': 'str'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'sddc_id': 'sddcId',
        'enabled': 'enabled',
        'tenant_visible': 'tenantVisible',
        'target_host': 'targetHost',
        'active': 'active',
        'token': 'token',
        'default_proxy': 'defaultProxy',
        'parent_proxy_id': 'parentProxyId',
        'ui_url': 'uiUrl'
    }

    def __init__(self, name=None, id=None, sddc_id=None, enabled=True, tenant_visible=False, target_host=None, active=False, token=None, default_proxy=False, parent_proxy_id=None, ui_url=''):
        """
        SddcProxy - a model defined in Swagger
        """

        self._name = None
        self._id = None
        self._sddc_id = None
        self._enabled = None
        self._tenant_visible = None
        self._target_host = None
        self._active = None
        self._token = None
        self._default_proxy = None
        self._parent_proxy_id = None
        self._ui_url = None

        self.name = name
        if id is not None:
          self.id = id
        self.sddc_id = sddc_id
        if enabled is not None:
          self.enabled = enabled
        if tenant_visible is not None:
          self.tenant_visible = tenant_visible
        self.target_host = target_host
        if active is not None:
          self.active = active
        if token is not None:
          self.token = token
        if default_proxy is not None:
          self.default_proxy = default_proxy
        if parent_proxy_id is not None:
          self.parent_proxy_id = parent_proxy_id
        if ui_url is not None:
          self.ui_url = ui_url

    @property
    def name(self):
        """
        Gets the name of this SddcProxy.

        :return: The name of this SddcProxy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SddcProxy.

        :param name: The name of this SddcProxy.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and not re.search('.*[\\S].*', name):
            raise ValueError("Invalid value for `name`, must be a follow pattern or equal to `/.*[\\S].*/`")

        self._name = name

    @property
    def id(self):
        """
        Gets the id of this SddcProxy.

        :return: The id of this SddcProxy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SddcProxy.

        :param id: The id of this SddcProxy.
        :type: str
        """

        self._id = id

    @property
    def sddc_id(self):
        """
        Gets the sddc_id of this SddcProxy.
        URN of the parent SDDC. This is not editable once the proxy has been created.

        :return: The sddc_id of this SddcProxy.
        :rtype: str
        """
        return self._sddc_id

    @sddc_id.setter
    def sddc_id(self, sddc_id):
        """
        Sets the sddc_id of this SddcProxy.
        URN of the parent SDDC. This is not editable once the proxy has been created.

        :param sddc_id: The sddc_id of this SddcProxy.
        :type: str
        """
        if sddc_id is None:
            raise ValueError("Invalid value for `sddc_id`, must not be `None`")

        self._sddc_id = sddc_id

    @property
    def enabled(self):
        """
        Gets the enabled of this SddcProxy.
        True if the proxy is enabled. Proxy can only be enabled/disabled by privileged users. A disabled proxy cannot be activated and thus, cannot be used. When a proxy is disabled, all active sessions are terminated. 

        :return: The enabled of this SddcProxy.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this SddcProxy.
        True if the proxy is enabled. Proxy can only be enabled/disabled by privileged users. A disabled proxy cannot be activated and thus, cannot be used. When a proxy is disabled, all active sessions are terminated. 

        :param enabled: The enabled of this SddcProxy.
        :type: bool
        """

        self._enabled = enabled

    @property
    def tenant_visible(self):
        """
        Gets the tenant_visible of this SddcProxy.
        Whether this proxy has been published to tenants.

        :return: The tenant_visible of this SddcProxy.
        :rtype: bool
        """
        return self._tenant_visible

    @tenant_visible.setter
    def tenant_visible(self, tenant_visible):
        """
        Sets the tenant_visible of this SddcProxy.
        Whether this proxy has been published to tenants.

        :param tenant_visible: The tenant_visible of this SddcProxy.
        :type: bool
        """

        self._tenant_visible = tenant_visible

    @property
    def target_host(self):
        """
        Gets the target_host of this SddcProxy.
        IP address or FQDN of the host being proxied. This is not editable once the proxy has been created.

        :return: The target_host of this SddcProxy.
        :rtype: str
        """
        return self._target_host

    @target_host.setter
    def target_host(self, target_host):
        """
        Sets the target_host of this SddcProxy.
        IP address or FQDN of the host being proxied. This is not editable once the proxy has been created.

        :param target_host: The target_host of this SddcProxy.
        :type: str
        """
        if target_host is None:
            raise ValueError("Invalid value for `target_host`, must not be `None`")

        self._target_host = target_host

    @property
    def active(self):
        """
        Gets the active of this SddcProxy.
        True if the proxy is currently active for the user session associated with the request made to get the proxy. An inactive proxy cannot be used. 

        :return: The active of this SddcProxy.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this SddcProxy.
        True if the proxy is currently active for the user session associated with the request made to get the proxy. An inactive proxy cannot be used. 

        :param active: The active of this SddcProxy.
        :type: bool
        """

        self._active = active

    @property
    def token(self):
        """
        Gets the token of this SddcProxy.
        The generated read-only token that should be used as the password when using this proxy. To generate a new token, activate the proxy. The token is tied to the user session that activated the proxy. If the proxy is inactive, this value will be null. 

        :return: The token of this SddcProxy.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this SddcProxy.
        The generated read-only token that should be used as the password when using this proxy. To generate a new token, activate the proxy. The token is tied to the user session that activated the proxy. If the proxy is inactive, this value will be null. 

        :param token: The token of this SddcProxy.
        :type: str
        """

        self._token = token

    @property
    def default_proxy(self):
        """
        Gets the default_proxy of this SddcProxy.
        True if this is the default proxy for the parent SDDC. A proxy being the default for the SDDC means that this proxy's UI will be launched when the SDDC tile is clicked in the H5 Tenant UI of VCD. If no default proxy is set, clicking the SDDC tile will be a no-op. 

        :return: The default_proxy of this SddcProxy.
        :rtype: bool
        """
        return self._default_proxy

    @default_proxy.setter
    def default_proxy(self, default_proxy):
        """
        Sets the default_proxy of this SddcProxy.
        True if this is the default proxy for the parent SDDC. A proxy being the default for the SDDC means that this proxy's UI will be launched when the SDDC tile is clicked in the H5 Tenant UI of VCD. If no default proxy is set, clicking the SDDC tile will be a no-op. 

        :param default_proxy: The default_proxy of this SddcProxy.
        :type: bool
        """

        self._default_proxy = default_proxy

    @property
    def parent_proxy_id(self):
        """
        Gets the parent_proxy_id of this SddcProxy.
        The URN of the parent proxy. If a proxy has a parent, the proxy is activated along with its parent and shares the token with its parent. Each proxy may only have one parent. A parent proxy cannot have a parent of its own. 

        :return: The parent_proxy_id of this SddcProxy.
        :rtype: str
        """
        return self._parent_proxy_id

    @parent_proxy_id.setter
    def parent_proxy_id(self, parent_proxy_id):
        """
        Sets the parent_proxy_id of this SddcProxy.
        The URN of the parent proxy. If a proxy has a parent, the proxy is activated along with its parent and shares the token with its parent. Each proxy may only have one parent. A parent proxy cannot have a parent of its own. 

        :param parent_proxy_id: The parent_proxy_id of this SddcProxy.
        :type: str
        """

        self._parent_proxy_id = parent_proxy_id

    @property
    def ui_url(self):
        """
        Gets the ui_url of this SddcProxy.
        The URL of the proxied component's UI endpoint. This is the URL that the browser tab  will be pointed to when the proxy is launched via the H5 UI of VCD. 

        :return: The ui_url of this SddcProxy.
        :rtype: str
        """
        return self._ui_url

    @ui_url.setter
    def ui_url(self, ui_url):
        """
        Sets the ui_url of this SddcProxy.
        The URL of the proxied component's UI endpoint. This is the URL that the browser tab  will be pointed to when the proxy is launched via the H5 UI of VCD. 

        :param ui_url: The ui_url of this SddcProxy.
        :type: str
        """

        self._ui_url = ui_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SddcProxy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
