# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PreferenceDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'classifier': 'str',
        'data_type': 'str',
        'constrained': 'bool',
        'min_value': 'float',
        'max_value': 'float',
        'default_value': 'str',
        'allowed_values': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'classifier': 'classifier',
        'data_type': 'dataType',
        'constrained': 'constrained',
        'min_value': 'minValue',
        'max_value': 'maxValue',
        'default_value': 'defaultValue',
        'allowed_values': 'allowedValues'
    }

    def __init__(self, id=None, name=None, description='', classifier=None, data_type=None, constrained=None, min_value=None, max_value=None, default_value=None, allowed_values=None):
        """
        PreferenceDefinition - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._classifier = None
        self._data_type = None
        self._constrained = None
        self._min_value = None
        self._max_value = None
        self._default_value = None
        self._allowed_values = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        self.classifier = classifier
        self.data_type = data_type
        self.constrained = constrained
        if min_value is not None:
          self.min_value = min_value
        if max_value is not None:
          self.max_value = max_value
        self.default_value = default_value
        if allowed_values is not None:
          self.allowed_values = allowed_values

    @property
    def id(self):
        """
        Gets the id of this PreferenceDefinition.
        UUID for preference definition. This is immutable. 

        :return: The id of this PreferenceDefinition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PreferenceDefinition.
        UUID for preference definition. This is immutable. 

        :param id: The id of this PreferenceDefinition.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this PreferenceDefinition.
        Display name. 

        :return: The name of this PreferenceDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PreferenceDefinition.
        Display name. 

        :param name: The name of this PreferenceDefinition.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this PreferenceDefinition.
        Description for user preference 

        :return: The description of this PreferenceDefinition.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this PreferenceDefinition.
        Description for user preference 

        :param description: The description of this PreferenceDefinition.
        :type: str
        """

        self._description = description

    @property
    def classifier(self):
        """
        Gets the classifier of this PreferenceDefinition.
        unique indetifier for this preference definition. It should be of type <scope>:<name>. e.g vrops:myworkflow. This is immutable. 

        :return: The classifier of this PreferenceDefinition.
        :rtype: str
        """
        return self._classifier

    @classifier.setter
    def classifier(self, classifier):
        """
        Sets the classifier of this PreferenceDefinition.
        unique indetifier for this preference definition. It should be of type <scope>:<name>. e.g vrops:myworkflow. This is immutable. 

        :param classifier: The classifier of this PreferenceDefinition.
        :type: str
        """
        if classifier is None:
            raise ValueError("Invalid value for `classifier`, must not be `None`")

        self._classifier = classifier

    @property
    def data_type(self):
        """
        Gets the data_type of this PreferenceDefinition.
        user preference value data type. This is immutable. 

        :return: The data_type of this PreferenceDefinition.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this PreferenceDefinition.
        user preference value data type. This is immutable. 

        :param data_type: The data_type of this PreferenceDefinition.
        :type: str
        """
        if data_type is None:
            raise ValueError("Invalid value for `data_type`, must not be `None`")
        allowed_values = ["BOOLEAN", "INTEGER", "STRING"]
        if data_type not in allowed_values:
            raise ValueError(
                "Invalid value for `data_type` ({0}), must be one of {1}"
                .format(data_type, allowed_values)
            )

        self._data_type = data_type

    @property
    def constrained(self):
        """
        Gets the constrained of this PreferenceDefinition.
        true if user preference is selected from list of values (dataType should be number or string), false otherwise. This is immutable. 

        :return: The constrained of this PreferenceDefinition.
        :rtype: bool
        """
        return self._constrained

    @constrained.setter
    def constrained(self, constrained):
        """
        Sets the constrained of this PreferenceDefinition.
        true if user preference is selected from list of values (dataType should be number or string), false otherwise. This is immutable. 

        :param constrained: The constrained of this PreferenceDefinition.
        :type: bool
        """
        if constrained is None:
            raise ValueError("Invalid value for `constrained`, must not be `None`")

        self._constrained = constrained

    @property
    def min_value(self):
        """
        Gets the min_value of this PreferenceDefinition.
        minimum value for user preference. Only valid if user preference type is number. This is immutable. 

        :return: The min_value of this PreferenceDefinition.
        :rtype: float
        """
        return self._min_value

    @min_value.setter
    def min_value(self, min_value):
        """
        Sets the min_value of this PreferenceDefinition.
        minimum value for user preference. Only valid if user preference type is number. This is immutable. 

        :param min_value: The min_value of this PreferenceDefinition.
        :type: float
        """

        self._min_value = min_value

    @property
    def max_value(self):
        """
        Gets the max_value of this PreferenceDefinition.
        maximum value for user preference. Only valid if user preference type is number. This is immutable. 

        :return: The max_value of this PreferenceDefinition.
        :rtype: float
        """
        return self._max_value

    @max_value.setter
    def max_value(self, max_value):
        """
        Sets the max_value of this PreferenceDefinition.
        maximum value for user preference. Only valid if user preference type is number. This is immutable. 

        :param max_value: The max_value of this PreferenceDefinition.
        :type: float
        """

        self._max_value = max_value

    @property
    def default_value(self):
        """
        Gets the default_value of this PreferenceDefinition.

        :return: The default_value of this PreferenceDefinition.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this PreferenceDefinition.

        :param default_value: The default_value of this PreferenceDefinition.
        :type: str
        """
        if default_value is None:
            raise ValueError("Invalid value for `default_value`, must not be `None`")

        self._default_value = default_value

    @property
    def allowed_values(self):
        """
        Gets the allowed_values of this PreferenceDefinition.
        array of allowed values to select from when constrained is true.. This is immutable after creation.

        :return: The allowed_values of this PreferenceDefinition.
        :rtype: list[str]
        """
        return self._allowed_values

    @allowed_values.setter
    def allowed_values(self, allowed_values):
        """
        Sets the allowed_values of this PreferenceDefinition.
        array of allowed values to select from when constrained is true.. This is immutable after creation.

        :param allowed_values: The allowed_values of this PreferenceDefinition.
        :type: list[str]
        """

        self._allowed_values = allowed_values

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PreferenceDefinition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
