# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ParameterTypes(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sdk_object': 'SdkObject',
        'string': 'StringParam',
        'secure_string': 'SecureString',
        'number': 'NumberParam',
        'mime_attachment': 'MimeAttachment',
        'properties': 'Properties',
        'date': 'DateParam',
        'boolean': 'BooleanParam',
        'composite': 'CompositeType',
        'regex': 'Regex',
        'encrypted_string': 'EncryptedString',
        'key_value_pair': 'KeyValuePair',
        'composite_value': 'CompositeValue',
        'array': 'ArrayParam'
    }

    attribute_map = {
        'sdk_object': 'sdkObject',
        'string': 'string',
        'secure_string': 'secureString',
        'number': 'number',
        'mime_attachment': 'mimeAttachment',
        'properties': 'properties',
        'date': 'date',
        'boolean': 'boolean',
        'composite': 'composite',
        'regex': 'regex',
        'encrypted_string': 'encryptedString',
        'key_value_pair': 'keyValuePair',
        'composite_value': 'compositeValue',
        'array': 'array'
    }

    def __init__(self, sdk_object=None, string=None, secure_string=None, number=None, mime_attachment=None, properties=None, date=None, boolean=None, composite=None, regex=None, encrypted_string=None, key_value_pair=None, composite_value=None, array=None):
        """
        ParameterTypes - a model defined in Swagger
        """

        self._sdk_object = None
        self._string = None
        self._secure_string = None
        self._number = None
        self._mime_attachment = None
        self._properties = None
        self._date = None
        self._boolean = None
        self._composite = None
        self._regex = None
        self._encrypted_string = None
        self._key_value_pair = None
        self._composite_value = None
        self._array = None

        if sdk_object is not None:
          self.sdk_object = sdk_object
        if string is not None:
          self.string = string
        if secure_string is not None:
          self.secure_string = secure_string
        if number is not None:
          self.number = number
        if mime_attachment is not None:
          self.mime_attachment = mime_attachment
        if properties is not None:
          self.properties = properties
        if date is not None:
          self.date = date
        if boolean is not None:
          self.boolean = boolean
        if composite is not None:
          self.composite = composite
        if regex is not None:
          self.regex = regex
        if encrypted_string is not None:
          self.encrypted_string = encrypted_string
        if key_value_pair is not None:
          self.key_value_pair = key_value_pair
        if composite_value is not None:
          self.composite_value = composite_value
        if array is not None:
          self.array = array

    @property
    def sdk_object(self):
        """
        Gets the sdk_object of this ParameterTypes.

        :return: The sdk_object of this ParameterTypes.
        :rtype: SdkObject
        """
        return self._sdk_object

    @sdk_object.setter
    def sdk_object(self, sdk_object):
        """
        Sets the sdk_object of this ParameterTypes.

        :param sdk_object: The sdk_object of this ParameterTypes.
        :type: SdkObject
        """

        self._sdk_object = sdk_object

    @property
    def string(self):
        """
        Gets the string of this ParameterTypes.

        :return: The string of this ParameterTypes.
        :rtype: StringParam
        """
        return self._string

    @string.setter
    def string(self, string):
        """
        Sets the string of this ParameterTypes.

        :param string: The string of this ParameterTypes.
        :type: StringParam
        """

        self._string = string

    @property
    def secure_string(self):
        """
        Gets the secure_string of this ParameterTypes.

        :return: The secure_string of this ParameterTypes.
        :rtype: SecureString
        """
        return self._secure_string

    @secure_string.setter
    def secure_string(self, secure_string):
        """
        Sets the secure_string of this ParameterTypes.

        :param secure_string: The secure_string of this ParameterTypes.
        :type: SecureString
        """

        self._secure_string = secure_string

    @property
    def number(self):
        """
        Gets the number of this ParameterTypes.

        :return: The number of this ParameterTypes.
        :rtype: NumberParam
        """
        return self._number

    @number.setter
    def number(self, number):
        """
        Sets the number of this ParameterTypes.

        :param number: The number of this ParameterTypes.
        :type: NumberParam
        """

        self._number = number

    @property
    def mime_attachment(self):
        """
        Gets the mime_attachment of this ParameterTypes.

        :return: The mime_attachment of this ParameterTypes.
        :rtype: MimeAttachment
        """
        return self._mime_attachment

    @mime_attachment.setter
    def mime_attachment(self, mime_attachment):
        """
        Sets the mime_attachment of this ParameterTypes.

        :param mime_attachment: The mime_attachment of this ParameterTypes.
        :type: MimeAttachment
        """

        self._mime_attachment = mime_attachment

    @property
    def properties(self):
        """
        Gets the properties of this ParameterTypes.

        :return: The properties of this ParameterTypes.
        :rtype: Properties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this ParameterTypes.

        :param properties: The properties of this ParameterTypes.
        :type: Properties
        """

        self._properties = properties

    @property
    def date(self):
        """
        Gets the date of this ParameterTypes.

        :return: The date of this ParameterTypes.
        :rtype: DateParam
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this ParameterTypes.

        :param date: The date of this ParameterTypes.
        :type: DateParam
        """

        self._date = date

    @property
    def boolean(self):
        """
        Gets the boolean of this ParameterTypes.

        :return: The boolean of this ParameterTypes.
        :rtype: BooleanParam
        """
        return self._boolean

    @boolean.setter
    def boolean(self, boolean):
        """
        Sets the boolean of this ParameterTypes.

        :param boolean: The boolean of this ParameterTypes.
        :type: BooleanParam
        """

        self._boolean = boolean

    @property
    def composite(self):
        """
        Gets the composite of this ParameterTypes.

        :return: The composite of this ParameterTypes.
        :rtype: CompositeType
        """
        return self._composite

    @composite.setter
    def composite(self, composite):
        """
        Sets the composite of this ParameterTypes.

        :param composite: The composite of this ParameterTypes.
        :type: CompositeType
        """

        self._composite = composite

    @property
    def regex(self):
        """
        Gets the regex of this ParameterTypes.

        :return: The regex of this ParameterTypes.
        :rtype: Regex
        """
        return self._regex

    @regex.setter
    def regex(self, regex):
        """
        Sets the regex of this ParameterTypes.

        :param regex: The regex of this ParameterTypes.
        :type: Regex
        """

        self._regex = regex

    @property
    def encrypted_string(self):
        """
        Gets the encrypted_string of this ParameterTypes.

        :return: The encrypted_string of this ParameterTypes.
        :rtype: EncryptedString
        """
        return self._encrypted_string

    @encrypted_string.setter
    def encrypted_string(self, encrypted_string):
        """
        Sets the encrypted_string of this ParameterTypes.

        :param encrypted_string: The encrypted_string of this ParameterTypes.
        :type: EncryptedString
        """

        self._encrypted_string = encrypted_string

    @property
    def key_value_pair(self):
        """
        Gets the key_value_pair of this ParameterTypes.

        :return: The key_value_pair of this ParameterTypes.
        :rtype: KeyValuePair
        """
        return self._key_value_pair

    @key_value_pair.setter
    def key_value_pair(self, key_value_pair):
        """
        Sets the key_value_pair of this ParameterTypes.

        :param key_value_pair: The key_value_pair of this ParameterTypes.
        :type: KeyValuePair
        """

        self._key_value_pair = key_value_pair

    @property
    def composite_value(self):
        """
        Gets the composite_value of this ParameterTypes.

        :return: The composite_value of this ParameterTypes.
        :rtype: CompositeValue
        """
        return self._composite_value

    @composite_value.setter
    def composite_value(self, composite_value):
        """
        Sets the composite_value of this ParameterTypes.

        :param composite_value: The composite_value of this ParameterTypes.
        :type: CompositeValue
        """

        self._composite_value = composite_value

    @property
    def array(self):
        """
        Gets the array of this ParameterTypes.

        :return: The array of this ParameterTypes.
        :rtype: ArrayParam
        """
        return self._array

    @array.setter
    def array(self, array):
        """
        Sets the array of this ParameterTypes.

        :param array: The array of this ParameterTypes.
        :type: ArrayParam
        """

        self._array = array

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ParameterTypes):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
