# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LdapUserAttributesType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'object_class': 'str',
        'object_identifier': 'str',
        'user_name': 'str',
        'email': 'str',
        'full_name': 'str',
        'given_name': 'str',
        'surname': 'str',
        'telephone': 'str',
        'group_membership_identifier': 'str',
        'group_back_link_identifier': 'str'
    }

    attribute_map = {
        'object_class': 'objectClass',
        'object_identifier': 'objectIdentifier',
        'user_name': 'userName',
        'email': 'email',
        'full_name': 'fullName',
        'given_name': 'givenName',
        'surname': 'surname',
        'telephone': 'telephone',
        'group_membership_identifier': 'groupMembershipIdentifier',
        'group_back_link_identifier': 'groupBackLinkIdentifier'
    }

    def __init__(self, object_class=None, object_identifier=None, user_name=None, email=None, full_name=None, given_name=None, surname=None, telephone=None, group_membership_identifier=None, group_back_link_identifier=None):
        """
        LdapUserAttributesType - a model defined in Swagger
        """

        self._object_class = None
        self._object_identifier = None
        self._user_name = None
        self._email = None
        self._full_name = None
        self._given_name = None
        self._surname = None
        self._telephone = None
        self._group_membership_identifier = None
        self._group_back_link_identifier = None

        if object_class is not None:
          self.object_class = object_class
        if object_identifier is not None:
          self.object_identifier = object_identifier
        if user_name is not None:
          self.user_name = user_name
        if email is not None:
          self.email = email
        if full_name is not None:
          self.full_name = full_name
        if given_name is not None:
          self.given_name = given_name
        if surname is not None:
          self.surname = surname
        if telephone is not None:
          self.telephone = telephone
        if group_membership_identifier is not None:
          self.group_membership_identifier = group_membership_identifier
        if group_back_link_identifier is not None:
          self.group_back_link_identifier = group_back_link_identifier

    @property
    def object_class(self):
        """
        Gets the object_class of this LdapUserAttributesType.

        :return: The object_class of this LdapUserAttributesType.
        :rtype: str
        """
        return self._object_class

    @object_class.setter
    def object_class(self, object_class):
        """
        Sets the object_class of this LdapUserAttributesType.

        :param object_class: The object_class of this LdapUserAttributesType.
        :type: str
        """

        self._object_class = object_class

    @property
    def object_identifier(self):
        """
        Gets the object_identifier of this LdapUserAttributesType.

        :return: The object_identifier of this LdapUserAttributesType.
        :rtype: str
        """
        return self._object_identifier

    @object_identifier.setter
    def object_identifier(self, object_identifier):
        """
        Sets the object_identifier of this LdapUserAttributesType.

        :param object_identifier: The object_identifier of this LdapUserAttributesType.
        :type: str
        """

        self._object_identifier = object_identifier

    @property
    def user_name(self):
        """
        Gets the user_name of this LdapUserAttributesType.

        :return: The user_name of this LdapUserAttributesType.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this LdapUserAttributesType.

        :param user_name: The user_name of this LdapUserAttributesType.
        :type: str
        """

        self._user_name = user_name

    @property
    def email(self):
        """
        Gets the email of this LdapUserAttributesType.

        :return: The email of this LdapUserAttributesType.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this LdapUserAttributesType.

        :param email: The email of this LdapUserAttributesType.
        :type: str
        """

        self._email = email

    @property
    def full_name(self):
        """
        Gets the full_name of this LdapUserAttributesType.

        :return: The full_name of this LdapUserAttributesType.
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """
        Sets the full_name of this LdapUserAttributesType.

        :param full_name: The full_name of this LdapUserAttributesType.
        :type: str
        """

        self._full_name = full_name

    @property
    def given_name(self):
        """
        Gets the given_name of this LdapUserAttributesType.

        :return: The given_name of this LdapUserAttributesType.
        :rtype: str
        """
        return self._given_name

    @given_name.setter
    def given_name(self, given_name):
        """
        Sets the given_name of this LdapUserAttributesType.

        :param given_name: The given_name of this LdapUserAttributesType.
        :type: str
        """

        self._given_name = given_name

    @property
    def surname(self):
        """
        Gets the surname of this LdapUserAttributesType.

        :return: The surname of this LdapUserAttributesType.
        :rtype: str
        """
        return self._surname

    @surname.setter
    def surname(self, surname):
        """
        Sets the surname of this LdapUserAttributesType.

        :param surname: The surname of this LdapUserAttributesType.
        :type: str
        """

        self._surname = surname

    @property
    def telephone(self):
        """
        Gets the telephone of this LdapUserAttributesType.

        :return: The telephone of this LdapUserAttributesType.
        :rtype: str
        """
        return self._telephone

    @telephone.setter
    def telephone(self, telephone):
        """
        Sets the telephone of this LdapUserAttributesType.

        :param telephone: The telephone of this LdapUserAttributesType.
        :type: str
        """

        self._telephone = telephone

    @property
    def group_membership_identifier(self):
        """
        Gets the group_membership_identifier of this LdapUserAttributesType.

        :return: The group_membership_identifier of this LdapUserAttributesType.
        :rtype: str
        """
        return self._group_membership_identifier

    @group_membership_identifier.setter
    def group_membership_identifier(self, group_membership_identifier):
        """
        Sets the group_membership_identifier of this LdapUserAttributesType.

        :param group_membership_identifier: The group_membership_identifier of this LdapUserAttributesType.
        :type: str
        """

        self._group_membership_identifier = group_membership_identifier

    @property
    def group_back_link_identifier(self):
        """
        Gets the group_back_link_identifier of this LdapUserAttributesType.

        :return: The group_back_link_identifier of this LdapUserAttributesType.
        :rtype: str
        """
        return self._group_back_link_identifier

    @group_back_link_identifier.setter
    def group_back_link_identifier(self, group_back_link_identifier):
        """
        Sets the group_back_link_identifier of this LdapUserAttributesType.

        :param group_back_link_identifier: The group_back_link_identifier of this LdapUserAttributesType.
        :type: str
        """

        self._group_back_link_identifier = group_back_link_identifier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LdapUserAttributesType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
