# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LdapSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host_name': 'str',
        'port': 'int',
        'is_ssl': 'bool',
        'is_ssl_accept_all': 'bool',
        'realm': 'str',
        'paged_search_disabled': 'bool',
        'page_size': 'int',
        'max_results': 'int',
        'max_user_groups': 'int',
        'search_base': 'str',
        'user_name': 'str',
        'password': 'str',
        'authentication_mechanism': 'str',
        'group_search_base': 'str',
        'is_group_search_base_enabled': 'bool',
        'connector_type': 'str',
        'user_attributes': 'LdapUserAttributesType',
        'group_attributes': 'LdapGroupAttributesType',
        'use_external_kerberos': 'bool'
    }

    attribute_map = {
        'host_name': 'hostName',
        'port': 'port',
        'is_ssl': 'isSsl',
        'is_ssl_accept_all': 'isSslAcceptAll',
        'realm': 'realm',
        'paged_search_disabled': 'pagedSearchDisabled',
        'page_size': 'pageSize',
        'max_results': 'maxResults',
        'max_user_groups': 'maxUserGroups',
        'search_base': 'searchBase',
        'user_name': 'userName',
        'password': 'password',
        'authentication_mechanism': 'authenticationMechanism',
        'group_search_base': 'groupSearchBase',
        'is_group_search_base_enabled': 'isGroupSearchBaseEnabled',
        'connector_type': 'connectorType',
        'user_attributes': 'userAttributes',
        'group_attributes': 'groupAttributes',
        'use_external_kerberos': 'useExternalKerberos'
    }

    def __init__(self, host_name=None, port=None, is_ssl=None, is_ssl_accept_all=None, realm=None, paged_search_disabled=None, page_size=None, max_results=None, max_user_groups=None, search_base=None, user_name=None, password=None, authentication_mechanism=None, group_search_base=None, is_group_search_base_enabled=None, connector_type=None, user_attributes=None, group_attributes=None, use_external_kerberos=None):
        """
        LdapSettings - a model defined in Swagger
        """

        self._host_name = None
        self._port = None
        self._is_ssl = None
        self._is_ssl_accept_all = None
        self._realm = None
        self._paged_search_disabled = None
        self._page_size = None
        self._max_results = None
        self._max_user_groups = None
        self._search_base = None
        self._user_name = None
        self._password = None
        self._authentication_mechanism = None
        self._group_search_base = None
        self._is_group_search_base_enabled = None
        self._connector_type = None
        self._user_attributes = None
        self._group_attributes = None
        self._use_external_kerberos = None

        if host_name is not None:
          self.host_name = host_name
        if port is not None:
          self.port = port
        if is_ssl is not None:
          self.is_ssl = is_ssl
        if is_ssl_accept_all is not None:
          self.is_ssl_accept_all = is_ssl_accept_all
        if realm is not None:
          self.realm = realm
        if paged_search_disabled is not None:
          self.paged_search_disabled = paged_search_disabled
        if page_size is not None:
          self.page_size = page_size
        if max_results is not None:
          self.max_results = max_results
        if max_user_groups is not None:
          self.max_user_groups = max_user_groups
        if search_base is not None:
          self.search_base = search_base
        if user_name is not None:
          self.user_name = user_name
        if password is not None:
          self.password = password
        if authentication_mechanism is not None:
          self.authentication_mechanism = authentication_mechanism
        if group_search_base is not None:
          self.group_search_base = group_search_base
        if is_group_search_base_enabled is not None:
          self.is_group_search_base_enabled = is_group_search_base_enabled
        if connector_type is not None:
          self.connector_type = connector_type
        if user_attributes is not None:
          self.user_attributes = user_attributes
        if group_attributes is not None:
          self.group_attributes = group_attributes
        if use_external_kerberos is not None:
          self.use_external_kerberos = use_external_kerberos

    @property
    def host_name(self):
        """
        Gets the host_name of this LdapSettings.

        :return: The host_name of this LdapSettings.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this LdapSettings.

        :param host_name: The host_name of this LdapSettings.
        :type: str
        """

        self._host_name = host_name

    @property
    def port(self):
        """
        Gets the port of this LdapSettings.

        :return: The port of this LdapSettings.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this LdapSettings.

        :param port: The port of this LdapSettings.
        :type: int
        """

        self._port = port

    @property
    def is_ssl(self):
        """
        Gets the is_ssl of this LdapSettings.

        :return: The is_ssl of this LdapSettings.
        :rtype: bool
        """
        return self._is_ssl

    @is_ssl.setter
    def is_ssl(self, is_ssl):
        """
        Sets the is_ssl of this LdapSettings.

        :param is_ssl: The is_ssl of this LdapSettings.
        :type: bool
        """

        self._is_ssl = is_ssl

    @property
    def is_ssl_accept_all(self):
        """
        Gets the is_ssl_accept_all of this LdapSettings.

        :return: The is_ssl_accept_all of this LdapSettings.
        :rtype: bool
        """
        return self._is_ssl_accept_all

    @is_ssl_accept_all.setter
    def is_ssl_accept_all(self, is_ssl_accept_all):
        """
        Sets the is_ssl_accept_all of this LdapSettings.

        :param is_ssl_accept_all: The is_ssl_accept_all of this LdapSettings.
        :type: bool
        """

        self._is_ssl_accept_all = is_ssl_accept_all

    @property
    def realm(self):
        """
        Gets the realm of this LdapSettings.

        :return: The realm of this LdapSettings.
        :rtype: str
        """
        return self._realm

    @realm.setter
    def realm(self, realm):
        """
        Sets the realm of this LdapSettings.

        :param realm: The realm of this LdapSettings.
        :type: str
        """

        self._realm = realm

    @property
    def paged_search_disabled(self):
        """
        Gets the paged_search_disabled of this LdapSettings.

        :return: The paged_search_disabled of this LdapSettings.
        :rtype: bool
        """
        return self._paged_search_disabled

    @paged_search_disabled.setter
    def paged_search_disabled(self, paged_search_disabled):
        """
        Sets the paged_search_disabled of this LdapSettings.

        :param paged_search_disabled: The paged_search_disabled of this LdapSettings.
        :type: bool
        """

        self._paged_search_disabled = paged_search_disabled

    @property
    def page_size(self):
        """
        Gets the page_size of this LdapSettings.

        :return: The page_size of this LdapSettings.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size):
        """
        Sets the page_size of this LdapSettings.

        :param page_size: The page_size of this LdapSettings.
        :type: int
        """

        self._page_size = page_size

    @property
    def max_results(self):
        """
        Gets the max_results of this LdapSettings.

        :return: The max_results of this LdapSettings.
        :rtype: int
        """
        return self._max_results

    @max_results.setter
    def max_results(self, max_results):
        """
        Sets the max_results of this LdapSettings.

        :param max_results: The max_results of this LdapSettings.
        :type: int
        """

        self._max_results = max_results

    @property
    def max_user_groups(self):
        """
        Gets the max_user_groups of this LdapSettings.

        :return: The max_user_groups of this LdapSettings.
        :rtype: int
        """
        return self._max_user_groups

    @max_user_groups.setter
    def max_user_groups(self, max_user_groups):
        """
        Sets the max_user_groups of this LdapSettings.

        :param max_user_groups: The max_user_groups of this LdapSettings.
        :type: int
        """

        self._max_user_groups = max_user_groups

    @property
    def search_base(self):
        """
        Gets the search_base of this LdapSettings.

        :return: The search_base of this LdapSettings.
        :rtype: str
        """
        return self._search_base

    @search_base.setter
    def search_base(self, search_base):
        """
        Sets the search_base of this LdapSettings.

        :param search_base: The search_base of this LdapSettings.
        :type: str
        """

        self._search_base = search_base

    @property
    def user_name(self):
        """
        Gets the user_name of this LdapSettings.

        :return: The user_name of this LdapSettings.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this LdapSettings.

        :param user_name: The user_name of this LdapSettings.
        :type: str
        """

        self._user_name = user_name

    @property
    def password(self):
        """
        Gets the password of this LdapSettings.

        :return: The password of this LdapSettings.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this LdapSettings.

        :param password: The password of this LdapSettings.
        :type: str
        """

        self._password = password

    @property
    def authentication_mechanism(self):
        """
        Gets the authentication_mechanism of this LdapSettings.

        :return: The authentication_mechanism of this LdapSettings.
        :rtype: str
        """
        return self._authentication_mechanism

    @authentication_mechanism.setter
    def authentication_mechanism(self, authentication_mechanism):
        """
        Sets the authentication_mechanism of this LdapSettings.

        :param authentication_mechanism: The authentication_mechanism of this LdapSettings.
        :type: str
        """
        allowed_values = ["SIMPLE", "KERBEROS", "M5DIGEST", "NTLM"]
        if authentication_mechanism not in allowed_values:
            raise ValueError(
                "Invalid value for `authentication_mechanism` ({0}), must be one of {1}"
                .format(authentication_mechanism, allowed_values)
            )

        self._authentication_mechanism = authentication_mechanism

    @property
    def group_search_base(self):
        """
        Gets the group_search_base of this LdapSettings.

        :return: The group_search_base of this LdapSettings.
        :rtype: str
        """
        return self._group_search_base

    @group_search_base.setter
    def group_search_base(self, group_search_base):
        """
        Sets the group_search_base of this LdapSettings.

        :param group_search_base: The group_search_base of this LdapSettings.
        :type: str
        """

        self._group_search_base = group_search_base

    @property
    def is_group_search_base_enabled(self):
        """
        Gets the is_group_search_base_enabled of this LdapSettings.

        :return: The is_group_search_base_enabled of this LdapSettings.
        :rtype: bool
        """
        return self._is_group_search_base_enabled

    @is_group_search_base_enabled.setter
    def is_group_search_base_enabled(self, is_group_search_base_enabled):
        """
        Sets the is_group_search_base_enabled of this LdapSettings.

        :param is_group_search_base_enabled: The is_group_search_base_enabled of this LdapSettings.
        :type: bool
        """

        self._is_group_search_base_enabled = is_group_search_base_enabled

    @property
    def connector_type(self):
        """
        Gets the connector_type of this LdapSettings.

        :return: The connector_type of this LdapSettings.
        :rtype: str
        """
        return self._connector_type

    @connector_type.setter
    def connector_type(self, connector_type):
        """
        Sets the connector_type of this LdapSettings.

        :param connector_type: The connector_type of this LdapSettings.
        :type: str
        """
        allowed_values = ["ACTIVE_DIRECTORY", "OPEN_LDAP"]
        if connector_type not in allowed_values:
            raise ValueError(
                "Invalid value for `connector_type` ({0}), must be one of {1}"
                .format(connector_type, allowed_values)
            )

        self._connector_type = connector_type

    @property
    def user_attributes(self):
        """
        Gets the user_attributes of this LdapSettings.

        :return: The user_attributes of this LdapSettings.
        :rtype: LdapUserAttributesType
        """
        return self._user_attributes

    @user_attributes.setter
    def user_attributes(self, user_attributes):
        """
        Sets the user_attributes of this LdapSettings.

        :param user_attributes: The user_attributes of this LdapSettings.
        :type: LdapUserAttributesType
        """

        self._user_attributes = user_attributes

    @property
    def group_attributes(self):
        """
        Gets the group_attributes of this LdapSettings.

        :return: The group_attributes of this LdapSettings.
        :rtype: LdapGroupAttributesType
        """
        return self._group_attributes

    @group_attributes.setter
    def group_attributes(self, group_attributes):
        """
        Sets the group_attributes of this LdapSettings.

        :param group_attributes: The group_attributes of this LdapSettings.
        :type: LdapGroupAttributesType
        """

        self._group_attributes = group_attributes

    @property
    def use_external_kerberos(self):
        """
        Gets the use_external_kerberos of this LdapSettings.

        :return: The use_external_kerberos of this LdapSettings.
        :rtype: bool
        """
        return self._use_external_kerberos

    @use_external_kerberos.setter
    def use_external_kerberos(self, use_external_kerberos):
        """
        Sets the use_external_kerberos of this LdapSettings.

        :param use_external_kerberos: The use_external_kerberos of this LdapSettings.
        :type: bool
        """

        self._use_external_kerberos = use_external_kerberos

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LdapSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
