# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LdapGroupAttributesType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'object_class': 'str',
        'object_identifier': 'str',
        'group_name': 'str',
        'membership': 'str',
        'membership_identifier': 'str',
        'back_link_identifier': 'str'
    }

    attribute_map = {
        'object_class': 'objectClass',
        'object_identifier': 'objectIdentifier',
        'group_name': 'groupName',
        'membership': 'membership',
        'membership_identifier': 'membershipIdentifier',
        'back_link_identifier': 'backLinkIdentifier'
    }

    def __init__(self, object_class=None, object_identifier=None, group_name=None, membership=None, membership_identifier=None, back_link_identifier=None):
        """
        LdapGroupAttributesType - a model defined in Swagger
        """

        self._object_class = None
        self._object_identifier = None
        self._group_name = None
        self._membership = None
        self._membership_identifier = None
        self._back_link_identifier = None

        if object_class is not None:
          self.object_class = object_class
        if object_identifier is not None:
          self.object_identifier = object_identifier
        if group_name is not None:
          self.group_name = group_name
        if membership is not None:
          self.membership = membership
        if membership_identifier is not None:
          self.membership_identifier = membership_identifier
        if back_link_identifier is not None:
          self.back_link_identifier = back_link_identifier

    @property
    def object_class(self):
        """
        Gets the object_class of this LdapGroupAttributesType.

        :return: The object_class of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._object_class

    @object_class.setter
    def object_class(self, object_class):
        """
        Sets the object_class of this LdapGroupAttributesType.

        :param object_class: The object_class of this LdapGroupAttributesType.
        :type: str
        """

        self._object_class = object_class

    @property
    def object_identifier(self):
        """
        Gets the object_identifier of this LdapGroupAttributesType.

        :return: The object_identifier of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._object_identifier

    @object_identifier.setter
    def object_identifier(self, object_identifier):
        """
        Sets the object_identifier of this LdapGroupAttributesType.

        :param object_identifier: The object_identifier of this LdapGroupAttributesType.
        :type: str
        """

        self._object_identifier = object_identifier

    @property
    def group_name(self):
        """
        Gets the group_name of this LdapGroupAttributesType.

        :return: The group_name of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this LdapGroupAttributesType.

        :param group_name: The group_name of this LdapGroupAttributesType.
        :type: str
        """

        self._group_name = group_name

    @property
    def membership(self):
        """
        Gets the membership of this LdapGroupAttributesType.

        :return: The membership of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._membership

    @membership.setter
    def membership(self, membership):
        """
        Sets the membership of this LdapGroupAttributesType.

        :param membership: The membership of this LdapGroupAttributesType.
        :type: str
        """

        self._membership = membership

    @property
    def membership_identifier(self):
        """
        Gets the membership_identifier of this LdapGroupAttributesType.

        :return: The membership_identifier of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._membership_identifier

    @membership_identifier.setter
    def membership_identifier(self, membership_identifier):
        """
        Sets the membership_identifier of this LdapGroupAttributesType.

        :param membership_identifier: The membership_identifier of this LdapGroupAttributesType.
        :type: str
        """

        self._membership_identifier = membership_identifier

    @property
    def back_link_identifier(self):
        """
        Gets the back_link_identifier of this LdapGroupAttributesType.

        :return: The back_link_identifier of this LdapGroupAttributesType.
        :rtype: str
        """
        return self._back_link_identifier

    @back_link_identifier.setter
    def back_link_identifier(self, back_link_identifier):
        """
        Sets the back_link_identifier of this LdapGroupAttributesType.

        :param back_link_identifier: The back_link_identifier of this LdapGroupAttributesType.
        :type: str
        """

        self._back_link_identifier = back_link_identifier

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LdapGroupAttributesType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
