# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ExternalNetwork(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'subnets': 'Subnets',
        'status': 'NetworkingObjectStatusType',
        'network_backings': 'ExternalNetworkBackings',
        'total_ip_count': 'int',
        'used_ip_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'subnets': 'subnets',
        'status': 'status',
        'network_backings': 'networkBackings',
        'total_ip_count': 'totalIpCount',
        'used_ip_count': 'usedIpCount'
    }

    def __init__(self, id=None, name=None, description=None, subnets=None, status=None, network_backings=None, total_ip_count=None, used_ip_count=None):
        """
        ExternalNetwork - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._subnets = None
        self._status = None
        self._network_backings = None
        self._total_ip_count = None
        self._used_ip_count = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if subnets is not None:
          self.subnets = subnets
        if status is not None:
          self.status = status
        if network_backings is not None:
          self.network_backings = network_backings
        if total_ip_count is not None:
          self.total_ip_count = total_ip_count
        if used_ip_count is not None:
          self.used_ip_count = used_ip_count

    @property
    def id(self):
        """
        Gets the id of this ExternalNetwork.
        The unique ID for the network. This field is read-only.

        :return: The id of this ExternalNetwork.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExternalNetwork.
        The unique ID for the network. This field is read-only.

        :param id: The id of this ExternalNetwork.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ExternalNetwork.
        The name of the network.

        :return: The name of this ExternalNetwork.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ExternalNetwork.
        The name of the network.

        :param name: The name of this ExternalNetwork.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ExternalNetwork.
        The description of the network.

        :return: The description of this ExternalNetwork.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ExternalNetwork.
        The description of the network.

        :param description: The description of this ExternalNetwork.
        :type: str
        """

        self._description = description

    @property
    def subnets(self):
        """
        Gets the subnets of this ExternalNetwork.
        List of subnets configured for the network.

        :return: The subnets of this ExternalNetwork.
        :rtype: Subnets
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this ExternalNetwork.
        List of subnets configured for the network.

        :param subnets: The subnets of this ExternalNetwork.
        :type: Subnets
        """

        self._subnets = subnets

    @property
    def status(self):
        """
        Gets the status of this ExternalNetwork.
        Represents current status of the networking object. 

        :return: The status of this ExternalNetwork.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ExternalNetwork.
        Represents current status of the networking object. 

        :param status: The status of this ExternalNetwork.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def network_backings(self):
        """
        Gets the network_backings of this ExternalNetwork.
        Backings for this external network. Describes if this external network is backed by port groups, vCenter standard switch or an NSX-T Tier-0 router. 

        :return: The network_backings of this ExternalNetwork.
        :rtype: ExternalNetworkBackings
        """
        return self._network_backings

    @network_backings.setter
    def network_backings(self, network_backings):
        """
        Sets the network_backings of this ExternalNetwork.
        Backings for this external network. Describes if this external network is backed by port groups, vCenter standard switch or an NSX-T Tier-0 router. 

        :param network_backings: The network_backings of this ExternalNetwork.
        :type: ExternalNetworkBackings
        """

        self._network_backings = network_backings

    @property
    def total_ip_count(self):
        """
        Gets the total_ip_count of this ExternalNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :return: The total_ip_count of this ExternalNetwork.
        :rtype: int
        """
        return self._total_ip_count

    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        """
        Sets the total_ip_count of this ExternalNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :param total_ip_count: The total_ip_count of this ExternalNetwork.
        :type: int
        """

        self._total_ip_count = total_ip_count

    @property
    def used_ip_count(self):
        """
        Gets the used_ip_count of this ExternalNetwork.
        The number of IP address used from the static ip pools.

        :return: The used_ip_count of this ExternalNetwork.
        :rtype: int
        """
        return self._used_ip_count

    @used_ip_count.setter
    def used_ip_count(self, used_ip_count):
        """
        Sets the used_ip_count of this ExternalNetwork.
        The number of IP address used from the static ip pools.

        :param used_ip_count: The used_ip_count of this ExternalNetwork.
        :type: int
        """

        self._used_ip_count = used_ip_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ExternalNetwork):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
