# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeIpSecVpnTunnel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'enabled': 'bool',
        'local_endpoint': 'LocalEndpoint',
        'remote_endpoint': 'RemoteEndpoint',
        'pre_shared_key': 'str',
        'connector_initiation_mode': 'ConnectorInitiationMode',
        'security_type': 'TunnelSecurityType',
        'logging': 'bool',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'enabled': 'enabled',
        'local_endpoint': 'localEndpoint',
        'remote_endpoint': 'remoteEndpoint',
        'pre_shared_key': 'preSharedKey',
        'connector_initiation_mode': 'connectorInitiationMode',
        'security_type': 'securityType',
        'logging': 'logging',
        'version': 'version'
    }

    def __init__(self, id=None, name=None, description=None, enabled=True, local_endpoint=None, remote_endpoint=None, pre_shared_key=None, connector_initiation_mode=None, security_type=None, logging=False, version=None):
        """
        EdgeIpSecVpnTunnel - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._enabled = None
        self._local_endpoint = None
        self._remote_endpoint = None
        self._pre_shared_key = None
        self._connector_initiation_mode = None
        self._security_type = None
        self._logging = None
        self._version = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        if enabled is not None:
          self.enabled = enabled
        self.local_endpoint = local_endpoint
        self.remote_endpoint = remote_endpoint
        self.pre_shared_key = pre_shared_key
        if connector_initiation_mode is not None:
          self.connector_initiation_mode = connector_initiation_mode
        if security_type is not None:
          self.security_type = security_type
        if logging is not None:
          self.logging = logging
        if version is not None:
          self.version = version

    @property
    def id(self):
        """
        Gets the id of this EdgeIpSecVpnTunnel.
        The unique id of this IPSec VPN tunnel. On updates, the id is required for the tunnel, while for create a new id will be generated. 

        :return: The id of this EdgeIpSecVpnTunnel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeIpSecVpnTunnel.
        The unique id of this IPSec VPN tunnel. On updates, the id is required for the tunnel, while for create a new id will be generated. 

        :param id: The id of this EdgeIpSecVpnTunnel.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeIpSecVpnTunnel.
        Name for the tunnel.

        :return: The name of this EdgeIpSecVpnTunnel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeIpSecVpnTunnel.
        Name for the tunnel.

        :param name: The name of this EdgeIpSecVpnTunnel.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this EdgeIpSecVpnTunnel.

        :return: The description of this EdgeIpSecVpnTunnel.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeIpSecVpnTunnel.

        :param description: The description of this EdgeIpSecVpnTunnel.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeIpSecVpnTunnel.
        Described whether the tunnel is enabled or not. The default is true.

        :return: The enabled of this EdgeIpSecVpnTunnel.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeIpSecVpnTunnel.
        Described whether the tunnel is enabled or not. The default is true.

        :param enabled: The enabled of this EdgeIpSecVpnTunnel.
        :type: bool
        """

        self._enabled = enabled

    @property
    def local_endpoint(self):
        """
        Gets the local_endpoint of this EdgeIpSecVpnTunnel.
        The Local Endpoint which corresponds to the Edge Gateway the tunnel is being configured on. Local Endpoint requires an IP. That IP must be suballocated to the edge gateway. 

        :return: The local_endpoint of this EdgeIpSecVpnTunnel.
        :rtype: LocalEndpoint
        """
        return self._local_endpoint

    @local_endpoint.setter
    def local_endpoint(self, local_endpoint):
        """
        Sets the local_endpoint of this EdgeIpSecVpnTunnel.
        The Local Endpoint which corresponds to the Edge Gateway the tunnel is being configured on. Local Endpoint requires an IP. That IP must be suballocated to the edge gateway. 

        :param local_endpoint: The local_endpoint of this EdgeIpSecVpnTunnel.
        :type: LocalEndpoint
        """
        if local_endpoint is None:
            raise ValueError("Invalid value for `local_endpoint`, must not be `None`")

        self._local_endpoint = local_endpoint

    @property
    def remote_endpoint(self):
        """
        Gets the remote_endpoint of this EdgeIpSecVpnTunnel.
        The Remote Endpoints correspoinds to the device on the remote site terminating the VPN tunnel. 

        :return: The remote_endpoint of this EdgeIpSecVpnTunnel.
        :rtype: RemoteEndpoint
        """
        return self._remote_endpoint

    @remote_endpoint.setter
    def remote_endpoint(self, remote_endpoint):
        """
        Sets the remote_endpoint of this EdgeIpSecVpnTunnel.
        The Remote Endpoints correspoinds to the device on the remote site terminating the VPN tunnel. 

        :param remote_endpoint: The remote_endpoint of this EdgeIpSecVpnTunnel.
        :type: RemoteEndpoint
        """
        if remote_endpoint is None:
            raise ValueError("Invalid value for `remote_endpoint`, must not be `None`")

        self._remote_endpoint = remote_endpoint

    @property
    def pre_shared_key(self):
        """
        Gets the pre_shared_key of this EdgeIpSecVpnTunnel.
        This is the Pre-shared key used for authentication.

        :return: The pre_shared_key of this EdgeIpSecVpnTunnel.
        :rtype: str
        """
        return self._pre_shared_key

    @pre_shared_key.setter
    def pre_shared_key(self, pre_shared_key):
        """
        Sets the pre_shared_key of this EdgeIpSecVpnTunnel.
        This is the Pre-shared key used for authentication.

        :param pre_shared_key: The pre_shared_key of this EdgeIpSecVpnTunnel.
        :type: str
        """
        if pre_shared_key is None:
            raise ValueError("Invalid value for `pre_shared_key`, must not be `None`")

        self._pre_shared_key = pre_shared_key

    @property
    def connector_initiation_mode(self):
        """
        Gets the connector_initiation_mode of this EdgeIpSecVpnTunnel.
        This is the mode used by the local endpoint to establish an IKE Connection with the remote site. The default is INITIATOR.

        :return: The connector_initiation_mode of this EdgeIpSecVpnTunnel.
        :rtype: ConnectorInitiationMode
        """
        return self._connector_initiation_mode

    @connector_initiation_mode.setter
    def connector_initiation_mode(self, connector_initiation_mode):
        """
        Sets the connector_initiation_mode of this EdgeIpSecVpnTunnel.
        This is the mode used by the local endpoint to establish an IKE Connection with the remote site. The default is INITIATOR.

        :param connector_initiation_mode: The connector_initiation_mode of this EdgeIpSecVpnTunnel.
        :type: ConnectorInitiationMode
        """

        self._connector_initiation_mode = connector_initiation_mode

    @property
    def security_type(self):
        """
        Gets the security_type of this EdgeIpSecVpnTunnel.
        This is the security type used for the IPSec Tunnel. If nothing is specified, this will be set to default in which the default settings in NSX will be used. For custom settings, one should use the connectionProperties endpoint to specify custom settings. The security type will then appropriately reflect itself as CUSTOM. 

        :return: The security_type of this EdgeIpSecVpnTunnel.
        :rtype: TunnelSecurityType
        """
        return self._security_type

    @security_type.setter
    def security_type(self, security_type):
        """
        Sets the security_type of this EdgeIpSecVpnTunnel.
        This is the security type used for the IPSec Tunnel. If nothing is specified, this will be set to default in which the default settings in NSX will be used. For custom settings, one should use the connectionProperties endpoint to specify custom settings. The security type will then appropriately reflect itself as CUSTOM. 

        :param security_type: The security_type of this EdgeIpSecVpnTunnel.
        :type: TunnelSecurityType
        """

        self._security_type = security_type

    @property
    def logging(self):
        """
        Gets the logging of this EdgeIpSecVpnTunnel.
        Whether logging for the tunnel is enabled or not. The default is false.

        :return: The logging of this EdgeIpSecVpnTunnel.
        :rtype: bool
        """
        return self._logging

    @logging.setter
    def logging(self, logging):
        """
        Sets the logging of this EdgeIpSecVpnTunnel.
        Whether logging for the tunnel is enabled or not. The default is false.

        :param logging: The logging of this EdgeIpSecVpnTunnel.
        :type: bool
        """

        self._logging = logging

    @property
    def version(self):
        """
        Gets the version of this EdgeIpSecVpnTunnel.

        :return: The version of this EdgeIpSecVpnTunnel.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this EdgeIpSecVpnTunnel.

        :param version: The version of this EdgeIpSecVpnTunnel.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeIpSecVpnTunnel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
