# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeDnsConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'listener_ip': 'str',
        'default_forwarder_zone': 'NsxtDnsForwarderZoneConfig',
        'conditional_forwarder_zones': 'list[NsxtDnsForwarderZoneConfig]',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'enabled': 'enabled',
        'listener_ip': 'listenerIp',
        'default_forwarder_zone': 'defaultForwarderZone',
        'conditional_forwarder_zones': 'conditionalForwarderZones',
        'version': 'version'
    }

    def __init__(self, enabled=False, listener_ip=None, default_forwarder_zone=None, conditional_forwarder_zones=None, version=None):
        """
        EdgeDnsConfig - a model defined in Swagger
        """

        self._enabled = None
        self._listener_ip = None
        self._default_forwarder_zone = None
        self._conditional_forwarder_zones = None
        self._version = None

        if enabled is not None:
          self.enabled = enabled
        if listener_ip is not None:
          self.listener_ip = listener_ip
        if default_forwarder_zone is not None:
          self.default_forwarder_zone = default_forwarder_zone
        if conditional_forwarder_zones is not None:
          self.conditional_forwarder_zones = conditional_forwarder_zones
        if version is not None:
          self.version = version

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeDnsConfig.
        True means that the forwarder is enabled. False means it's disabled.

        :return: The enabled of this EdgeDnsConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeDnsConfig.
        True means that the forwarder is enabled. False means it's disabled.

        :param enabled: The enabled of this EdgeDnsConfig.
        :type: bool
        """

        self._enabled = enabled

    @property
    def listener_ip(self):
        """
        Gets the listener_ip of this EdgeDnsConfig.
        The IP on which the DNS forwarder listens.

        :return: The listener_ip of this EdgeDnsConfig.
        :rtype: str
        """
        return self._listener_ip

    @listener_ip.setter
    def listener_ip(self, listener_ip):
        """
        Sets the listener_ip of this EdgeDnsConfig.
        The IP on which the DNS forwarder listens.

        :param listener_ip: The listener_ip of this EdgeDnsConfig.
        :type: str
        """

        self._listener_ip = listener_ip

    @property
    def default_forwarder_zone(self):
        """
        Gets the default_forwarder_zone of this EdgeDnsConfig.
        The default forwarder zone to use if there's no matching domain in the conditional forwarder zone.

        :return: The default_forwarder_zone of this EdgeDnsConfig.
        :rtype: NsxtDnsForwarderZoneConfig
        """
        return self._default_forwarder_zone

    @default_forwarder_zone.setter
    def default_forwarder_zone(self, default_forwarder_zone):
        """
        Sets the default_forwarder_zone of this EdgeDnsConfig.
        The default forwarder zone to use if there's no matching domain in the conditional forwarder zone.

        :param default_forwarder_zone: The default_forwarder_zone of this EdgeDnsConfig.
        :type: NsxtDnsForwarderZoneConfig
        """

        self._default_forwarder_zone = default_forwarder_zone

    @property
    def conditional_forwarder_zones(self):
        """
        Gets the conditional_forwarder_zones of this EdgeDnsConfig.
        The list of forwarder zones with its matching DNS domains.

        :return: The conditional_forwarder_zones of this EdgeDnsConfig.
        :rtype: list[NsxtDnsForwarderZoneConfig]
        """
        return self._conditional_forwarder_zones

    @conditional_forwarder_zones.setter
    def conditional_forwarder_zones(self, conditional_forwarder_zones):
        """
        Sets the conditional_forwarder_zones of this EdgeDnsConfig.
        The list of forwarder zones with its matching DNS domains.

        :param conditional_forwarder_zones: The conditional_forwarder_zones of this EdgeDnsConfig.
        :type: list[NsxtDnsForwarderZoneConfig]
        """

        self._conditional_forwarder_zones = conditional_forwarder_zones

    @property
    def version(self):
        """
        Gets the version of this EdgeDnsConfig.

        :return: The version of this EdgeDnsConfig.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this EdgeDnsConfig.

        :param version: The version of this EdgeDnsConfig.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeDnsConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
