# coding: utf-8

"""
    vCloud Director OpenAPI

    vCloud Director OpenAPI is a new vCloud Director API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy vCloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy vCD operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following vCD error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>vCloud OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom vCloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy vCloud APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       vCloud APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       vCloud APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 33.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApplicationPortProfile(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_ref': 'EntityReference',
        'context_entity_id': 'str',
        'network_provider_scope': 'str',
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'scope': 'ApplicationPortProfileScopeType',
        'application_ports': 'list[ApplicationPortList]',
        'usable_for_nat': 'bool'
    }

    attribute_map = {
        'org_ref': 'orgRef',
        'context_entity_id': 'contextEntityId',
        'network_provider_scope': 'networkProviderScope',
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'scope': 'scope',
        'application_ports': 'applicationPorts',
        'usable_for_nat': 'usableForNAT'
    }

    def __init__(self, org_ref=None, context_entity_id=None, network_provider_scope=None, status=None, id=None, name=None, description=None, scope=None, application_ports=None, usable_for_nat=None):
        """
        ApplicationPortProfile - a model defined in Swagger
        """

        self._org_ref = None
        self._context_entity_id = None
        self._network_provider_scope = None
        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._scope = None
        self._application_ports = None
        self._usable_for_nat = None

        if org_ref is not None:
          self.org_ref = org_ref
        if context_entity_id is not None:
          self.context_entity_id = context_entity_id
        if network_provider_scope is not None:
          self.network_provider_scope = network_provider_scope
        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if scope is not None:
          self.scope = scope
        if application_ports is not None:
          self.application_ports = application_ports
        if usable_for_nat is not None:
          self.usable_for_nat = usable_for_nat

    @property
    def org_ref(self):
        """
        Gets the org_ref of this ApplicationPortProfile.
        The organization that this object belongs to. This property is required during creation and cannot be updated. 

        :return: The org_ref of this ApplicationPortProfile.
        :rtype: EntityReference
        """
        return self._org_ref

    @org_ref.setter
    def org_ref(self, org_ref):
        """
        Sets the org_ref of this ApplicationPortProfile.
        The organization that this object belongs to. This property is required during creation and cannot be updated. 

        :param org_ref: The org_ref of this ApplicationPortProfile.
        :type: EntityReference
        """

        self._org_ref = org_ref

    @property
    def context_entity_id(self):
        """
        Gets the context_entity_id of this ApplicationPortProfile.
        The context under which this object is created. The context can the id of either the organization vDC or the network provider. This field is required on object creation and is unset on object reads. This same context ID can be used in the context filter field when querying for the list of objects. 

        :return: The context_entity_id of this ApplicationPortProfile.
        :rtype: str
        """
        return self._context_entity_id

    @context_entity_id.setter
    def context_entity_id(self, context_entity_id):
        """
        Sets the context_entity_id of this ApplicationPortProfile.
        The context under which this object is created. The context can the id of either the organization vDC or the network provider. This field is required on object creation and is unset on object reads. This same context ID can be used in the context filter field when querying for the list of objects. 

        :param context_entity_id: The context_entity_id of this ApplicationPortProfile.
        :type: str
        """

        self._context_entity_id = context_entity_id

    @property
    def network_provider_scope(self):
        """
        Gets the network_provider_scope of this ApplicationPortProfile.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :return: The network_provider_scope of this ApplicationPortProfile.
        :rtype: str
        """
        return self._network_provider_scope

    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        """
        Sets the network_provider_scope of this ApplicationPortProfile.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :param network_provider_scope: The network_provider_scope of this ApplicationPortProfile.
        :type: str
        """

        self._network_provider_scope = network_provider_scope

    @property
    def status(self):
        """
        Gets the status of this ApplicationPortProfile.
        Represents current status of the networking object. 

        :return: The status of this ApplicationPortProfile.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ApplicationPortProfile.
        Represents current status of the networking object. 

        :param status: The status of this ApplicationPortProfile.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this ApplicationPortProfile.
        The id of the Application Port Profile in URN format.

        :return: The id of this ApplicationPortProfile.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ApplicationPortProfile.
        The id of the Application Port Profile in URN format.

        :param id: The id of this ApplicationPortProfile.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ApplicationPortProfile.
        The name of the Application Port Profile.

        :return: The name of this ApplicationPortProfile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApplicationPortProfile.
        The name of the Application Port Profile.

        :param name: The name of this ApplicationPortProfile.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ApplicationPortProfile.

        :return: The description of this ApplicationPortProfile.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApplicationPortProfile.

        :param description: The description of this ApplicationPortProfile.
        :type: str
        """

        self._description = description

    @property
    def scope(self):
        """
        Gets the scope of this ApplicationPortProfile.
        The scope of the application port profile definition.

        :return: The scope of this ApplicationPortProfile.
        :rtype: ApplicationPortProfileScopeType
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this ApplicationPortProfile.
        The scope of the application port profile definition.

        :param scope: The scope of this ApplicationPortProfile.
        :type: ApplicationPortProfileScopeType
        """

        self._scope = scope

    @property
    def application_ports(self):
        """
        Gets the application_ports of this ApplicationPortProfile.
        A list of protocol and ports supported by this application port profile.

        :return: The application_ports of this ApplicationPortProfile.
        :rtype: list[ApplicationPortList]
        """
        return self._application_ports

    @application_ports.setter
    def application_ports(self, application_ports):
        """
        Sets the application_ports of this ApplicationPortProfile.
        A list of protocol and ports supported by this application port profile.

        :param application_ports: The application_ports of this ApplicationPortProfile.
        :type: list[ApplicationPortList]
        """

        self._application_ports = application_ports

    @property
    def usable_for_nat(self):
        """
        Gets the usable_for_nat of this ApplicationPortProfile.
        True means that the port profile can be used for NAT configuration.  A port profile can be used for NAT if there is only 1 application port with at most 1 destination port. 

        :return: The usable_for_nat of this ApplicationPortProfile.
        :rtype: bool
        """
        return self._usable_for_nat

    @usable_for_nat.setter
    def usable_for_nat(self, usable_for_nat):
        """
        Sets the usable_for_nat of this ApplicationPortProfile.
        True means that the port profile can be used for NAT configuration.  A port profile can be used for NAT if there is only 1 application port with at most 1 destination port. 

        :param usable_for_nat: The usable_for_nat of this ApplicationPortProfile.
        :type: bool
        """

        self._usable_for_nat = usable_for_nat

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApplicationPortProfile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
