"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..schema.ovf.section_type import SectionType


class VmSpecSectionType(SectionType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'os_type': 'str',
        'num_cpus': 'int',
        'num_cores_per_socket': 'int',
        'cpu_resource_mhz': 'ComputeResourceType',
        'memory_resource_mb': 'ComputeResourceType',
        'media_section': 'MediaSectionType',
        'disk_section': 'DiskSectionType',
        'hardware_version': 'HardwareVersionType',
        'vm_tools_version': 'str',
        'tools_guest_os_id': 'str',
        'virtual_cpu_type': 'VirtualCpuTypeType',
        'time_sync_with_host': 'bool',
        'modified': 'bool'
    }

    attribute_map = {
        'os_type': 'osType',
        'num_cpus': 'numCpus',
        'num_cores_per_socket': 'numCoresPerSocket',
        'cpu_resource_mhz': 'cpuResourceMhz',
        'memory_resource_mb': 'memoryResourceMb',
        'media_section': 'mediaSection',
        'disk_section': 'diskSection',
        'hardware_version': 'hardwareVersion',
        'vm_tools_version': 'vmToolsVersion',
        'tools_guest_os_id': 'toolsGuestOsId',
        'virtual_cpu_type': 'virtualCpuType',
        'time_sync_with_host': 'timeSyncWithHost',
        'modified': 'modified'
    }

    def __init__(self, os_type=None,num_cpus=None,num_cores_per_socket=None,cpu_resource_mhz=None,memory_resource_mb=None,media_section=None,disk_section=None,hardware_version=None,vm_tools_version=None,tools_guest_os_id=None,virtual_cpu_type=None,time_sync_with_host=None,modified=None):
        self._os_type = None
        self._num_cpus = None
        self._num_cores_per_socket = None
        self._cpu_resource_mhz = None
        self._memory_resource_mb = None
        self._media_section = None
        self._disk_section = None
        self._hardware_version = None
        self._vm_tools_version = None
        self._tools_guest_os_id = None
        self._virtual_cpu_type = None
        self._time_sync_with_host = None
        self._modified = None

        if os_type is not None:
            self.os_type = os_type
        if num_cpus is not None:
            self.num_cpus = num_cpus
        if num_cores_per_socket is not None:
            self.num_cores_per_socket = num_cores_per_socket
        if cpu_resource_mhz is not None:
            self.cpu_resource_mhz = cpu_resource_mhz
        if memory_resource_mb is not None:
            self.memory_resource_mb = memory_resource_mb
        if media_section is not None:
            self.media_section = media_section
        if disk_section is not None:
            self.disk_section = disk_section
        if hardware_version is not None:
            self.hardware_version = hardware_version
        if vm_tools_version is not None:
            self.vm_tools_version = vm_tools_version
        if tools_guest_os_id is not None:
            self.tools_guest_os_id = tools_guest_os_id
        if virtual_cpu_type is not None:
            self.virtual_cpu_type = virtual_cpu_type
        if time_sync_with_host is not None:
            self.time_sync_with_host = time_sync_with_host
        if modified is not None:
            self.modified = modified

    @property
    def os_type(self):
        return self._os_type
    
    @os_type.setter
    def os_type(self, os_type):
        self._os_type = os_type

    @property
    def num_cpus(self):
        return self._num_cpus
    
    @num_cpus.setter
    def num_cpus(self, num_cpus):
        self._num_cpus = num_cpus

    @property
    def num_cores_per_socket(self):
        return self._num_cores_per_socket
    
    @num_cores_per_socket.setter
    def num_cores_per_socket(self, num_cores_per_socket):
        self._num_cores_per_socket = num_cores_per_socket

    @property
    def cpu_resource_mhz(self):
        return self._cpu_resource_mhz
    
    @cpu_resource_mhz.setter
    def cpu_resource_mhz(self, cpu_resource_mhz):
        self._cpu_resource_mhz = cpu_resource_mhz

    @property
    def memory_resource_mb(self):
        return self._memory_resource_mb
    
    @memory_resource_mb.setter
    def memory_resource_mb(self, memory_resource_mb):
        self._memory_resource_mb = memory_resource_mb

    @property
    def media_section(self):
        return self._media_section
    
    @media_section.setter
    def media_section(self, media_section):
        self._media_section = media_section

    @property
    def disk_section(self):
        return self._disk_section
    
    @disk_section.setter
    def disk_section(self, disk_section):
        self._disk_section = disk_section

    @property
    def hardware_version(self):
        return self._hardware_version
    
    @hardware_version.setter
    def hardware_version(self, hardware_version):
        self._hardware_version = hardware_version

    @property
    def vm_tools_version(self):
        return self._vm_tools_version
    
    @vm_tools_version.setter
    def vm_tools_version(self, vm_tools_version):
        self._vm_tools_version = vm_tools_version

    @property
    def tools_guest_os_id(self):
        return self._tools_guest_os_id
    
    @tools_guest_os_id.setter
    def tools_guest_os_id(self, tools_guest_os_id):
        self._tools_guest_os_id = tools_guest_os_id

    @property
    def virtual_cpu_type(self):
        return self._virtual_cpu_type
    
    @virtual_cpu_type.setter
    def virtual_cpu_type(self, virtual_cpu_type):
        self._virtual_cpu_type = virtual_cpu_type

    @property
    def time_sync_with_host(self):
        return self._time_sync_with_host
    
    @time_sync_with_host.setter
    def time_sync_with_host(self, time_sync_with_host):
        self._time_sync_with_host = time_sync_with_host

    @property
    def modified(self):
        return self._modified
    
    @modified.setter
    def modified(self, modified):
        self._modified = modified


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmSpecSectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
