"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class VendorServicesType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'network_services': 'list[NetworkServiceInsertionType]',
        'edge_gateway_services': 'list[NetworkServiceInsertionType]'
    }

    attribute_map = {
        'network_services': 'networkServices',
        'edge_gateway_services': 'edgeGatewayServices'
    }

    def __init__(self, network_services=None,edge_gateway_services=None):
        self._network_services = None
        self._edge_gateway_services = None

        if network_services is not None:
            self.network_services = network_services
        if edge_gateway_services is not None:
            self.edge_gateway_services = edge_gateway_services

    @property
    def network_services(self):
        return self._network_services
    
    @network_services.setter
    def network_services(self, network_services):
        self._network_services = network_services

    @property
    def edge_gateway_services(self):
        return self._edge_gateway_services
    
    @edge_gateway_services.setter
    def edge_gateway_services(self, edge_gateway_services):
        self._edge_gateway_services = edge_gateway_services


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VendorServicesType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
