"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class UploadVAppTemplateParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vdc_storage_profile': 'ReferenceType',
        'manifest_required': 'bool',
        'source_href': 'str',
        'transfer_format': 'str'
    }

    attribute_map = {
        'vdc_storage_profile': 'vdcStorageProfile',
        'manifest_required': 'manifestRequired',
        'source_href': 'sourceHref',
        'transfer_format': 'transferFormat'
    }

    def __init__(self, vdc_storage_profile=None,manifest_required=None,source_href=None,transfer_format=None):
        self._vdc_storage_profile = None
        self._manifest_required = None
        self._source_href = None
        self._transfer_format = None

        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if manifest_required is not None:
            self.manifest_required = manifest_required
        if source_href is not None:
            self.source_href = source_href
        if transfer_format is not None:
            self.transfer_format = transfer_format

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def manifest_required(self):
        return self._manifest_required
    
    @manifest_required.setter
    def manifest_required(self, manifest_required):
        self._manifest_required = manifest_required

    @property
    def source_href(self):
        return self._source_href
    
    @source_href.setter
    def source_href(self, source_href):
        self._source_href = source_href

    @property
    def transfer_format(self):
        return self._transfer_format
    
    @transfer_format.setter
    def transfer_format(self, transfer_format):
        self._transfer_format = transfer_format


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadVAppTemplateParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
