"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class TunnelingApplicationRegisterParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'traffic_type': 'str',
        'routing_key': 'str',
        'exchange': 'str'
    }

    attribute_map = {
        'traffic_type': 'trafficType',
        'routing_key': 'routingKey',
        'exchange': 'exchange'
    }

    def __init__(self, traffic_type=None,routing_key=None,exchange=None):
        self._traffic_type = None
        self._routing_key = None
        self._exchange = None

        if traffic_type is not None:
            self.traffic_type = traffic_type
        if routing_key is not None:
            self.routing_key = routing_key
        if exchange is not None:
            self.exchange = exchange

    @property
    def traffic_type(self):
        return self._traffic_type
    
    @traffic_type.setter
    def traffic_type(self, traffic_type):
        self._traffic_type = traffic_type

    @property
    def routing_key(self):
        return self._routing_key
    
    @routing_key.setter
    def routing_key(self, routing_key):
        self._routing_key = routing_key

    @property
    def exchange(self):
        return self._exchange
    
    @exchange.setter
    def exchange(self, exchange):
        self._exchange = exchange


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TunnelingApplicationRegisterParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
