"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class TaskRequestBaseType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization': 'ReferenceType',
        'user': 'ReferenceType',
        'task_owner': 'ReferenceType',
        'created_time': 'str',
        'timeout_action': 'str',
        'timeout_date': 'str'
    }

    attribute_map = {
        'organization': 'organization',
        'user': 'user',
        'task_owner': 'taskOwner',
        'created_time': 'createdTime',
        'timeout_action': 'timeoutAction',
        'timeout_date': 'timeoutDate'
    }

    def __init__(self, organization=None,user=None,task_owner=None,created_time=None,timeout_action=None,timeout_date=None):
        self._organization = None
        self._user = None
        self._task_owner = None
        self._created_time = None
        self._timeout_action = None
        self._timeout_date = None

        if organization is not None:
            self.organization = organization
        if user is not None:
            self.user = user
        if task_owner is not None:
            self.task_owner = task_owner
        if created_time is not None:
            self.created_time = created_time
        if timeout_action is not None:
            self.timeout_action = timeout_action
        if timeout_date is not None:
            self.timeout_date = timeout_date

    @property
    def organization(self):
        return self._organization
    
    @organization.setter
    def organization(self, organization):
        self._organization = organization

    @property
    def user(self):
        return self._user
    
    @user.setter
    def user(self, user):
        self._user = user

    @property
    def task_owner(self):
        return self._task_owner
    
    @task_owner.setter
    def task_owner(self, task_owner):
        self._task_owner = task_owner

    @property
    def created_time(self):
        return self._created_time
    
    @created_time.setter
    def created_time(self, created_time):
        self._created_time = created_time

    @property
    def timeout_action(self):
        return self._timeout_action
    
    @timeout_action.setter
    def timeout_action(self, timeout_action):
        self._timeout_action = timeout_action

    @property
    def timeout_date(self):
        return self._timeout_date
    
    @timeout_date.setter
    def timeout_date(self, timeout_date):
        self._timeout_date = timeout_date


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskRequestBaseType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
