"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class RemoteUriProbeResultType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'RemoteUriProbeResultStatus',
        'error_message': 'str',
        'ssl_thumbprint': 'str',
        'ssl_certificate_encoded': 'list[str]'
    }

    attribute_map = {
        'status': 'status',
        'error_message': 'errorMessage',
        'ssl_thumbprint': 'sslThumbprint',
        'ssl_certificate_encoded': 'sslCertificateEncoded'
    }

    def __init__(self, status=None,error_message=None,ssl_thumbprint=None,ssl_certificate_encoded=None):
        self._status = None
        self._error_message = None
        self._ssl_thumbprint = None
        self._ssl_certificate_encoded = None

        if status is not None:
            self.status = status
        if error_message is not None:
            self.error_message = error_message
        if ssl_thumbprint is not None:
            self.ssl_thumbprint = ssl_thumbprint
        if ssl_certificate_encoded is not None:
            self.ssl_certificate_encoded = ssl_certificate_encoded

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def error_message(self):
        return self._error_message
    
    @error_message.setter
    def error_message(self, error_message):
        self._error_message = error_message

    @property
    def ssl_thumbprint(self):
        return self._ssl_thumbprint
    
    @ssl_thumbprint.setter
    def ssl_thumbprint(self, ssl_thumbprint):
        self._ssl_thumbprint = ssl_thumbprint

    @property
    def ssl_certificate_encoded(self):
        return self._ssl_certificate_encoded
    
    @ssl_certificate_encoded.setter
    def ssl_certificate_encoded(self, ssl_certificate_encoded):
        self._ssl_certificate_encoded = ssl_certificate_encoded


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RemoteUriProbeResultType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
