"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .compose_v_app_params_type import ComposeVAppParamsType


class RecomposeVAppParamsType(ComposeVAppParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'delete_item': 'list[ReferenceType]',
        'reconfigure_item': 'list[VmType]'
    }

    attribute_map = {
        'delete_item': 'deleteItem',
        'reconfigure_item': 'reconfigureItem'
    }

    def __init__(self, delete_item=None,reconfigure_item=None):
        self._delete_item = None
        self._reconfigure_item = None

        if delete_item is not None:
            self.delete_item = delete_item
        if reconfigure_item is not None:
            self.reconfigure_item = reconfigure_item

    @property
    def delete_item(self):
        return self._delete_item
    
    @delete_item.setter
    def delete_item(self, delete_item):
        self._delete_item = delete_item

    @property
    def reconfigure_item(self):
        return self._reconfigure_item
    
    @reconfigure_item.setter
    def reconfigure_item(self, reconfigure_item):
        self._reconfigure_item = reconfigure_item


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecomposeVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
