"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVMWProviderVdcRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cpu_allocation_mhz': 'int',
        'cpu_limit_mhz': 'int',
        'cpu_used_mhz': 'int',
        'is_busy': 'bool',
        'is_deleted': 'bool',
        'is_enabled': 'bool',
        'memory_allocation_mb': 'int',
        'memory_limit_mb': 'int',
        'memory_used_mb': 'int',
        'name': 'str',
        'number_of_datastores': 'int',
        'number_of_storage_profiles': 'int',
        'number_of_vdcs': 'int',
        'status': 'str',
        'storage_allocation_mb': 'int',
        'storage_limit_mb': 'int',
        'storage_used_mb': 'int',
        'vcpu_rating_mhz': 'int'
    }

    attribute_map = {
        'cpu_allocation_mhz': 'cpuAllocationMhz',
        'cpu_limit_mhz': 'cpuLimitMhz',
        'cpu_used_mhz': 'cpuUsedMhz',
        'is_busy': 'isBusy',
        'is_deleted': 'isDeleted',
        'is_enabled': 'isEnabled',
        'memory_allocation_mb': 'memoryAllocationMB',
        'memory_limit_mb': 'memoryLimitMB',
        'memory_used_mb': 'memoryUsedMB',
        'name': 'name',
        'number_of_datastores': 'numberOfDatastores',
        'number_of_storage_profiles': 'numberOfStorageProfiles',
        'number_of_vdcs': 'numberOfVdcs',
        'status': 'status',
        'storage_allocation_mb': 'storageAllocationMB',
        'storage_limit_mb': 'storageLimitMB',
        'storage_used_mb': 'storageUsedMB',
        'vcpu_rating_mhz': 'vcpuRatingMhz'
    }

    def __init__(self, cpu_allocation_mhz=None,cpu_limit_mhz=None,cpu_used_mhz=None,is_busy=None,is_deleted=None,is_enabled=None,memory_allocation_mb=None,memory_limit_mb=None,memory_used_mb=None,name=None,number_of_datastores=None,number_of_storage_profiles=None,number_of_vdcs=None,status=None,storage_allocation_mb=None,storage_limit_mb=None,storage_used_mb=None,vcpu_rating_mhz=None):
        self._cpu_allocation_mhz = None
        self._cpu_limit_mhz = None
        self._cpu_used_mhz = None
        self._is_busy = None
        self._is_deleted = None
        self._is_enabled = None
        self._memory_allocation_mb = None
        self._memory_limit_mb = None
        self._memory_used_mb = None
        self._name = None
        self._number_of_datastores = None
        self._number_of_storage_profiles = None
        self._number_of_vdcs = None
        self._status = None
        self._storage_allocation_mb = None
        self._storage_limit_mb = None
        self._storage_used_mb = None
        self._vcpu_rating_mhz = None

        if cpu_allocation_mhz is not None:
            self.cpu_allocation_mhz = cpu_allocation_mhz
        if cpu_limit_mhz is not None:
            self.cpu_limit_mhz = cpu_limit_mhz
        if cpu_used_mhz is not None:
            self.cpu_used_mhz = cpu_used_mhz
        if is_busy is not None:
            self.is_busy = is_busy
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if memory_allocation_mb is not None:
            self.memory_allocation_mb = memory_allocation_mb
        if memory_limit_mb is not None:
            self.memory_limit_mb = memory_limit_mb
        if memory_used_mb is not None:
            self.memory_used_mb = memory_used_mb
        if name is not None:
            self.name = name
        if number_of_datastores is not None:
            self.number_of_datastores = number_of_datastores
        if number_of_storage_profiles is not None:
            self.number_of_storage_profiles = number_of_storage_profiles
        if number_of_vdcs is not None:
            self.number_of_vdcs = number_of_vdcs
        if status is not None:
            self.status = status
        if storage_allocation_mb is not None:
            self.storage_allocation_mb = storage_allocation_mb
        if storage_limit_mb is not None:
            self.storage_limit_mb = storage_limit_mb
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if vcpu_rating_mhz is not None:
            self.vcpu_rating_mhz = vcpu_rating_mhz

    @property
    def cpu_allocation_mhz(self):
        return self._cpu_allocation_mhz
    
    @cpu_allocation_mhz.setter
    def cpu_allocation_mhz(self, cpu_allocation_mhz):
        self._cpu_allocation_mhz = cpu_allocation_mhz

    @property
    def cpu_limit_mhz(self):
        return self._cpu_limit_mhz
    
    @cpu_limit_mhz.setter
    def cpu_limit_mhz(self, cpu_limit_mhz):
        self._cpu_limit_mhz = cpu_limit_mhz

    @property
    def cpu_used_mhz(self):
        return self._cpu_used_mhz
    
    @cpu_used_mhz.setter
    def cpu_used_mhz(self, cpu_used_mhz):
        self._cpu_used_mhz = cpu_used_mhz

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def memory_allocation_mb(self):
        return self._memory_allocation_mb
    
    @memory_allocation_mb.setter
    def memory_allocation_mb(self, memory_allocation_mb):
        self._memory_allocation_mb = memory_allocation_mb

    @property
    def memory_limit_mb(self):
        return self._memory_limit_mb
    
    @memory_limit_mb.setter
    def memory_limit_mb(self, memory_limit_mb):
        self._memory_limit_mb = memory_limit_mb

    @property
    def memory_used_mb(self):
        return self._memory_used_mb
    
    @memory_used_mb.setter
    def memory_used_mb(self, memory_used_mb):
        self._memory_used_mb = memory_used_mb

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_datastores(self):
        return self._number_of_datastores
    
    @number_of_datastores.setter
    def number_of_datastores(self, number_of_datastores):
        self._number_of_datastores = number_of_datastores

    @property
    def number_of_storage_profiles(self):
        return self._number_of_storage_profiles
    
    @number_of_storage_profiles.setter
    def number_of_storage_profiles(self, number_of_storage_profiles):
        self._number_of_storage_profiles = number_of_storage_profiles

    @property
    def number_of_vdcs(self):
        return self._number_of_vdcs
    
    @number_of_vdcs.setter
    def number_of_vdcs(self, number_of_vdcs):
        self._number_of_vdcs = number_of_vdcs

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_allocation_mb(self):
        return self._storage_allocation_mb
    
    @storage_allocation_mb.setter
    def storage_allocation_mb(self, storage_allocation_mb):
        self._storage_allocation_mb = storage_allocation_mb

    @property
    def storage_limit_mb(self):
        return self._storage_limit_mb
    
    @storage_limit_mb.setter
    def storage_limit_mb(self, storage_limit_mb):
        self._storage_limit_mb = storage_limit_mb

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def vcpu_rating_mhz(self):
        return self._vcpu_rating_mhz
    
    @vcpu_rating_mhz.setter
    def vcpu_rating_mhz(self, vcpu_rating_mhz):
        self._vcpu_rating_mhz = vcpu_rating_mhz


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVMWProviderVdcRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
