"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVmGroupsRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_moref': 'str',
        'vc_id': 'str',
        'vm_group_id': 'str',
        'vm_group_name': 'str'
    }

    attribute_map = {
        'cluster_moref': 'clusterMoref',
        'vc_id': 'vcId',
        'vm_group_id': 'vmGroupId',
        'vm_group_name': 'vmGroupName'
    }

    def __init__(self, cluster_moref=None,vc_id=None,vm_group_id=None,vm_group_name=None):
        self._cluster_moref = None
        self._vc_id = None
        self._vm_group_id = None
        self._vm_group_name = None

        if cluster_moref is not None:
            self.cluster_moref = cluster_moref
        if vc_id is not None:
            self.vc_id = vc_id
        if vm_group_id is not None:
            self.vm_group_id = vm_group_id
        if vm_group_name is not None:
            self.vm_group_name = vm_group_name

    @property
    def cluster_moref(self):
        return self._cluster_moref
    
    @cluster_moref.setter
    def cluster_moref(self, cluster_moref):
        self._cluster_moref = cluster_moref

    @property
    def vc_id(self):
        return self._vc_id
    
    @vc_id.setter
    def vc_id(self, vc_id):
        self._vc_id = vc_id

    @property
    def vm_group_id(self):
        return self._vm_group_id
    
    @vm_group_id.setter
    def vm_group_id(self, vm_group_id):
        self._vm_group_id = vm_group_id

    @property
    def vm_group_name(self):
        return self._vm_group_name
    
    @vm_group_name.setter
    def vm_group_name(self, vm_group_name):
        self._vm_group_name = vm_group_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVmGroupsRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
