"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVirtualCenterRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_busy': 'bool',
        'is_enabled': 'bool',
        'is_supported': 'bool',
        'listener_state': 'str',
        'name': 'str',
        'status': 'str',
        'url': 'str',
        'user_name': 'str',
        'uuid': 'str',
        'vc_version': 'str',
        'vsm_ip': 'str'
    }

    attribute_map = {
        'is_busy': 'isBusy',
        'is_enabled': 'isEnabled',
        'is_supported': 'isSupported',
        'listener_state': 'listenerState',
        'name': 'name',
        'status': 'status',
        'url': 'url',
        'user_name': 'userName',
        'uuid': 'uuid',
        'vc_version': 'vcVersion',
        'vsm_ip': 'vsmIP'
    }

    def __init__(self, is_busy=None,is_enabled=None,is_supported=None,listener_state=None,name=None,status=None,url=None,user_name=None,uuid=None,vc_version=None,vsm_ip=None):
        self._is_busy = None
        self._is_enabled = None
        self._is_supported = None
        self._listener_state = None
        self._name = None
        self._status = None
        self._url = None
        self._user_name = None
        self._uuid = None
        self._vc_version = None
        self._vsm_ip = None

        if is_busy is not None:
            self.is_busy = is_busy
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_supported is not None:
            self.is_supported = is_supported
        if listener_state is not None:
            self.listener_state = listener_state
        if name is not None:
            self.name = name
        if status is not None:
            self.status = status
        if url is not None:
            self.url = url
        if user_name is not None:
            self.user_name = user_name
        if uuid is not None:
            self.uuid = uuid
        if vc_version is not None:
            self.vc_version = vc_version
        if vsm_ip is not None:
            self.vsm_ip = vsm_ip

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_supported(self):
        return self._is_supported
    
    @is_supported.setter
    def is_supported(self, is_supported):
        self._is_supported = is_supported

    @property
    def listener_state(self):
        return self._listener_state
    
    @listener_state.setter
    def listener_state(self, listener_state):
        self._listener_state = listener_state

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def url(self):
        return self._url
    
    @url.setter
    def url(self, url):
        self._url = url

    @property
    def user_name(self):
        return self._user_name
    
    @user_name.setter
    def user_name(self, user_name):
        self._user_name = user_name

    @property
    def uuid(self):
        return self._uuid
    
    @uuid.setter
    def uuid(self, uuid):
        self._uuid = uuid

    @property
    def vc_version(self):
        return self._vc_version
    
    @vc_version.setter
    def vc_version(self, vc_version):
        self._vc_version = vc_version

    @property
    def vsm_ip(self):
        return self._vsm_ip
    
    @vsm_ip.setter
    def vsm_ip(self, vsm_ip):
        self._vsm_ip = vsm_ip


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVirtualCenterRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
