"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultTaskRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'end_date': 'str',
        'name': 'str',
        'object': 'str',
        'object_name': 'str',
        'object_type': 'str',
        'org': 'str',
        'org_name': 'str',
        'owner_name': 'str',
        'progress': 'int',
        'service_namespace': 'str',
        'start_date': 'str',
        'status': 'str'
    }

    attribute_map = {
        'end_date': 'endDate',
        'name': 'name',
        'object': 'object',
        'object_name': 'objectName',
        'object_type': 'objectType',
        'org': 'org',
        'org_name': 'orgName',
        'owner_name': 'ownerName',
        'progress': 'progress',
        'service_namespace': 'serviceNamespace',
        'start_date': 'startDate',
        'status': 'status'
    }

    def __init__(self, end_date=None,name=None,object=None,object_name=None,object_type=None,org=None,org_name=None,owner_name=None,progress=None,service_namespace=None,start_date=None,status=None):
        self._end_date = None
        self._name = None
        self._object = None
        self._object_name = None
        self._object_type = None
        self._org = None
        self._org_name = None
        self._owner_name = None
        self._progress = None
        self._service_namespace = None
        self._start_date = None
        self._status = None

        if end_date is not None:
            self.end_date = end_date
        if name is not None:
            self.name = name
        if object is not None:
            self.object = object
        if object_name is not None:
            self.object_name = object_name
        if object_type is not None:
            self.object_type = object_type
        if org is not None:
            self.org = org
        if org_name is not None:
            self.org_name = org_name
        if owner_name is not None:
            self.owner_name = owner_name
        if progress is not None:
            self.progress = progress
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if start_date is not None:
            self.start_date = start_date
        if status is not None:
            self.status = status

    @property
    def end_date(self):
        return self._end_date
    
    @end_date.setter
    def end_date(self, end_date):
        self._end_date = end_date

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def object(self):
        return self._object
    
    @object.setter
    def object(self, object):
        self._object = object

    @property
    def object_name(self):
        return self._object_name
    
    @object_name.setter
    def object_name(self, object_name):
        self._object_name = object_name

    @property
    def object_type(self):
        return self._object_type
    
    @object_type.setter
    def object_type(self, object_type):
        self._object_type = object_type

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def progress(self):
        return self._progress
    
    @progress.setter
    def progress(self, progress):
        self._progress = progress

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def start_date(self):
        return self._start_date
    
    @start_date.setter
    def start_date(self, start_date):
        self._start_date = start_date

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultTaskRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
