"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultServiceLinkRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link_href': 'str',
        'mime_type': 'str',
        'rel': 'str',
        'resource_id': 'str',
        'resource_type': 'str',
        'service': 'str'
    }

    attribute_map = {
        'link_href': 'linkHref',
        'mime_type': 'mimeType',
        'rel': 'rel',
        'resource_id': 'resourceId',
        'resource_type': 'resourceType',
        'service': 'service'
    }

    def __init__(self, link_href=None,mime_type=None,rel=None,resource_id=None,resource_type=None,service=None):
        self._link_href = None
        self._mime_type = None
        self._rel = None
        self._resource_id = None
        self._resource_type = None
        self._service = None

        if link_href is not None:
            self.link_href = link_href
        if mime_type is not None:
            self.mime_type = mime_type
        if rel is not None:
            self.rel = rel
        if resource_id is not None:
            self.resource_id = resource_id
        if resource_type is not None:
            self.resource_type = resource_type
        if service is not None:
            self.service = service

    @property
    def link_href(self):
        return self._link_href
    
    @link_href.setter
    def link_href(self, link_href):
        self._link_href = link_href

    @property
    def mime_type(self):
        return self._mime_type
    
    @mime_type.setter
    def mime_type(self, mime_type):
        self._mime_type = mime_type

    @property
    def rel(self):
        return self._rel
    
    @rel.setter
    def rel(self, rel):
        self._rel = rel

    @property
    def resource_id(self):
        return self._resource_id
    
    @resource_id.setter
    def resource_id(self, resource_id):
        self._resource_id = resource_id

    @property
    def resource_type(self):
        return self._resource_type
    
    @resource_type.setter
    def resource_type(self, resource_type):
        self._resource_type = resource_type

    @property
    def service(self):
        return self._service
    
    @service.setter
    def service(self, service):
        self._service = service


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultServiceLinkRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
