"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultNetworkPoolRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_busy': 'bool',
        'name': 'str',
        'network_pool_type': 'int',
        'universal_id': 'str'
    }

    attribute_map = {
        'is_busy': 'isBusy',
        'name': 'name',
        'network_pool_type': 'networkPoolType',
        'universal_id': 'universalId'
    }

    def __init__(self, is_busy=None,name=None,network_pool_type=None,universal_id=None):
        self._is_busy = None
        self._name = None
        self._network_pool_type = None
        self._universal_id = None

        if is_busy is not None:
            self.is_busy = is_busy
        if name is not None:
            self.name = name
        if network_pool_type is not None:
            self.network_pool_type = network_pool_type
        if universal_id is not None:
            self.universal_id = universal_id

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def network_pool_type(self):
        return self._network_pool_type
    
    @network_pool_type.setter
    def network_pool_type(self, network_pool_type):
        self._network_pool_type = network_pool_type

    @property
    def universal_id(self):
        return self._universal_id
    
    @universal_id.setter
    def universal_id(self, universal_id):
        self._universal_id = universal_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultNetworkPoolRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
