"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultLicensingVirtualMachineRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'managed_object_reference': 'str',
        'memory': 'int',
        'observation_date': 'str',
        'parent_sample_id': 'str',
        'virtual_center_id': 'str',
        'virtual_cpu_count': 'int'
    }

    attribute_map = {
        'managed_object_reference': 'managedObjectReference',
        'memory': 'memory',
        'observation_date': 'observationDate',
        'parent_sample_id': 'parentSampleId',
        'virtual_center_id': 'virtualCenterId',
        'virtual_cpu_count': 'virtualCpuCount'
    }

    def __init__(self, managed_object_reference=None,memory=None,observation_date=None,parent_sample_id=None,virtual_center_id=None,virtual_cpu_count=None):
        self._managed_object_reference = None
        self._memory = None
        self._observation_date = None
        self._parent_sample_id = None
        self._virtual_center_id = None
        self._virtual_cpu_count = None

        if managed_object_reference is not None:
            self.managed_object_reference = managed_object_reference
        if memory is not None:
            self.memory = memory
        if observation_date is not None:
            self.observation_date = observation_date
        if parent_sample_id is not None:
            self.parent_sample_id = parent_sample_id
        if virtual_center_id is not None:
            self.virtual_center_id = virtual_center_id
        if virtual_cpu_count is not None:
            self.virtual_cpu_count = virtual_cpu_count

    @property
    def managed_object_reference(self):
        return self._managed_object_reference
    
    @managed_object_reference.setter
    def managed_object_reference(self, managed_object_reference):
        self._managed_object_reference = managed_object_reference

    @property
    def memory(self):
        return self._memory
    
    @memory.setter
    def memory(self, memory):
        self._memory = memory

    @property
    def observation_date(self):
        return self._observation_date
    
    @observation_date.setter
    def observation_date(self, observation_date):
        self._observation_date = observation_date

    @property
    def parent_sample_id(self):
        return self._parent_sample_id
    
    @parent_sample_id.setter
    def parent_sample_id(self, parent_sample_id):
        self._parent_sample_id = parent_sample_id

    @property
    def virtual_center_id(self):
        return self._virtual_center_id
    
    @virtual_center_id.setter
    def virtual_center_id(self, virtual_center_id):
        self._virtual_center_id = virtual_center_id

    @property
    def virtual_cpu_count(self):
        return self._virtual_cpu_count
    
    @virtual_cpu_count.setter
    def virtual_cpu_count(self, virtual_cpu_count):
        self._virtual_cpu_count = virtual_cpu_count


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultLicensingVirtualMachineRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
