"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultConditionRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'details': 'str',
        'object': 'str',
        'object_type': 'str',
        'occurence_date': 'str',
        'severity': 'str',
        'summary': 'str'
    }

    attribute_map = {
        'details': 'details',
        'object': 'object',
        'object_type': 'objectType',
        'occurence_date': 'occurenceDate',
        'severity': 'severity',
        'summary': 'summary'
    }

    def __init__(self, details=None,object=None,object_type=None,occurence_date=None,severity=None,summary=None):
        self._details = None
        self._object = None
        self._object_type = None
        self._occurence_date = None
        self._severity = None
        self._summary = None

        if details is not None:
            self.details = details
        if object is not None:
            self.object = object
        if object_type is not None:
            self.object_type = object_type
        if occurence_date is not None:
            self.occurence_date = occurence_date
        if severity is not None:
            self.severity = severity
        if summary is not None:
            self.summary = summary

    @property
    def details(self):
        return self._details
    
    @details.setter
    def details(self, details):
        self._details = details

    @property
    def object(self):
        return self._object
    
    @object.setter
    def object(self, object):
        self._object = object

    @property
    def object_type(self):
        return self._object_type
    
    @object_type.setter
    def object_type(self, object_type):
        self._object_type = object_type

    @property
    def occurence_date(self):
        return self._occurence_date
    
    @occurence_date.setter
    def occurence_date(self, occurence_date):
        self._occurence_date = occurence_date

    @property
    def severity(self):
        return self._severity
    
    @severity.setter
    def severity(self, severity):
        self._severity = severity

    @property
    def summary(self):
        return self._summary
    
    @summary.setter
    def summary(self, summary):
        self._summary = summary


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultConditionRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
