"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAllocatedExternalAddressRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip_address': 'str',
        'linked_network': 'str',
        'network': 'str'
    }

    attribute_map = {
        'ip_address': 'ipAddress',
        'linked_network': 'linkedNetwork',
        'network': 'network'
    }

    def __init__(self, ip_address=None,linked_network=None,network=None):
        self._ip_address = None
        self._linked_network = None
        self._network = None

        if ip_address is not None:
            self.ip_address = ip_address
        if linked_network is not None:
            self.linked_network = linked_network
        if network is not None:
            self.network = network

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def linked_network(self):
        return self._linked_network
    
    @linked_network.setter
    def linked_network(self, linked_network):
        self._linked_network = linked_network

    @property
    def network(self):
        return self._network
    
    @network.setter
    def network(self, network):
        self._network = network


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAllocatedExternalAddressRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
