"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminVMRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'catalog_name': 'str',
        'container': 'str',
        'container_name': 'str',
        'datastore_name': 'str',
        'gc_status': 'str',
        'guest_os': 'str',
        'hardware_version': 'int',
        'host_name': 'str',
        'is_auto_nature': 'bool',
        'is_deleted': 'bool',
        'is_deployed': 'bool',
        'is_published': 'bool',
        'is_v_app_template': 'bool',
        'is_vdc_enabled': 'bool',
        'memory_mb': 'int',
        'moref': 'str',
        'name': 'str',
        'network_name': 'str',
        'number_of_cpus': 'int',
        'org': 'str',
        'status': 'str',
        'storage_profile_name': 'str',
        'vc': 'str',
        'vdc': 'str',
        'vm_tools_version': 'int'
    }

    attribute_map = {
        'catalog_name': 'catalogName',
        'container': 'container',
        'container_name': 'containerName',
        'datastore_name': 'datastoreName',
        'gc_status': 'gcStatus',
        'guest_os': 'guestOs',
        'hardware_version': 'hardwareVersion',
        'host_name': 'hostName',
        'is_auto_nature': 'isAutoNature',
        'is_deleted': 'isDeleted',
        'is_deployed': 'isDeployed',
        'is_published': 'isPublished',
        'is_v_app_template': 'isVAppTemplate',
        'is_vdc_enabled': 'isVdcEnabled',
        'memory_mb': 'memoryMB',
        'moref': 'moref',
        'name': 'name',
        'network_name': 'networkName',
        'number_of_cpus': 'numberOfCpus',
        'org': 'org',
        'status': 'status',
        'storage_profile_name': 'storageProfileName',
        'vc': 'vc',
        'vdc': 'vdc',
        'vm_tools_version': 'vmToolsVersion'
    }

    def __init__(self, catalog_name=None,container=None,container_name=None,datastore_name=None,gc_status=None,guest_os=None,hardware_version=None,host_name=None,is_auto_nature=None,is_deleted=None,is_deployed=None,is_published=None,is_v_app_template=None,is_vdc_enabled=None,memory_mb=None,moref=None,name=None,network_name=None,number_of_cpus=None,org=None,status=None,storage_profile_name=None,vc=None,vdc=None,vm_tools_version=None):
        self._catalog_name = None
        self._container = None
        self._container_name = None
        self._datastore_name = None
        self._gc_status = None
        self._guest_os = None
        self._hardware_version = None
        self._host_name = None
        self._is_auto_nature = None
        self._is_deleted = None
        self._is_deployed = None
        self._is_published = None
        self._is_v_app_template = None
        self._is_vdc_enabled = None
        self._memory_mb = None
        self._moref = None
        self._name = None
        self._network_name = None
        self._number_of_cpus = None
        self._org = None
        self._status = None
        self._storage_profile_name = None
        self._vc = None
        self._vdc = None
        self._vm_tools_version = None

        if catalog_name is not None:
            self.catalog_name = catalog_name
        if container is not None:
            self.container = container
        if container_name is not None:
            self.container_name = container_name
        if datastore_name is not None:
            self.datastore_name = datastore_name
        if gc_status is not None:
            self.gc_status = gc_status
        if guest_os is not None:
            self.guest_os = guest_os
        if hardware_version is not None:
            self.hardware_version = hardware_version
        if host_name is not None:
            self.host_name = host_name
        if is_auto_nature is not None:
            self.is_auto_nature = is_auto_nature
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if is_published is not None:
            self.is_published = is_published
        if is_v_app_template is not None:
            self.is_v_app_template = is_v_app_template
        if is_vdc_enabled is not None:
            self.is_vdc_enabled = is_vdc_enabled
        if memory_mb is not None:
            self.memory_mb = memory_mb
        if moref is not None:
            self.moref = moref
        if name is not None:
            self.name = name
        if network_name is not None:
            self.network_name = network_name
        if number_of_cpus is not None:
            self.number_of_cpus = number_of_cpus
        if org is not None:
            self.org = org
        if status is not None:
            self.status = status
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if vc is not None:
            self.vc = vc
        if vdc is not None:
            self.vdc = vdc
        if vm_tools_version is not None:
            self.vm_tools_version = vm_tools_version

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def container(self):
        return self._container
    
    @container.setter
    def container(self, container):
        self._container = container

    @property
    def container_name(self):
        return self._container_name
    
    @container_name.setter
    def container_name(self, container_name):
        self._container_name = container_name

    @property
    def datastore_name(self):
        return self._datastore_name
    
    @datastore_name.setter
    def datastore_name(self, datastore_name):
        self._datastore_name = datastore_name

    @property
    def gc_status(self):
        return self._gc_status
    
    @gc_status.setter
    def gc_status(self, gc_status):
        self._gc_status = gc_status

    @property
    def guest_os(self):
        return self._guest_os
    
    @guest_os.setter
    def guest_os(self, guest_os):
        self._guest_os = guest_os

    @property
    def hardware_version(self):
        return self._hardware_version
    
    @hardware_version.setter
    def hardware_version(self, hardware_version):
        self._hardware_version = hardware_version

    @property
    def host_name(self):
        return self._host_name
    
    @host_name.setter
    def host_name(self, host_name):
        self._host_name = host_name

    @property
    def is_auto_nature(self):
        return self._is_auto_nature
    
    @is_auto_nature.setter
    def is_auto_nature(self, is_auto_nature):
        self._is_auto_nature = is_auto_nature

    @property
    def is_deleted(self):
        return self._is_deleted
    
    @is_deleted.setter
    def is_deleted(self, is_deleted):
        self._is_deleted = is_deleted

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def is_v_app_template(self):
        return self._is_v_app_template
    
    @is_v_app_template.setter
    def is_v_app_template(self, is_v_app_template):
        self._is_v_app_template = is_v_app_template

    @property
    def is_vdc_enabled(self):
        return self._is_vdc_enabled
    
    @is_vdc_enabled.setter
    def is_vdc_enabled(self, is_vdc_enabled):
        self._is_vdc_enabled = is_vdc_enabled

    @property
    def memory_mb(self):
        return self._memory_mb
    
    @memory_mb.setter
    def memory_mb(self, memory_mb):
        self._memory_mb = memory_mb

    @property
    def moref(self):
        return self._moref
    
    @moref.setter
    def moref(self, moref):
        self._moref = moref

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def network_name(self):
        return self._network_name
    
    @network_name.setter
    def network_name(self, network_name):
        self._network_name = network_name

    @property
    def number_of_cpus(self):
        return self._number_of_cpus
    
    @number_of_cpus.setter
    def number_of_cpus(self, number_of_cpus):
        self._number_of_cpus = number_of_cpus

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vm_tools_version(self):
        return self._vm_tools_version
    
    @vm_tools_version.setter
    def vm_tools_version(self, vm_tools_version):
        self._vm_tools_version = vm_tools_version


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminVMRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
