"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminVdcRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allocation_model': 'int',
        'cpu_allocation_mhz': 'int',
        'cpu_limit_mhz': 'int',
        'cpu_overhead_mhz': 'int',
        'cpu_reserved_mhz': 'int',
        'cpu_used_mhz': 'int',
        'description': 'str',
        'is_busy': 'bool',
        'is_enabled': 'bool',
        'is_system_vdc': 'bool',
        'is_vc_enabled': 'bool',
        'memory_allocation_mb': 'int',
        'memory_limit_mb': 'int',
        'memory_overhead_mb': 'int',
        'memory_reserved_mb': 'int',
        'memory_used_mb': 'int',
        'name': 'str',
        'network_pool': 'str',
        'network_pool_universal_id': 'str',
        'number_of_deployed_v_apps': 'int',
        'number_of_disks': 'int',
        'number_of_media': 'int',
        'number_of_resource_pools': 'int',
        'number_of_running_v_ms': 'int',
        'number_of_storage_profiles': 'int',
        'number_of_v_app_templates': 'int',
        'number_of_v_apps': 'int',
        'number_of_v_ms': 'int',
        'org': 'str',
        'org_name': 'str',
        'provider_vdc': 'str',
        'provider_vdc_name': 'str',
        'status': 'str',
        'storage_allocation_mb': 'int',
        'storage_limit_mb': 'int',
        'storage_overhead_mb': 'int',
        'storage_used_mb': 'int',
        'task': 'str',
        'task_details': 'str',
        'task_status': 'str',
        'task_status_name': 'str',
        'vc': 'str',
        'vc_name': 'str'
    }

    attribute_map = {
        'allocation_model': 'allocationModel',
        'cpu_allocation_mhz': 'cpuAllocationMhz',
        'cpu_limit_mhz': 'cpuLimitMhz',
        'cpu_overhead_mhz': 'cpuOverheadMhz',
        'cpu_reserved_mhz': 'cpuReservedMhz',
        'cpu_used_mhz': 'cpuUsedMhz',
        'description': 'description',
        'is_busy': 'isBusy',
        'is_enabled': 'isEnabled',
        'is_system_vdc': 'isSystemVdc',
        'is_vc_enabled': 'isVCEnabled',
        'memory_allocation_mb': 'memoryAllocationMB',
        'memory_limit_mb': 'memoryLimitMB',
        'memory_overhead_mb': 'memoryOverheadMB',
        'memory_reserved_mb': 'memoryReservedMB',
        'memory_used_mb': 'memoryUsedMB',
        'name': 'name',
        'network_pool': 'networkPool',
        'network_pool_universal_id': 'networkPoolUniversalId',
        'number_of_deployed_v_apps': 'numberOfDeployedVApps',
        'number_of_disks': 'numberOfDisks',
        'number_of_media': 'numberOfMedia',
        'number_of_resource_pools': 'numberOfResourcePools',
        'number_of_running_v_ms': 'numberOfRunningVMs',
        'number_of_storage_profiles': 'numberOfStorageProfiles',
        'number_of_v_app_templates': 'numberOfVAppTemplates',
        'number_of_v_apps': 'numberOfVApps',
        'number_of_v_ms': 'numberOfVMs',
        'org': 'org',
        'org_name': 'orgName',
        'provider_vdc': 'providerVdc',
        'provider_vdc_name': 'providerVdcName',
        'status': 'status',
        'storage_allocation_mb': 'storageAllocationMB',
        'storage_limit_mb': 'storageLimitMB',
        'storage_overhead_mb': 'storageOverheadMB',
        'storage_used_mb': 'storageUsedMB',
        'task': 'task',
        'task_details': 'taskDetails',
        'task_status': 'taskStatus',
        'task_status_name': 'taskStatusName',
        'vc': 'vc',
        'vc_name': 'vcName'
    }

    def __init__(self, allocation_model=None,cpu_allocation_mhz=None,cpu_limit_mhz=None,cpu_overhead_mhz=None,cpu_reserved_mhz=None,cpu_used_mhz=None,description=None,is_busy=None,is_enabled=None,is_system_vdc=None,is_vc_enabled=None,memory_allocation_mb=None,memory_limit_mb=None,memory_overhead_mb=None,memory_reserved_mb=None,memory_used_mb=None,name=None,network_pool=None,network_pool_universal_id=None,number_of_deployed_v_apps=None,number_of_disks=None,number_of_media=None,number_of_resource_pools=None,number_of_running_v_ms=None,number_of_storage_profiles=None,number_of_v_app_templates=None,number_of_v_apps=None,number_of_v_ms=None,org=None,org_name=None,provider_vdc=None,provider_vdc_name=None,status=None,storage_allocation_mb=None,storage_limit_mb=None,storage_overhead_mb=None,storage_used_mb=None,task=None,task_details=None,task_status=None,task_status_name=None,vc=None,vc_name=None):
        self._allocation_model = None
        self._cpu_allocation_mhz = None
        self._cpu_limit_mhz = None
        self._cpu_overhead_mhz = None
        self._cpu_reserved_mhz = None
        self._cpu_used_mhz = None
        self._description = None
        self._is_busy = None
        self._is_enabled = None
        self._is_system_vdc = None
        self._is_vc_enabled = None
        self._memory_allocation_mb = None
        self._memory_limit_mb = None
        self._memory_overhead_mb = None
        self._memory_reserved_mb = None
        self._memory_used_mb = None
        self._name = None
        self._network_pool = None
        self._network_pool_universal_id = None
        self._number_of_deployed_v_apps = None
        self._number_of_disks = None
        self._number_of_media = None
        self._number_of_resource_pools = None
        self._number_of_running_v_ms = None
        self._number_of_storage_profiles = None
        self._number_of_v_app_templates = None
        self._number_of_v_apps = None
        self._number_of_v_ms = None
        self._org = None
        self._org_name = None
        self._provider_vdc = None
        self._provider_vdc_name = None
        self._status = None
        self._storage_allocation_mb = None
        self._storage_limit_mb = None
        self._storage_overhead_mb = None
        self._storage_used_mb = None
        self._task = None
        self._task_details = None
        self._task_status = None
        self._task_status_name = None
        self._vc = None
        self._vc_name = None

        if allocation_model is not None:
            self.allocation_model = allocation_model
        if cpu_allocation_mhz is not None:
            self.cpu_allocation_mhz = cpu_allocation_mhz
        if cpu_limit_mhz is not None:
            self.cpu_limit_mhz = cpu_limit_mhz
        if cpu_overhead_mhz is not None:
            self.cpu_overhead_mhz = cpu_overhead_mhz
        if cpu_reserved_mhz is not None:
            self.cpu_reserved_mhz = cpu_reserved_mhz
        if cpu_used_mhz is not None:
            self.cpu_used_mhz = cpu_used_mhz
        if description is not None:
            self.description = description
        if is_busy is not None:
            self.is_busy = is_busy
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_system_vdc is not None:
            self.is_system_vdc = is_system_vdc
        if is_vc_enabled is not None:
            self.is_vc_enabled = is_vc_enabled
        if memory_allocation_mb is not None:
            self.memory_allocation_mb = memory_allocation_mb
        if memory_limit_mb is not None:
            self.memory_limit_mb = memory_limit_mb
        if memory_overhead_mb is not None:
            self.memory_overhead_mb = memory_overhead_mb
        if memory_reserved_mb is not None:
            self.memory_reserved_mb = memory_reserved_mb
        if memory_used_mb is not None:
            self.memory_used_mb = memory_used_mb
        if name is not None:
            self.name = name
        if network_pool is not None:
            self.network_pool = network_pool
        if network_pool_universal_id is not None:
            self.network_pool_universal_id = network_pool_universal_id
        if number_of_deployed_v_apps is not None:
            self.number_of_deployed_v_apps = number_of_deployed_v_apps
        if number_of_disks is not None:
            self.number_of_disks = number_of_disks
        if number_of_media is not None:
            self.number_of_media = number_of_media
        if number_of_resource_pools is not None:
            self.number_of_resource_pools = number_of_resource_pools
        if number_of_running_v_ms is not None:
            self.number_of_running_v_ms = number_of_running_v_ms
        if number_of_storage_profiles is not None:
            self.number_of_storage_profiles = number_of_storage_profiles
        if number_of_v_app_templates is not None:
            self.number_of_v_app_templates = number_of_v_app_templates
        if number_of_v_apps is not None:
            self.number_of_v_apps = number_of_v_apps
        if number_of_v_ms is not None:
            self.number_of_v_ms = number_of_v_ms
        if org is not None:
            self.org = org
        if org_name is not None:
            self.org_name = org_name
        if provider_vdc is not None:
            self.provider_vdc = provider_vdc
        if provider_vdc_name is not None:
            self.provider_vdc_name = provider_vdc_name
        if status is not None:
            self.status = status
        if storage_allocation_mb is not None:
            self.storage_allocation_mb = storage_allocation_mb
        if storage_limit_mb is not None:
            self.storage_limit_mb = storage_limit_mb
        if storage_overhead_mb is not None:
            self.storage_overhead_mb = storage_overhead_mb
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if task is not None:
            self.task = task
        if task_details is not None:
            self.task_details = task_details
        if task_status is not None:
            self.task_status = task_status
        if task_status_name is not None:
            self.task_status_name = task_status_name
        if vc is not None:
            self.vc = vc
        if vc_name is not None:
            self.vc_name = vc_name

    @property
    def allocation_model(self):
        return self._allocation_model
    
    @allocation_model.setter
    def allocation_model(self, allocation_model):
        self._allocation_model = allocation_model

    @property
    def cpu_allocation_mhz(self):
        return self._cpu_allocation_mhz
    
    @cpu_allocation_mhz.setter
    def cpu_allocation_mhz(self, cpu_allocation_mhz):
        self._cpu_allocation_mhz = cpu_allocation_mhz

    @property
    def cpu_limit_mhz(self):
        return self._cpu_limit_mhz
    
    @cpu_limit_mhz.setter
    def cpu_limit_mhz(self, cpu_limit_mhz):
        self._cpu_limit_mhz = cpu_limit_mhz

    @property
    def cpu_overhead_mhz(self):
        return self._cpu_overhead_mhz
    
    @cpu_overhead_mhz.setter
    def cpu_overhead_mhz(self, cpu_overhead_mhz):
        self._cpu_overhead_mhz = cpu_overhead_mhz

    @property
    def cpu_reserved_mhz(self):
        return self._cpu_reserved_mhz
    
    @cpu_reserved_mhz.setter
    def cpu_reserved_mhz(self, cpu_reserved_mhz):
        self._cpu_reserved_mhz = cpu_reserved_mhz

    @property
    def cpu_used_mhz(self):
        return self._cpu_used_mhz
    
    @cpu_used_mhz.setter
    def cpu_used_mhz(self, cpu_used_mhz):
        self._cpu_used_mhz = cpu_used_mhz

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_system_vdc(self):
        return self._is_system_vdc
    
    @is_system_vdc.setter
    def is_system_vdc(self, is_system_vdc):
        self._is_system_vdc = is_system_vdc

    @property
    def is_vc_enabled(self):
        return self._is_vc_enabled
    
    @is_vc_enabled.setter
    def is_vc_enabled(self, is_vc_enabled):
        self._is_vc_enabled = is_vc_enabled

    @property
    def memory_allocation_mb(self):
        return self._memory_allocation_mb
    
    @memory_allocation_mb.setter
    def memory_allocation_mb(self, memory_allocation_mb):
        self._memory_allocation_mb = memory_allocation_mb

    @property
    def memory_limit_mb(self):
        return self._memory_limit_mb
    
    @memory_limit_mb.setter
    def memory_limit_mb(self, memory_limit_mb):
        self._memory_limit_mb = memory_limit_mb

    @property
    def memory_overhead_mb(self):
        return self._memory_overhead_mb
    
    @memory_overhead_mb.setter
    def memory_overhead_mb(self, memory_overhead_mb):
        self._memory_overhead_mb = memory_overhead_mb

    @property
    def memory_reserved_mb(self):
        return self._memory_reserved_mb
    
    @memory_reserved_mb.setter
    def memory_reserved_mb(self, memory_reserved_mb):
        self._memory_reserved_mb = memory_reserved_mb

    @property
    def memory_used_mb(self):
        return self._memory_used_mb
    
    @memory_used_mb.setter
    def memory_used_mb(self, memory_used_mb):
        self._memory_used_mb = memory_used_mb

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def network_pool(self):
        return self._network_pool
    
    @network_pool.setter
    def network_pool(self, network_pool):
        self._network_pool = network_pool

    @property
    def network_pool_universal_id(self):
        return self._network_pool_universal_id
    
    @network_pool_universal_id.setter
    def network_pool_universal_id(self, network_pool_universal_id):
        self._network_pool_universal_id = network_pool_universal_id

    @property
    def number_of_deployed_v_apps(self):
        return self._number_of_deployed_v_apps
    
    @number_of_deployed_v_apps.setter
    def number_of_deployed_v_apps(self, number_of_deployed_v_apps):
        self._number_of_deployed_v_apps = number_of_deployed_v_apps

    @property
    def number_of_disks(self):
        return self._number_of_disks
    
    @number_of_disks.setter
    def number_of_disks(self, number_of_disks):
        self._number_of_disks = number_of_disks

    @property
    def number_of_media(self):
        return self._number_of_media
    
    @number_of_media.setter
    def number_of_media(self, number_of_media):
        self._number_of_media = number_of_media

    @property
    def number_of_resource_pools(self):
        return self._number_of_resource_pools
    
    @number_of_resource_pools.setter
    def number_of_resource_pools(self, number_of_resource_pools):
        self._number_of_resource_pools = number_of_resource_pools

    @property
    def number_of_running_v_ms(self):
        return self._number_of_running_v_ms
    
    @number_of_running_v_ms.setter
    def number_of_running_v_ms(self, number_of_running_v_ms):
        self._number_of_running_v_ms = number_of_running_v_ms

    @property
    def number_of_storage_profiles(self):
        return self._number_of_storage_profiles
    
    @number_of_storage_profiles.setter
    def number_of_storage_profiles(self, number_of_storage_profiles):
        self._number_of_storage_profiles = number_of_storage_profiles

    @property
    def number_of_v_app_templates(self):
        return self._number_of_v_app_templates
    
    @number_of_v_app_templates.setter
    def number_of_v_app_templates(self, number_of_v_app_templates):
        self._number_of_v_app_templates = number_of_v_app_templates

    @property
    def number_of_v_apps(self):
        return self._number_of_v_apps
    
    @number_of_v_apps.setter
    def number_of_v_apps(self, number_of_v_apps):
        self._number_of_v_apps = number_of_v_apps

    @property
    def number_of_v_ms(self):
        return self._number_of_v_ms
    
    @number_of_v_ms.setter
    def number_of_v_ms(self, number_of_v_ms):
        self._number_of_v_ms = number_of_v_ms

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def provider_vdc(self):
        return self._provider_vdc
    
    @provider_vdc.setter
    def provider_vdc(self, provider_vdc):
        self._provider_vdc = provider_vdc

    @property
    def provider_vdc_name(self):
        return self._provider_vdc_name
    
    @provider_vdc_name.setter
    def provider_vdc_name(self, provider_vdc_name):
        self._provider_vdc_name = provider_vdc_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_allocation_mb(self):
        return self._storage_allocation_mb
    
    @storage_allocation_mb.setter
    def storage_allocation_mb(self, storage_allocation_mb):
        self._storage_allocation_mb = storage_allocation_mb

    @property
    def storage_limit_mb(self):
        return self._storage_limit_mb
    
    @storage_limit_mb.setter
    def storage_limit_mb(self, storage_limit_mb):
        self._storage_limit_mb = storage_limit_mb

    @property
    def storage_overhead_mb(self):
        return self._storage_overhead_mb
    
    @storage_overhead_mb.setter
    def storage_overhead_mb(self, storage_overhead_mb):
        self._storage_overhead_mb = storage_overhead_mb

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def task(self):
        return self._task
    
    @task.setter
    def task(self, task):
        self._task = task

    @property
    def task_details(self):
        return self._task_details
    
    @task_details.setter
    def task_details(self, task_details):
        self._task_details = task_details

    @property
    def task_status(self):
        return self._task_status
    
    @task_status.setter
    def task_status(self, task_status):
        self._task_status = task_status

    @property
    def task_status_name(self):
        return self._task_status_name
    
    @task_status_name.setter
    def task_status_name(self, task_status_name):
        self._task_status_name = task_status_name

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vc_name(self):
        return self._vc_name
    
    @vc_name.setter
    def vc_name(self, vc_name):
        self._vc_name = vc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminVdcRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
