"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminVAppRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cpu_allocation_mhz': 'int',
        'creation_date': 'str',
        'is_auto_nature': 'bool',
        'is_busy': 'bool',
        'is_deployed': 'bool',
        'is_enabled': 'bool',
        'is_expired': 'bool',
        'is_in_maintenance_mode': 'bool',
        'is_vdc_enabled': 'bool',
        'memory_allocation_mb': 'int',
        'name': 'str',
        'number_of_v_ms': 'int',
        'org': 'str',
        'owner_name': 'str',
        'status': 'str',
        'storage_kb': 'int',
        'vdc': 'str',
        'vdc_name': 'str'
    }

    attribute_map = {
        'cpu_allocation_mhz': 'cpuAllocationMhz',
        'creation_date': 'creationDate',
        'is_auto_nature': 'isAutoNature',
        'is_busy': 'isBusy',
        'is_deployed': 'isDeployed',
        'is_enabled': 'isEnabled',
        'is_expired': 'isExpired',
        'is_in_maintenance_mode': 'isInMaintenanceMode',
        'is_vdc_enabled': 'isVdcEnabled',
        'memory_allocation_mb': 'memoryAllocationMB',
        'name': 'name',
        'number_of_v_ms': 'numberOfVMs',
        'org': 'org',
        'owner_name': 'ownerName',
        'status': 'status',
        'storage_kb': 'storageKB',
        'vdc': 'vdc',
        'vdc_name': 'vdcName'
    }

    def __init__(self, cpu_allocation_mhz=None,creation_date=None,is_auto_nature=None,is_busy=None,is_deployed=None,is_enabled=None,is_expired=None,is_in_maintenance_mode=None,is_vdc_enabled=None,memory_allocation_mb=None,name=None,number_of_v_ms=None,org=None,owner_name=None,status=None,storage_kb=None,vdc=None,vdc_name=None):
        self._cpu_allocation_mhz = None
        self._creation_date = None
        self._is_auto_nature = None
        self._is_busy = None
        self._is_deployed = None
        self._is_enabled = None
        self._is_expired = None
        self._is_in_maintenance_mode = None
        self._is_vdc_enabled = None
        self._memory_allocation_mb = None
        self._name = None
        self._number_of_v_ms = None
        self._org = None
        self._owner_name = None
        self._status = None
        self._storage_kb = None
        self._vdc = None
        self._vdc_name = None

        if cpu_allocation_mhz is not None:
            self.cpu_allocation_mhz = cpu_allocation_mhz
        if creation_date is not None:
            self.creation_date = creation_date
        if is_auto_nature is not None:
            self.is_auto_nature = is_auto_nature
        if is_busy is not None:
            self.is_busy = is_busy
        if is_deployed is not None:
            self.is_deployed = is_deployed
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if is_expired is not None:
            self.is_expired = is_expired
        if is_in_maintenance_mode is not None:
            self.is_in_maintenance_mode = is_in_maintenance_mode
        if is_vdc_enabled is not None:
            self.is_vdc_enabled = is_vdc_enabled
        if memory_allocation_mb is not None:
            self.memory_allocation_mb = memory_allocation_mb
        if name is not None:
            self.name = name
        if number_of_v_ms is not None:
            self.number_of_v_ms = number_of_v_ms
        if org is not None:
            self.org = org
        if owner_name is not None:
            self.owner_name = owner_name
        if status is not None:
            self.status = status
        if storage_kb is not None:
            self.storage_kb = storage_kb
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name

    @property
    def cpu_allocation_mhz(self):
        return self._cpu_allocation_mhz
    
    @cpu_allocation_mhz.setter
    def cpu_allocation_mhz(self, cpu_allocation_mhz):
        self._cpu_allocation_mhz = cpu_allocation_mhz

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_auto_nature(self):
        return self._is_auto_nature
    
    @is_auto_nature.setter
    def is_auto_nature(self, is_auto_nature):
        self._is_auto_nature = is_auto_nature

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_deployed(self):
        return self._is_deployed
    
    @is_deployed.setter
    def is_deployed(self, is_deployed):
        self._is_deployed = is_deployed

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def is_expired(self):
        return self._is_expired
    
    @is_expired.setter
    def is_expired(self, is_expired):
        self._is_expired = is_expired

    @property
    def is_in_maintenance_mode(self):
        return self._is_in_maintenance_mode
    
    @is_in_maintenance_mode.setter
    def is_in_maintenance_mode(self, is_in_maintenance_mode):
        self._is_in_maintenance_mode = is_in_maintenance_mode

    @property
    def is_vdc_enabled(self):
        return self._is_vdc_enabled
    
    @is_vdc_enabled.setter
    def is_vdc_enabled(self, is_vdc_enabled):
        self._is_vdc_enabled = is_vdc_enabled

    @property
    def memory_allocation_mb(self):
        return self._memory_allocation_mb
    
    @memory_allocation_mb.setter
    def memory_allocation_mb(self, memory_allocation_mb):
        self._memory_allocation_mb = memory_allocation_mb

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_v_ms(self):
        return self._number_of_v_ms
    
    @number_of_v_ms.setter
    def number_of_v_ms(self, number_of_v_ms):
        self._number_of_v_ms = number_of_v_ms

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_kb(self):
        return self._storage_kb
    
    @storage_kb.setter
    def storage_kb(self, storage_kb):
        self._storage_kb = storage_kb

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminVAppRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
