"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminServiceRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'exchange': 'str',
        'is_authorization_enabled': 'bool',
        'name': 'str',
        'namespace': 'str',
        'priority': 'int',
        'routing_key': 'str',
        'vendor': 'str'
    }

    attribute_map = {
        'enabled': 'enabled',
        'exchange': 'exchange',
        'is_authorization_enabled': 'isAuthorizationEnabled',
        'name': 'name',
        'namespace': 'namespace',
        'priority': 'priority',
        'routing_key': 'routingKey',
        'vendor': 'vendor'
    }

    def __init__(self, enabled=None,exchange=None,is_authorization_enabled=None,name=None,namespace=None,priority=None,routing_key=None,vendor=None):
        self._enabled = None
        self._exchange = None
        self._is_authorization_enabled = None
        self._name = None
        self._namespace = None
        self._priority = None
        self._routing_key = None
        self._vendor = None

        if enabled is not None:
            self.enabled = enabled
        if exchange is not None:
            self.exchange = exchange
        if is_authorization_enabled is not None:
            self.is_authorization_enabled = is_authorization_enabled
        if name is not None:
            self.name = name
        if namespace is not None:
            self.namespace = namespace
        if priority is not None:
            self.priority = priority
        if routing_key is not None:
            self.routing_key = routing_key
        if vendor is not None:
            self.vendor = vendor

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def exchange(self):
        return self._exchange
    
    @exchange.setter
    def exchange(self, exchange):
        self._exchange = exchange

    @property
    def is_authorization_enabled(self):
        return self._is_authorization_enabled
    
    @is_authorization_enabled.setter
    def is_authorization_enabled(self, is_authorization_enabled):
        self._is_authorization_enabled = is_authorization_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def namespace(self):
        return self._namespace
    
    @namespace.setter
    def namespace(self, namespace):
        self._namespace = namespace

    @property
    def priority(self):
        return self._priority
    
    @priority.setter
    def priority(self, priority):
        self._priority = priority

    @property
    def routing_key(self):
        return self._routing_key
    
    @routing_key.setter
    def routing_key(self, routing_key):
        self._routing_key = routing_key

    @property
    def vendor(self):
        return self._vendor
    
    @vendor.setter
    def vendor(self, vendor):
        self._vendor = vendor


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminServiceRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
