"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminMediaRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'catalog': 'str',
        'catalog_item': 'str',
        'catalog_name': 'str',
        'creation_date': 'str',
        'is_busy': 'bool',
        'is_published': 'bool',
        'is_vdc_enabled': 'bool',
        'name': 'str',
        'org': 'str',
        'owner': 'str',
        'owner_name': 'str',
        'status': 'str',
        'storage_b': 'int',
        'storage_profile_name': 'str',
        'vdc': 'str',
        'vdc_name': 'str'
    }

    attribute_map = {
        'catalog': 'catalog',
        'catalog_item': 'catalogItem',
        'catalog_name': 'catalogName',
        'creation_date': 'creationDate',
        'is_busy': 'isBusy',
        'is_published': 'isPublished',
        'is_vdc_enabled': 'isVdcEnabled',
        'name': 'name',
        'org': 'org',
        'owner': 'owner',
        'owner_name': 'ownerName',
        'status': 'status',
        'storage_b': 'storageB',
        'storage_profile_name': 'storageProfileName',
        'vdc': 'vdc',
        'vdc_name': 'vdcName'
    }

    def __init__(self, catalog=None,catalog_item=None,catalog_name=None,creation_date=None,is_busy=None,is_published=None,is_vdc_enabled=None,name=None,org=None,owner=None,owner_name=None,status=None,storage_b=None,storage_profile_name=None,vdc=None,vdc_name=None):
        self._catalog = None
        self._catalog_item = None
        self._catalog_name = None
        self._creation_date = None
        self._is_busy = None
        self._is_published = None
        self._is_vdc_enabled = None
        self._name = None
        self._org = None
        self._owner = None
        self._owner_name = None
        self._status = None
        self._storage_b = None
        self._storage_profile_name = None
        self._vdc = None
        self._vdc_name = None

        if catalog is not None:
            self.catalog = catalog
        if catalog_item is not None:
            self.catalog_item = catalog_item
        if catalog_name is not None:
            self.catalog_name = catalog_name
        if creation_date is not None:
            self.creation_date = creation_date
        if is_busy is not None:
            self.is_busy = is_busy
        if is_published is not None:
            self.is_published = is_published
        if is_vdc_enabled is not None:
            self.is_vdc_enabled = is_vdc_enabled
        if name is not None:
            self.name = name
        if org is not None:
            self.org = org
        if owner is not None:
            self.owner = owner
        if owner_name is not None:
            self.owner_name = owner_name
        if status is not None:
            self.status = status
        if storage_b is not None:
            self.storage_b = storage_b
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name

    @property
    def catalog(self):
        return self._catalog
    
    @catalog.setter
    def catalog(self, catalog):
        self._catalog = catalog

    @property
    def catalog_item(self):
        return self._catalog_item
    
    @catalog_item.setter
    def catalog_item(self, catalog_item):
        self._catalog_item = catalog_item

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def is_vdc_enabled(self):
        return self._is_vdc_enabled
    
    @is_vdc_enabled.setter
    def is_vdc_enabled(self, is_vdc_enabled):
        self._is_vdc_enabled = is_vdc_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_b(self):
        return self._storage_b
    
    @storage_b.setter
    def storage_b(self, storage_b):
        self._storage_b = storage_b

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminMediaRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
