"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class OperatingSystemInfoType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'operating_system_id': 'int',
        'default_hard_disk_adapter_type': 'DefaultHardDiskAdapterTypeType',
        'supported_hard_disk_adapter': 'list[HardDiskAdapterReferenceType]',
        'minimum_hard_disk_size_gigabytes': 'int',
        'minimum_memory_megabytes': 'int',
        'name': 'str',
        'internal_name': 'str',
        'supported': 'bool',
        'support_level': 'str',
        'x64': 'bool',
        'maximum_cpu_count': 'int',
        'maximum_cores_per_socket': 'int',
        'maximum_socket_count': 'int',
        'minimum_hardware_version': 'int',
        'personalization_enabled': 'bool',
        'personalization_auto': 'bool',
        'sysprep_packaging_supported': 'bool',
        'supports_mem_hot_add': 'bool',
        'cim_os_id': 'int',
        'cim_version': 'int',
        'supported_for_create': 'bool',
        'recommended_nic': 'NICType',
        'supported_nic_type': 'list[NICType]'
    }

    attribute_map = {
        'operating_system_id': 'operatingSystemId',
        'default_hard_disk_adapter_type': 'defaultHardDiskAdapterType',
        'supported_hard_disk_adapter': 'supportedHardDiskAdapter',
        'minimum_hard_disk_size_gigabytes': 'minimumHardDiskSizeGigabytes',
        'minimum_memory_megabytes': 'minimumMemoryMegabytes',
        'name': 'name',
        'internal_name': 'internalName',
        'supported': 'supported',
        'support_level': 'supportLevel',
        'x64': 'x64',
        'maximum_cpu_count': 'maximumCpuCount',
        'maximum_cores_per_socket': 'maximumCoresPerSocket',
        'maximum_socket_count': 'maximumSocketCount',
        'minimum_hardware_version': 'minimumHardwareVersion',
        'personalization_enabled': 'personalizationEnabled',
        'personalization_auto': 'personalizationAuto',
        'sysprep_packaging_supported': 'sysprepPackagingSupported',
        'supports_mem_hot_add': 'supportsMemHotAdd',
        'cim_os_id': 'cimOsId',
        'cim_version': 'cimVersion',
        'supported_for_create': 'supportedForCreate',
        'recommended_nic': 'recommendedNIC',
        'supported_nic_type': 'supportedNICType'
    }

    def __init__(self, operating_system_id=None,default_hard_disk_adapter_type=None,supported_hard_disk_adapter=None,minimum_hard_disk_size_gigabytes=None,minimum_memory_megabytes=None,name=None,internal_name=None,supported=None,support_level=None,x64=None,maximum_cpu_count=None,maximum_cores_per_socket=None,maximum_socket_count=None,minimum_hardware_version=None,personalization_enabled=None,personalization_auto=None,sysprep_packaging_supported=None,supports_mem_hot_add=None,cim_os_id=None,cim_version=None,supported_for_create=None,recommended_nic=None,supported_nic_type=None):
        self._operating_system_id = None
        self._default_hard_disk_adapter_type = None
        self._supported_hard_disk_adapter = None
        self._minimum_hard_disk_size_gigabytes = None
        self._minimum_memory_megabytes = None
        self._name = None
        self._internal_name = None
        self._supported = None
        self._support_level = None
        self._x64 = None
        self._maximum_cpu_count = None
        self._maximum_cores_per_socket = None
        self._maximum_socket_count = None
        self._minimum_hardware_version = None
        self._personalization_enabled = None
        self._personalization_auto = None
        self._sysprep_packaging_supported = None
        self._supports_mem_hot_add = None
        self._cim_os_id = None
        self._cim_version = None
        self._supported_for_create = None
        self._recommended_nic = None
        self._supported_nic_type = None

        if operating_system_id is not None:
            self.operating_system_id = operating_system_id
        if default_hard_disk_adapter_type is not None:
            self.default_hard_disk_adapter_type = default_hard_disk_adapter_type
        if supported_hard_disk_adapter is not None:
            self.supported_hard_disk_adapter = supported_hard_disk_adapter
        if minimum_hard_disk_size_gigabytes is not None:
            self.minimum_hard_disk_size_gigabytes = minimum_hard_disk_size_gigabytes
        if minimum_memory_megabytes is not None:
            self.minimum_memory_megabytes = minimum_memory_megabytes
        if name is not None:
            self.name = name
        if internal_name is not None:
            self.internal_name = internal_name
        if supported is not None:
            self.supported = supported
        if support_level is not None:
            self.support_level = support_level
        if x64 is not None:
            self.x64 = x64
        if maximum_cpu_count is not None:
            self.maximum_cpu_count = maximum_cpu_count
        if maximum_cores_per_socket is not None:
            self.maximum_cores_per_socket = maximum_cores_per_socket
        if maximum_socket_count is not None:
            self.maximum_socket_count = maximum_socket_count
        if minimum_hardware_version is not None:
            self.minimum_hardware_version = minimum_hardware_version
        if personalization_enabled is not None:
            self.personalization_enabled = personalization_enabled
        if personalization_auto is not None:
            self.personalization_auto = personalization_auto
        if sysprep_packaging_supported is not None:
            self.sysprep_packaging_supported = sysprep_packaging_supported
        if supports_mem_hot_add is not None:
            self.supports_mem_hot_add = supports_mem_hot_add
        if cim_os_id is not None:
            self.cim_os_id = cim_os_id
        if cim_version is not None:
            self.cim_version = cim_version
        if supported_for_create is not None:
            self.supported_for_create = supported_for_create
        if recommended_nic is not None:
            self.recommended_nic = recommended_nic
        if supported_nic_type is not None:
            self.supported_nic_type = supported_nic_type

    @property
    def operating_system_id(self):
        return self._operating_system_id
    
    @operating_system_id.setter
    def operating_system_id(self, operating_system_id):
        self._operating_system_id = operating_system_id

    @property
    def default_hard_disk_adapter_type(self):
        return self._default_hard_disk_adapter_type
    
    @default_hard_disk_adapter_type.setter
    def default_hard_disk_adapter_type(self, default_hard_disk_adapter_type):
        self._default_hard_disk_adapter_type = default_hard_disk_adapter_type

    @property
    def supported_hard_disk_adapter(self):
        return self._supported_hard_disk_adapter
    
    @supported_hard_disk_adapter.setter
    def supported_hard_disk_adapter(self, supported_hard_disk_adapter):
        self._supported_hard_disk_adapter = supported_hard_disk_adapter

    @property
    def minimum_hard_disk_size_gigabytes(self):
        return self._minimum_hard_disk_size_gigabytes
    
    @minimum_hard_disk_size_gigabytes.setter
    def minimum_hard_disk_size_gigabytes(self, minimum_hard_disk_size_gigabytes):
        self._minimum_hard_disk_size_gigabytes = minimum_hard_disk_size_gigabytes

    @property
    def minimum_memory_megabytes(self):
        return self._minimum_memory_megabytes
    
    @minimum_memory_megabytes.setter
    def minimum_memory_megabytes(self, minimum_memory_megabytes):
        self._minimum_memory_megabytes = minimum_memory_megabytes

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def internal_name(self):
        return self._internal_name
    
    @internal_name.setter
    def internal_name(self, internal_name):
        self._internal_name = internal_name

    @property
    def supported(self):
        return self._supported
    
    @supported.setter
    def supported(self, supported):
        self._supported = supported

    @property
    def support_level(self):
        return self._support_level
    
    @support_level.setter
    def support_level(self, support_level):
        self._support_level = support_level

    @property
    def x64(self):
        return self._x64
    
    @x64.setter
    def x64(self, x64):
        self._x64 = x64

    @property
    def maximum_cpu_count(self):
        return self._maximum_cpu_count
    
    @maximum_cpu_count.setter
    def maximum_cpu_count(self, maximum_cpu_count):
        self._maximum_cpu_count = maximum_cpu_count

    @property
    def maximum_cores_per_socket(self):
        return self._maximum_cores_per_socket
    
    @maximum_cores_per_socket.setter
    def maximum_cores_per_socket(self, maximum_cores_per_socket):
        self._maximum_cores_per_socket = maximum_cores_per_socket

    @property
    def maximum_socket_count(self):
        return self._maximum_socket_count
    
    @maximum_socket_count.setter
    def maximum_socket_count(self, maximum_socket_count):
        self._maximum_socket_count = maximum_socket_count

    @property
    def minimum_hardware_version(self):
        return self._minimum_hardware_version
    
    @minimum_hardware_version.setter
    def minimum_hardware_version(self, minimum_hardware_version):
        self._minimum_hardware_version = minimum_hardware_version

    @property
    def personalization_enabled(self):
        return self._personalization_enabled
    
    @personalization_enabled.setter
    def personalization_enabled(self, personalization_enabled):
        self._personalization_enabled = personalization_enabled

    @property
    def personalization_auto(self):
        return self._personalization_auto
    
    @personalization_auto.setter
    def personalization_auto(self, personalization_auto):
        self._personalization_auto = personalization_auto

    @property
    def sysprep_packaging_supported(self):
        return self._sysprep_packaging_supported
    
    @sysprep_packaging_supported.setter
    def sysprep_packaging_supported(self, sysprep_packaging_supported):
        self._sysprep_packaging_supported = sysprep_packaging_supported

    @property
    def supports_mem_hot_add(self):
        return self._supports_mem_hot_add
    
    @supports_mem_hot_add.setter
    def supports_mem_hot_add(self, supports_mem_hot_add):
        self._supports_mem_hot_add = supports_mem_hot_add

    @property
    def cim_os_id(self):
        return self._cim_os_id
    
    @cim_os_id.setter
    def cim_os_id(self, cim_os_id):
        self._cim_os_id = cim_os_id

    @property
    def cim_version(self):
        return self._cim_version
    
    @cim_version.setter
    def cim_version(self, cim_version):
        self._cim_version = cim_version

    @property
    def supported_for_create(self):
        return self._supported_for_create
    
    @supported_for_create.setter
    def supported_for_create(self, supported_for_create):
        self._supported_for_create = supported_for_create

    @property
    def recommended_nic(self):
        return self._recommended_nic
    
    @recommended_nic.setter
    def recommended_nic(self, recommended_nic):
        self._recommended_nic = recommended_nic

    @property
    def supported_nic_type(self):
        return self._supported_nic_type
    
    @supported_nic_type.setter
    def supported_nic_type(self, supported_nic_type):
        self._supported_nic_type = supported_nic_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperatingSystemInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
