"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class MultisiteSessionUserInfoType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'username': 'str',
        'full_name': 'str',
        'email': 'str',
        'member_provider_type': 'str',
        'idp_recommended_roles': 'IdpRecommendedRolesType',
        'idp_groups': 'IdpGroupsType'
    }

    attribute_map = {
        'username': 'username',
        'full_name': 'fullName',
        'email': 'email',
        'member_provider_type': 'memberProviderType',
        'idp_recommended_roles': 'idpRecommendedRoles',
        'idp_groups': 'idpGroups'
    }

    def __init__(self, username=None,full_name=None,email=None,member_provider_type=None,idp_recommended_roles=None,idp_groups=None):
        self._username = None
        self._full_name = None
        self._email = None
        self._member_provider_type = None
        self._idp_recommended_roles = None
        self._idp_groups = None

        if username is not None:
            self.username = username
        if full_name is not None:
            self.full_name = full_name
        if email is not None:
            self.email = email
        if member_provider_type is not None:
            self.member_provider_type = member_provider_type
        if idp_recommended_roles is not None:
            self.idp_recommended_roles = idp_recommended_roles
        if idp_groups is not None:
            self.idp_groups = idp_groups

    @property
    def username(self):
        return self._username
    
    @username.setter
    def username(self, username):
        self._username = username

    @property
    def full_name(self):
        return self._full_name
    
    @full_name.setter
    def full_name(self, full_name):
        self._full_name = full_name

    @property
    def email(self):
        return self._email
    
    @email.setter
    def email(self, email):
        self._email = email

    @property
    def member_provider_type(self):
        return self._member_provider_type
    
    @member_provider_type.setter
    def member_provider_type(self, member_provider_type):
        self._member_provider_type = member_provider_type

    @property
    def idp_recommended_roles(self):
        return self._idp_recommended_roles
    
    @idp_recommended_roles.setter
    def idp_recommended_roles(self, idp_recommended_roles):
        self._idp_recommended_roles = idp_recommended_roles

    @property
    def idp_groups(self):
        return self._idp_groups
    
    @idp_groups.setter
    def idp_groups(self, idp_groups):
        self._idp_groups = idp_groups


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultisiteSessionUserInfoType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
