"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class MetadataValueType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domain': 'MetadataDomainTagType',
        'value': 'str',
        'typed_value': 'MetadataTypedValue'
    }

    attribute_map = {
        'domain': 'domain',
        'value': 'value',
        'typed_value': 'typedValue'
    }

    def __init__(self, domain=None,value=None,typed_value=None):
        self._domain = None
        self._value = None
        self._typed_value = None

        if domain is not None:
            self.domain = domain
        if value is not None:
            self.value = value
        if typed_value is not None:
            self.typed_value = typed_value

    @property
    def domain(self):
        return self._domain
    
    @domain.setter
    def domain(self, domain):
        self._domain = domain

    @property
    def value(self):
        return self._value
    
    @value.setter
    def value(self, value):
        self._value = value

    @property
    def typed_value(self):
        return self._typed_value
    
    @typed_value.setter
    def typed_value(self, typed_value):
        self._typed_value = typed_value


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MetadataValueType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
