"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_entity_type import ResourceEntityType


class MediaType(ResourceEntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'OwnerType',
        'vdc_storage_profile': 'ReferenceType',
        'image_type': 'str',
        'size': 'int'
    }

    attribute_map = {
        'owner': 'owner',
        'vdc_storage_profile': 'vdcStorageProfile',
        'image_type': 'imageType',
        'size': 'size'
    }

    def __init__(self, owner=None,vdc_storage_profile=None,image_type=None,size=None):
        self._owner = None
        self._vdc_storage_profile = None
        self._image_type = None
        self._size = None

        if owner is not None:
            self.owner = owner
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if image_type is not None:
            self.image_type = image_type
        if size is not None:
            self.size = size

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def image_type(self):
        return self._image_type
    
    @image_type.setter
    def image_type(self, image_type):
        self._image_type = image_type

    @property
    def size(self):
        return self._size
    
    @size.setter
    def size(self, size):
        self._size = size


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
