"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LoadBalancerVirtualServerType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_enabled': 'bool',
        'name': 'str',
        'description': 'str',
        'interface': 'ReferenceType',
        'ip_address': 'str',
        'service_profile': 'list[LBVirtualServerServiceProfileType]',
        'logging': 'bool',
        'pool': 'str',
        'load_balancer_templates': 'list[VendorTemplateType]'
    }

    attribute_map = {
        'is_enabled': 'isEnabled',
        'name': 'name',
        'description': 'description',
        'interface': 'interface',
        'ip_address': 'ipAddress',
        'service_profile': 'serviceProfile',
        'logging': 'logging',
        'pool': 'pool',
        'load_balancer_templates': 'loadBalancerTemplates'
    }

    def __init__(self, is_enabled=None,name=None,description=None,interface=None,ip_address=None,service_profile=None,logging=None,pool=None,load_balancer_templates=None):
        self._is_enabled = None
        self._name = None
        self._description = None
        self._interface = None
        self._ip_address = None
        self._service_profile = None
        self._logging = None
        self._pool = None
        self._load_balancer_templates = None

        if is_enabled is not None:
            self.is_enabled = is_enabled
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if interface is not None:
            self.interface = interface
        if ip_address is not None:
            self.ip_address = ip_address
        if service_profile is not None:
            self.service_profile = service_profile
        if logging is not None:
            self.logging = logging
        if pool is not None:
            self.pool = pool
        if load_balancer_templates is not None:
            self.load_balancer_templates = load_balancer_templates

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def interface(self):
        return self._interface
    
    @interface.setter
    def interface(self, interface):
        self._interface = interface

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def service_profile(self):
        return self._service_profile
    
    @service_profile.setter
    def service_profile(self, service_profile):
        self._service_profile = service_profile

    @property
    def logging(self):
        return self._logging
    
    @logging.setter
    def logging(self, logging):
        self._logging = logging

    @property
    def pool(self):
        return self._pool
    
    @pool.setter
    def pool(self, pool):
        self._pool = pool

    @property
    def load_balancer_templates(self):
        return self._load_balancer_templates
    
    @load_balancer_templates.setter
    def load_balancer_templates(self, load_balancer_templates):
        self._load_balancer_templates = load_balancer_templates


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoadBalancerVirtualServerType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
