"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LBPoolServicePortType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_enabled': 'bool',
        'protocol': 'str',
        'algorithm': 'str',
        'port': 'str',
        'health_check_port': 'str',
        'health_check': 'list[LBPoolHealthCheckType]'
    }

    attribute_map = {
        'is_enabled': 'isEnabled',
        'protocol': 'protocol',
        'algorithm': 'algorithm',
        'port': 'port',
        'health_check_port': 'healthCheckPort',
        'health_check': 'healthCheck'
    }

    def __init__(self, is_enabled=None,protocol=None,algorithm=None,port=None,health_check_port=None,health_check=None):
        self._is_enabled = None
        self._protocol = None
        self._algorithm = None
        self._port = None
        self._health_check_port = None
        self._health_check = None

        if is_enabled is not None:
            self.is_enabled = is_enabled
        if protocol is not None:
            self.protocol = protocol
        if algorithm is not None:
            self.algorithm = algorithm
        if port is not None:
            self.port = port
        if health_check_port is not None:
            self.health_check_port = health_check_port
        if health_check is not None:
            self.health_check = health_check

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def protocol(self):
        return self._protocol
    
    @protocol.setter
    def protocol(self, protocol):
        self._protocol = protocol

    @property
    def algorithm(self):
        return self._algorithm
    
    @algorithm.setter
    def algorithm(self, algorithm):
        self._algorithm = algorithm

    @property
    def port(self):
        return self._port
    
    @port.setter
    def port(self, port):
        self._port = port

    @property
    def health_check_port(self):
        return self._health_check_port
    
    @health_check_port.setter
    def health_check_port(self, health_check_port):
        self._health_check_port = health_check_port

    @property
    def health_check(self):
        return self._health_check
    
    @health_check.setter
    def health_check(self, health_check):
        self._health_check = health_check


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LBPoolServicePortType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
