"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class LBPoolHealthCheckType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mode': 'str',
        'uri': 'str',
        'health_threshold': 'str',
        'unhealth_threshold': 'str',
        'interval': 'str',
        'timeout': 'str'
    }

    attribute_map = {
        'mode': 'mode',
        'uri': 'uri',
        'health_threshold': 'healthThreshold',
        'unhealth_threshold': 'unhealthThreshold',
        'interval': 'interval',
        'timeout': 'timeout'
    }

    def __init__(self, mode=None,uri=None,health_threshold=None,unhealth_threshold=None,interval=None,timeout=None):
        self._mode = None
        self._uri = None
        self._health_threshold = None
        self._unhealth_threshold = None
        self._interval = None
        self._timeout = None

        if mode is not None:
            self.mode = mode
        if uri is not None:
            self.uri = uri
        if health_threshold is not None:
            self.health_threshold = health_threshold
        if unhealth_threshold is not None:
            self.unhealth_threshold = unhealth_threshold
        if interval is not None:
            self.interval = interval
        if timeout is not None:
            self.timeout = timeout

    @property
    def mode(self):
        return self._mode
    
    @mode.setter
    def mode(self, mode):
        self._mode = mode

    @property
    def uri(self):
        return self._uri
    
    @uri.setter
    def uri(self, uri):
        self._uri = uri

    @property
    def health_threshold(self):
        return self._health_threshold
    
    @health_threshold.setter
    def health_threshold(self, health_threshold):
        self._health_threshold = health_threshold

    @property
    def unhealth_threshold(self):
        return self._unhealth_threshold
    
    @unhealth_threshold.setter
    def unhealth_threshold(self, unhealth_threshold):
        self._unhealth_threshold = unhealth_threshold

    @property
    def interval(self):
        return self._interval
    
    @interval.setter
    def interval(self, interval):
        self._interval = interval

    @property
    def timeout(self):
        return self._timeout
    
    @timeout.setter
    def timeout(self, timeout):
        self._timeout = timeout


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LBPoolHealthCheckType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
